// sitar_scan.h
// $Id: sitar_scan.h,v 1.2 2007/10/02 10:21:54 sendan Exp $
// masashi shimakura

#include<time.h>
#include<pthread.h>

#ifndef _SITAR_SCAN_H_
  #define _SITAR_SCAN_H_

  #ifndef BUF_SLEN
    #define BUF_SLEN 128
  #endif
  #ifndef BUF_LEN
    #define BUF_LEN 512
  #endif
  #ifndef IP_LEN
    #define IP_LEN 64
  #endif

  #define BUF_URL 1024

  /* RESOLV DEBUG */
//  #define RESOLV_DEBUG

  /* SMTP SCAN DEBUG */
//  #define SMTP_BUG

  /* URL SCAN DEBUG */
//  #define URL_BUG

  /* ICMP SCAN DEBUG */
//  #define ICMP_BUG

  /* UDP SCAN DEBUG */
//  #define UDP_BUG

  /* TCP DEBUG  */
//  #define TCP_BUG 

  /* TCP DHW BUG  */
//  #define DHW_BUG 

  /* SNTP BUG */
//  #define SNTP_BUG                   

  /* SSL/TSL BUG */
//  #define SSL_BUG



typedef struct stred stred_t;

struct stred{
   char back_data[1024];
   char name_data[1024];
   int time;
   int check;
   pthread_t t_ret;
   pthread_t t_chk;
// pthread_mutex_t back_data_mutex;
   };




  /* --- scan_icmp.c --- */
  char * scan_icmp(char *, char *, int, int *, int);

  /* --- scan_udpportc --- */
  char * scan_udp_connect(int , char *, char *, int, int *);

  /* --- scan_tcpport.c --- */
  char * scan_tcp_connect(int, char *, char *, int, int *);

  /* --- scan_url_connect.c --- */
  char * scan_url_connect(int, char *, char *, int, int *);

  /* --- scan_ssl_connect.c --- */
  char * scan_ssl_command(int, char *, char *, int, long int, int *, char *);
  int count_memcpy3(char out[], char * data, int start, int plus);

  /* --- scan_smtpport.c --- */
  char * scan_smtp_connect(int, char *, char *, int, int *);
  char * resolvename(char *, char *, int, unsigned long *);
  char * out_resolvename(char *, char *, int, unsigned long *);
  unsigned long resolve_name(char *name);
  time_t cert_time_get(char * data);
  char * th_resolv(char * name, char * back, int interval, int out);

  /* --- scan_dhwport.c --- */
  char * scan_dhw_connect(char *, int, char *, char *, int, int *);

  /* --- scan_sntp --- */
  char * scan_sntp_connect(int, char [], char *, int, int *);

  /* --- scan_host.c --- */
  char * scan_host(char *, char *, char *, int, int *);

  /* scan_urlport() */
  int urldompass_port(char *, char *, char *, int); 
  char * set_request(char *, char *, char *);
  int self_set_request(char *, char *, char *, int);
  char * check_recvdata(char *, char *, int *);
  int self_check_recvdata(char *, char *);

#endif


