
#include<stdio.h>
#include<signal.h>
#include<unistd.h>

#include<almemsys/almemsys.h>
#include"sitar_com.h"
#include"jpreturn.h"

// static int pids_count2[COM_LEN];
// extern int pids_count2[COM_LEN];


// threadを使わない独使用の関数


/* ------------- execom ------------- */
char * out_execom(char * com, char * buf, int interval, int out)
{
FILE * fp;
int retval;
int stat;
struct timeval tv;
fd_set rfds;
int ret = 0;
int fd;
char * errdata=COM_1;
int pid;
int gid;
int count;

fp = NULL;

for(count = 0; count < COM_LEN; count++){
   if(pids_count2[count] != 1){
      pids_count2[count] = 1;
      break;
      }
   if(count >= (COM_LEN - 1)){
      #ifdef PEXEC_MUTEX_DEBUG
      printf("PEXEC_MUTEX: execom(): exec command mutex max over!!! wait 3 sec <%d> %s\n", count, com);
      #endif
      sleep(1);
      count = 0;
      }
   }
#ifdef PEXEC_MUTEX_DEBUG
printf("PEXEC_MUTEX: out_execom(): exec command mutex no <%d> %s %d\n", count, com, &pids_count2);
#endif


if((fp = out_p_popen(fp, com, "r", &pid, &gid, out, count)) == NULL){
   buf = safe_sprintf(buf, BUF_MAX, "%s -- %s --\n", COM_2, com);
   }
else {
   fd = fileno(fp);
   #ifdef PEXEC_DEBUG
   printf("PEXEC: execom(): popen FD %d PID %d\n", fd, pid);
   #endif
   tv.tv_sec = interval;  /* timeout */
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(fd, &rfds);
      retval = select(fd + 1, &rfds,  &rfds, NULL, &tv); 
      #ifdef PEXEC_DEBUG
      fprintf(stderr, "PEXEC: execom(): SELECT %d\n", retval);
      #endif
      if(retval <= 0){
         #ifdef PEXEC_DEBUG
         printf("PEXEC: execom(): %s%s Kill PID=%d+ Limit=%d\n", errdata, com, pid, interval);
         #endif
         buf = safe_sprintf(buf, BUF_MAX,"%s%s Kill PID=%d+ Limit=%d\n",
            errdata,com,pid,interval);

         if(pid > 1){

            #ifdef PEXEC_DEBUG
            printf("PEXEC: execom(): sitar pid %d gid %d\n", getpid(), getgid());
            printf("PEXEC: execom(): popen pid %d gid %d\n", pid, gid);
            printf("PEXEC: execom(): kill  pid %d pgid %d\n", pid, getpgid(pid));
            #endif

            if(pid != getpgid(pid)){
               if(setpgid(pid, pid)){
                  fprintf(stderr,"out_execom.c: fork stpgid no chenge!");
                  }
               else{
                  if(kill((pid * -1), SIGTERM)){
                     fprintf(stderr,"child process not killd 1 -PID = %d\n", (pid * -1));
                     }
                  }
               }
            else{
               if(kill((pid * -1), SIGTERM)){
                  fprintf(stderr,"child process not killd 2 -PID = %d\n", (pid * -1));
                  }
               }

            out_p_pclose(fp, count);

            pids_count2[count] = 0;
            #ifdef PEXEC_MUTEX_DEBUG
            printf("PEXEC_MUTEX: execom(): exec command mutex no exit <%d> %s\n", count, com);
            #endif

            return buf;
            }
         } 
      if(retval >= 1){
         buf = safe_filefdcat(fd, buf, &stat, BUF_MAX, interval);
         ret = out_p_pclose(fp, count);
         break;
         }
      }
   }

pids_count2[count] = 0;
#ifdef PEXEC_MUTEX_DEBUG
printf("PEXEC_MUTEX: execom(): exec command mutex no exit <%d> %s\n", count, com);
#endif

return buf;
}




