package car;

import car.character.Character;

/**
 * プレイヤの情報を扱うクラスです。
 * @author Kumano Tatsuo
 * Created on 2004/12/11
 */
public class Player {

	/**
	 * 向き
	 */
	private double direction;

	/**
	 * 向きの変化量
	 */
	private double handle;

	/**
	 * 下キーが押されているかどうか
	 */
	private boolean isDown;

	/**
	 * 左キーが押されているかどうか
	 */
	private boolean isLeft;

	/**
	 * 右キーが押されているかどうか
	 */
	private boolean isRight;

	/**
	 * 上キーが押されているかどうか
	 */
	private boolean isUp;

	/**
	 * 直前のx座標
	 */
	private double lastX;

	/**
	 * 直前のy座標
	 */
	private double lastY;

	/**
	 * 速度
	 */
	private double speed;

	/**
	 * 横滑りの速度
	 */
	private double slideSpeed;
	
	/**
	 * x座標
	 */
	private double x;

	/**
	 * y座標
	 */
	private double y;

	/**
	 * @return Returns the direction.
	 */
	public double getDirection() {
		return this.direction;
	}

	/**
	 * @return 向きの変化量
	 */
	public double getHandle() {
		return this.handle;
	}

	/**
	 * @return 直前のx座標
	 */
	public double getLastX() {
		return this.lastX;
	}

	/**
	 * @return 直前のy座標
	 */
	public double getLastY() {
		return this.lastY;
	}

	/**
	 * @return Returns the speed.
	 */
	public double getSpeed() {
		return this.speed;
	}

	/**
	 * @return Returns the x.
	 */
	public double getX() {
		return this.x;
	}

	/**
	 * @return Returns the y.
	 */
	public double getY() {
		return this.y;
	}

	/**
	 * @return Returns the isDown.
	 */
	public boolean isDown() {
		return this.isDown;
	}

	/**
	 * @return Returns the isLeft.
	 */
	public boolean isLeft() {
		return this.isLeft;
	}

	/**
	 * @return Returns the isRight.
	 */
	public boolean isRight() {
		return this.isRight;
	}

	/**
	 * @return Returns the isUp.
	 */
	public boolean isUp() {
		return this.isUp;
	}

	/**
	 * @param direction The direction to set.
	 */
	public void setDirection(double direction) {
		if (direction <= -Math.PI) {
			direction += Math.PI * 2;
		}
		if (direction > Math.PI) {
			direction -= Math.PI * 2;
		}
		this.direction = direction;
	}

	/**
	 * @param isDown The isDown to set.
	 */
	public void setDown(boolean isDown) {
		this.isDown = isDown;
	}

	/**
	 * @return 横滑りの速度
	 */
	public double getSlideSpeed() {
		return this.slideSpeed;
	}

	/**
	 * @param slideSpeed 横滑りの速度
	 */
	public void setSlideSpeed(double slideSpeed) {
		this.slideSpeed = slideSpeed;
	}

	/**
	 * @param handle 向きの変化量
	 */
	public void setHandle(double handle) {
		this.handle = handle;
	}

	/**
	 * @param isLeft The isLeft to set.
	 */
	public void setLeft(boolean isLeft) {
		this.isLeft = isLeft;
	}

	/**
	 * @param isRight The isRight to set.
	 */
	public void setRight(boolean isRight) {
		this.isRight = isRight;
	}

	/**
	 * @param speed The speed to set.
	 */
	public void setSpeed(double speed) {
		this.speed = speed;
	}

	/**
	 * @param isUp The isUp to set.
	 */
	public void setUp(boolean isUp) {
		this.isUp = isUp;
	}

	/**
	 * @param x The x to set.
	 */
	public void setX(double x) {
		this.lastX = this.x;
		this.x = x;
	}

	/**
	 * @param y The y to set.
	 */
	public void setY(double y) {
		this.lastY = this.y;
		this.y = y;
	}

	/**
	 * 個性
	 */
	private Character character;

	/**
	 * @return 個性
	 */
	public Character getCharacter() {
		return this.character;
	}

	/**
	 * @param character 個性
	 */
	public void setCharacter(Character character) {
		this.character = character;
	}
	
	/**
	 * x軸方向の平行移動
	 */
	private double dx;
	
	/**
	 * y軸方向の平行移動
	 */
	private double dy;

	/**
	 * @return x軸方向の平行移動
	 */
	public double getDx() {
		return this.dx;
	}

	/**
	 * @param dx x軸方向の平行移動
	 */
	public void setDx(double dx) {
		this.dx = dx;
	}

	/**
	 * @return y軸方向の平行移動
	 */
	public double getDy() {
		return this.dy;
	}

	/**
	 * @param dy y軸方向の平行移動
	 */
	public void setDy(double dy) {
		this.dy = dy;
	}

}
