package common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * パスワードの暗号化を行うユーティリティクラスです。
 * http://oshiete1.goo.ne.jp/kotaeru.php3?q=1085109
 * @author anmochi（http://oshiete1.goo.ne.jp/user.php3?u=215922）
 * Created on 04-11-15 17:04
 * modified on 2005/01/22 13:22:03 by Kumano Tatsuo
 */
public class Sha {
    /**
     * パスワードを暗号化した文字列を取得します。
     * @param pass パスワード
     * @return 文字列
     */
    public static String digest(char[] pass) {
        byte[] original = new byte[pass.length];
        for (int i = 0; i < pass.length; ++i) {
            original[i] = (byte) pass[i];
        }
        return digest(original);
    }

    /**
     * パスワードを暗号化した文字列を取得します。
     * @param pass パスワード
     * @return 文字列
     */
    public static String digest(byte[] pass) {
        try {
            StringBuilder ret = new StringBuilder();
            byte[] digest;
            digest = MessageDigest.getInstance("SHA-512").digest(pass);
            for (int i = 0; i < digest.length; ++i) {
                ret.append(Integer.toHexString((digest[i] >> 4) & 0x0f));
                ret.append(Integer.toHexString(digest[i] & 0x0f));
            }
            return ret.toString();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }
}
