package common;

/**
 * 定数を扱うクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/18 22:32:40
 */
public class CommonConstants {
    /**
     * ブロックがない状態
     */
    public static final byte DATA_NO_BLOCK = 0;

    /**
     * 壊せないブロック
     */
    public static final byte DATA_HARD_BLOCK = 1;

    /**
     * 壊せるブロック
     */
    public static final byte DATA_SOFT_BLOCK = 2;

    /**
     * アイテム
     */
    public static final byte DATA_ITEM = 3;

    /**
     * 通信に使用するポート
     */
    public static final int CONNECTION_PORT = 5632;

    /**
     * ステージの幅
     */
    public static final byte STAGE_WIDTH = 23;

    /**
     * ステージの高さ
     */
    public static final byte STAGE_HEIGHT = 23;

    /**
     * 名前に使えない表現
     */
    public static final String TABOO_EXPRESSION = "[^_0-9a-zA-Zー０-９ぁ-んァ-ン]";

    /**
     * 名前の文字数
     */
    public static final int NAME_LENGTH = 8;

    /**
     * 名前を伝えるコマンド（次にString name）クライアント→サーバ
     */
    public static final byte COMMAND_MY_NAME = 0;

    /**
     * パスワードを伝えるコマンド（次にString pass）クライアント→サーバ
     */
    public static final byte COMMAND_MY_PASS = 1;

    /**
     * 左キーが押されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_LEFT_PRESSED = 50;

    /**
     * 右キーが押されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_RIGHT_PRESSED = 51;

    /**
     * 上キーが押されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_UP_PRESSED = 52;

    /**
     * 下キーが押されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_DOWN_PRESSED = 53;

    /**
     * 爆弾キーが押されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_BOMB_PRESSED = 54;

    /**
     * 移動キーが離されたことを伝えるコマンド、クライアント→サーバ
     */
    public static final byte COMMAND_KEY_RELEASED = 55;
    
    /**
     * クライアントの番号を伝えるコマンド（次にint number）サーバ→クライアント
     */
    public static final byte COMMAND_YOUR_NUMBER = 100;

    /**
     * プレイヤの名前を伝えるコマンド（続いてint number、String name）サーバ→クライアント
     */
    public static final byte COMMAND_PLAYER_NAME = 101;

    /**
     * プレイヤの位置を伝えるコマンド（続いてint number、int time、byte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_PLAYER_LOCATION = 102;

    /**
     * 爆弾の位置を伝えるコマンド（続いてint number、int time、byte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_BOMB_LOCATION = 103;

    /**
     * プレイヤが死んだことを伝えるコマンド（続いてint number）サーバ→クライアント
     */
    public static final byte COMMAND_PLAYER_DEAD = 104;

    /**
     * ブロックがないことを伝えるコマンド（続いてbyte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_DATA_NO_BLOCK = 105;

    /**
     * 壊せないブロックがあることを伝えるコマンド（続いてbyte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_DATA_HARD_BLOCK = 106;

    /**
     * 壊せるブロックがあることを伝えるコマンド（続いてbyte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_DATA_SOFT_BLOCK = 107;

    /**
     * アイテムがあることを伝えるコマンド（続いてbyte row、byte col）サーバ→クライアント
     */
    public static final byte COMMAND_DATA_ITEM = 108;

    /**
     * プレイヤのレートを伝えるコマンド（続いてint number、int rate）サーバ→クライアント
     */
    public static final byte COMMAND_PLAYER_RATE = 109;

    /**
     * 爆弾が爆発したことを伝えるコマンド（続いてint number）サーバ→クライアント
     */
    public static final byte COMMAND_BOMB_BLOW = 110;

    /**
     * 炎の位置を伝えるコマンド（続いてbyte row、byte col、byte length）
     */
    public static final byte COMMAND_HORIZONTAL_BLOW = 111;
    
    /**
     * 炎の位置を伝えるコマンド（続いてbyte row、byte col、byte length）
     */
    public static final byte COMMAND_VERTICAL_BLOW = 112;
    
    
}
