package client;

import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import common.CommonConstants;

/**
 * クライアントの定数を集めたクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/02/19 13:58:16
 */
public class ClientConstants {
    /**
     * 画面の幅
     */
    static final int SCREEN_WIDTH = 640;

    /**
     * 画面の高さ
     */
    public static final int SCREEN_HEIGHT = 480;

    /**
     * 1つの升目の幅[px]
     */
    static final int GRID_WIDTH = 20;

    /**
     * 1つの升目の高さ[px]
     */
    public static final int GRID_HEIGHT = 20;

    /**
     * 上側の余白
     */
    static final int TOP_MARGIN = 15;

    /**
     * 下側の余白
     */
    static final int BOTTOM_MARGIN = 0;

    /**
     * 左側の余白
     */
    static final int LEFT_MARGIN = 10;

    /**
     * 中央の余白
     */
    static final int CENTER_MARGIN = 10;

    /**
     * 右側の余白
     */
    static final int RIGHT_MARGIN = 10;

    /**
     * メインパネルの幅
     */
    public static final int MAIN_PANEL_WIDTH = ClientConstants.LEFT_MARGIN
            + ClientConstants.GRID_WIDTH * CommonConstants.STAGE_WIDTH
            + ClientConstants.CENTER_MARGIN;

    /**
     * サブパネルの幅
     */
    public static final int SUB_PANEL_WIDTH = ClientConstants.SCREEN_WIDTH
            - ClientConstants.MAIN_PANEL_WIDTH;

    /**
     * クライアントのキー入力待ち時間
     */
    public static final int KEY_HANDLER_THREAD_WAIT_TIME = 50;

    /**
     * キーが離されるまでの待ち時間
     */
    static final int KEY_RELEASE_TIME = 50;

    /**
     * パネルを再描画するまでの待ち時間
     */
    static final int REPAINT_WAIT_TIME = 50;

    /**
     * サブパネルを再描画するまでの待ち時間
     */
    static final int SUB_PANEL_REPAINT_WAIT_TIME = 1000;

    /**
     * 移動のときのなめらかさ
     */
    static final int RESOLUTION = 100;

    /**
     * 背景画像
     */
    static final Image IMAGE_BACKGROUND = Toolkit.getDefaultToolkit().createImage(
            ClientConstants.class.getResource("shiba.png"));

    /**
     * 壊せないブロックの画像
     */
    static final Image[] IMAGE_HARD_BLOCKS = {
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("tree1.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("tree2.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("tree3.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("tree3.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("tree4.png")),
            Toolkit.getDefaultToolkit()
                    .createImage(ClientConstants.class.getResource("block1.png")),
            Toolkit.getDefaultToolkit()
                    .createImage(ClientConstants.class.getResource("block2.png")),
            Toolkit.getDefaultToolkit()
                    .createImage(ClientConstants.class.getResource("block3.png")) };

    /**
     * 壊せないブロックのオフセット
     */
    static final Point OFFSET_HARD_BLOCK = new Point(0, -10);

    /**
     * 壊せるブロックの画像
     */
    static final Image[] IMAGE_SOFT_BLOCKS = {
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("corn.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("corn2.png")),
            Toolkit.getDefaultToolkit().createImage(ClientConstants.class.getResource("corn3.png")) };

    /**
     * 壊せるブロックのオフセット
     */
    static final Point OFFSET_SOFT_BLOCK = new Point(0, -5);

    /**
     * 縦方向に回転する爆弾の画像
     */
    static final Image[] IMAGE_BOMS_VERTICAL = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-00.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-01.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-02.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-03.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-04.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-05.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-06.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-07.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-08.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-09.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-10.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-11.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-12.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-13.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-14.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-15.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-16.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-17.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-18.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-19.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-20.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-21.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-22.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-23.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-24.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-25.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-26.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-27.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-28.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-29.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-30.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-31.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-32.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-33.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-34.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-35.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-36.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-37.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-38.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-vertical-39.png")) };

    /**
     * 横方向に回転する爆弾の画像
     */
    static final Image[] IMAGE_BOMS_HORIZONTAL = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-00.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-01.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-02.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-03.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-04.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-05.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-06.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-07.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-08.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-09.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-10.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-11.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-12.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-13.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-14.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-15.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-16.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-17.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-18.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-19.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-20.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-21.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-22.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-23.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-24.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-25.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-26.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-27.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-28.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-29.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-30.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-31.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-32.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-33.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-34.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-35.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-36.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-37.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-38.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("ball-horizontal-39.png")) };

    /**
     * 爆弾のオフセット
     */
    static final Point OFFSET_BOMB = new Point(0, -3);

    /**
     * 下向きに移動するプレイヤの画像
     */
    static final Image[] IMAGE_PLAYERS_DOWN = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune0.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune1.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune2.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune1.png")) };
    /**
     * 上向きに移動するプレイヤの画像
     */
    static final Image[] IMAGE_PLAYERS_UP = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune6.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune7.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune8.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune7.png")) };

    /**
     * 左向きに移動するプレイヤの画像
     */
    static final Image[] IMAGE_PLAYERS_LEFT = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune4.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune3.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune5.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune3.png")) };

    /**
     * 右向きに移動するプレイヤの画像
     */
    static final Image[] IMAGE_PLAYERS_RIGHT = {
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune10.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune9.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune11.png")),
            Toolkit.getDefaultToolkit().createImage(
                    ClientConstants.class.getResource("kitsune9.png")) };

    /**
     * プレイヤのオフセット
     */
    static final Point OFFSET_PLAYER = new Point(0, -14);

    /**
     * 炎の画像
     */
    static final Image IMAGE_BLOW = Toolkit.getDefaultToolkit().createImage(
            ClientConstants.class.getResource("fire.png"));

    /**
     * 炎のオフセット
     */
    static final Point OFFSET_BLOW = new Point(0, -10);

    /**
     * 向きを表す定数です。
     * @author Kumano Tatsuo
     * Created on 2005/02/24 17:12:01
     */
    enum Direction {
        /**
         * 上向き
         */
        UP, /**
         * 下向き
         */
        DOWN, /**
         * 左向き
         */
        LEFT, /**
         * 右向き
         */
        RIGHT
    };
}
