
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;
import server.Game;
import server.Player;
import common.CommonConstants;

/**
 * サーバのメインクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/18 22:13:55
 */
public class Server {
    /**
     * メインメソッドです。
     * @param args コマンドライン引数
     */
    public static void main(String[] args) {
        System.out.println("LOG: server started on " + Calendar.getInstance().getTime());
        while (true) {
            try {
                final ServerSocket serverSocket = new ServerSocket(CommonConstants.CONNECTION_PORT);
                final Game game = new Game();
                game.start();
                int number = 0;
                while (true) {
                    final Socket socket = serverSocket.accept();
                    System.out.println("LOG: accepted connection from " + socket.getInetAddress()
                            + " on " + Calendar.getInstance().getTime());
                    final DataInputStream in = new DataInputStream(socket.getInputStream());
                    final DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                    final Player player = new Player(in, out, number++);
                    game.add(player);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
