import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * セブンイレブンの住所を取得するプログラムです。
 * @author Kumano Tatsuo
 * 2005/11/27
 */
public class SEJ {
	/**
	 * @param args
	 * @throws IOException 
	 * @throws MalformedURLException 
	 * @throws UnsupportedEncodingException 
	 * @throws InterruptedException 
	 */
	public static void main(String[] args) throws UnsupportedEncodingException,
			MalformedURLException, IOException, InterruptedException {
		final Random random = new Random();
		final Scanner scanner = new Scanner(
				new InputStreamReader(
						new URL(
								"http://gis.e-map.co.jp/standard/13125010/ssactl.htm?X_shop_id=40000&X_cancel_url=http%3A%2F%2Fwww.sej.co.jp%2F&GO.x=16&GO.y=5")
								.openStream(), "EUC-JP"));
		while (scanner.hasNextLine()) {
			final String line = scanner.nextLine();
			for (final String string : line.split("</A>")) {
				//System.out.println(line);
				final Pattern pattern = Pattern
						.compile("<A HREF=\"(ssactl.htm\\?ENC=.+)\">([^ ]+)");
				final Matcher matcher = pattern.matcher(string);
				if (matcher.find()) {
					Thread.sleep(random.nextInt(10000));
					final Scanner scanner2 = new Scanner(new InputStreamReader(new URL(
							"http://gis.e-map.co.jp/standard/13125010/" + matcher.group(1))
							.openStream(), "EUC-JP"));
					String prefecture = matcher.group(2);
					while (scanner2.hasNextLine()) {
						final String line2 = scanner2.nextLine();
						//System.out.println(line2);
						final Pattern pattern2 = Pattern
								.compile("<IMG SRC=\"img/ken/[0-9]+.gif\" WIDTH=\"[0-9]+\" ALT=\"([^> ]+) +\">");
						final Matcher matcher2 = pattern2.matcher(line2);
						if (matcher2.find()) {
							prefecture = matcher2.group(1);
							//System.out.println("DEBUG: prefecture = " + prefecture);
						}
						for (final String string2 : line2.split("</A>")) {
							if (!string2.contains("#")) {
								final Pattern pattern3 = Pattern
										.compile("<A HREF=\"(ssactl.htm\\?ENC=.+)\">(.+)");
								final Matcher matcher3 = pattern3.matcher(string2);
								String city = null;
								if (matcher3.find()) {
//									System.out.println("DEBUG: getting " + matcher3.group(1) + "->"
//											+ matcher3.group(2));
									city = matcher3.group(2);
									Thread.sleep(random.nextInt(10000));
									final URL url = new URL(
											"http://gis.e-map.co.jp/standard/13125010/"
													+ matcher3.group(1));
									//									System.out.println("DEBUG: url = " + url);
									final Scanner scanner3 = new Scanner(new InputStreamReader(url
											.openStream(), "EUC-JP"));
									String caption = null;
									String address = null;
									boolean isFirst = false;
									while (scanner3.hasNextLine()) {
										final String line3 = scanner3.nextLine();
										//System.out.println("DEBUG: line3 = " + line3);
										final Pattern pattern4 = Pattern
												.compile("(.+)</B></A></TD>");
										final Matcher matcher4 = pattern4.matcher(line3);
										if (matcher4.find()) {
//											System.out.println("DEBUG: caption = "
//													+ matcher4.group(1));
											caption = matcher4.group(1);
											isFirst = true;
										}
										final Pattern pattern5 = Pattern
												.compile("<FONT .+>(.+)</FONT>");
										final Matcher matcher5 = pattern5.matcher(line3);
										if (matcher5.find()) {
											if (isFirst) {
//												System.out.println("DEBUG: address = "
//														+ matcher5.group(1));
												address = matcher5.group(1);
												if (prefecture != null && city != null
														&& caption != null && address != null) {
													System.out.println(prefecture + "," + city
															+ "," + address + "," + caption);
												}
												isFirst = false;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}
