import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;
import map.Const;
import web.WebUtilities;

/**
 * テストプログラムです。
 * @author Kumano Tatsuo
 * Created on 2005/05/07 16:02:54
 */
public class Test {

    /**
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("検索文字列を含むファイルをcacheディレクトリにダウンロードします。");
            System.out.println("usage: java Test 検索文字列");
            System.exit(1);
        }
        final String keyword = args[0];
        final String baseURL = Const.BASE_URL;
        final String cacheDir = Const.CACHE_DIR;
        final Map<String, Map<String, String>> files = WebUtilities
                .loadFileList(Const.FILE_LIST);
        final Collection<URL> urls = new ArrayList<URL>();
        for (final Map.Entry<String, Map<String, String>> entry : files
                .entrySet()) {
            final String prefecture = entry.getKey();
            for (final Map.Entry<String, String> entry2 : entry.getValue()
                    .entrySet()) {
                final String city = entry2.getKey();
                final String filename = entry2.getValue();
                if (prefecture.contains(keyword) || city.contains(keyword)) {
                    System.out.println("DEBUG: " + prefecture + city + "="
                            + filename);
                    urls.add(new URL(baseURL + filename));
                }
            }
        }
        final Collection<File> cachedFiles = new ArrayList<File>();
        for (URL url : urls) {
            final String[] separetedPath = url.getPath().split("/");
            if (separetedPath.length == 4) {
                final String prefecture = separetedPath[2];
                final String filename = separetedPath[3];
                new File(cacheDir + File.separator + prefecture).mkdirs();
                final File outFile = new File(cacheDir + File.separator
                        + prefecture + File.separator + filename);
                if (outFile.exists()
                        && url.openConnection().getContentLength() == outFile
                                .length()) {
                    System.out.println("INFO: skipped " + url + " -> "
                            + outFile);
                } else {
                    System.out.println("INFO: downloading " + url + " -> "
                            + outFile);
                    WebUtilities.copy(url.openStream(), new FileOutputStream(
                            outFile));
                }
                cachedFiles.add(outFile);
            }
        }
        for (File file : cachedFiles) {
            System.out.println("INFO: extracting " + file);
            final String[] separatedPath = file.getPath().split(File.separator);
            if (separatedPath.length == 3) {
                final String prefecture = separatedPath[1];
                final LhaInputStream in = new LhaInputStream(
                        new FileInputStream(file));
                LhaHeader entry;
                while ((entry = in.getNextEntry()) != null) {
                    final String path = cacheDir + File.separator + prefecture
                            + File.separator + entry.getPath();
                    final File outFile = new File(path);
                    if (path.endsWith(File.separator)) {
                        outFile.mkdir();
                    } else {
                        if (!outFile.exists()
                                || entry.getOriginalSize() != outFile.length()) {
                            WebUtilities
                                    .copy(in, new FileOutputStream(outFile));
                        }
                    }
                }
            }
        }
    }

}
