import java.awt.*;
import java.awt.geom.*;
/*
 * : 2003/10/25
 */
/**
 * ɽǽ GeneralPath 饹Ǥ
 * @author Kumano Tatsuo
 */
public class DrawableGeneralPath implements Drawable, Shape, Comparable {
	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param args ޥɥ饤
	 */
	public static void main(String[] args) {
	}

	private double alpha;
	private Color borderColor;
	private Color fillColor;
	private Font font;
	private boolean isIncomplete;
	private String label;
	private Point2D labelLocation;
	private Point2D location;
	private GeneralPath path;
	private Color pointColor;
	private double pointSize;
	private int zOrder;

	public DrawableGeneralPath(Shape s){
		path = new GeneralPath(s);
		label = "";
		setZOrder(0);
		setBorderColor(Color.BLACK);
		setFillColor(Color.BLACK);
		setPointColor(Color.BLACK);
		setPointSize(4);
		labelLocation = new Point2D.Double();
		location = new Point2D.Double();
		setAlpha(1);
		setFont(new Font("default", Font.PLAIN, 10));
	}

	/**
	 *  GeneralPath ޤ
	 */
	public DrawableGeneralPath() {
		path = new GeneralPath();
		label = "";
		setZOrder(0);
		setBorderColor(Color.BLACK);
		setFillColor(Color.BLACK);
		setPointColor(Color.BLACK);
		setPointSize(4);
		labelLocation = new Point2D.Double();
		location = new Point2D.Double();
		setAlpha(1);
		setFont(new Font("default", Font.PLAIN, 10));
	}
	/* ( Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if (getZOrder() == ((Drawable) o).getZOrder()) {
			return hashCode() - o.hashCode();
		} else {
			return getZOrder() - ((Drawable) o).getZOrder();
		}
	}
	public double getAlpha() {
		return alpha;
	}
	public Color getBorderColor() {
		return this.borderColor;
	}
	public Color getFillColor() {
		return this.fillColor;
	}
	/**
	 * @return
	 */
	public Font getFont() {
		return font;
	}
	/* ( Javadoc)
	 * @see Drawable#getLabel()
	 */
	public String getLabel() {
		return label;
	}
	/* ( Javadoc)
	 * @see Drawable#getLabelLocation()
	 */
	public Point2D getLabelLocation() {
		return labelLocation;
	}
	/**
	 * ɽκɸޤ
	 * @return ɽκɸ
	 */
	public Point2D getLocation() {
		return location;
	}
	/**
	 * ɽɽοޤ
	 * @return ɽɽο
	 */
	public Color getPointColor() {
		return pointColor;
	}
	/**
	 * ɽɽ礭ޤ
	 * @return ɽɽ礭
	 */
	public double getPointSize() {
		return pointSize;
	}

	/**
	 * ɽ x ɸޤ
	 * @return ɽ x ɸ
	 */
	public double getX() {
		return location.getX();
	}
	/**
	 * ɽ y ɸޤ
	 * @return ɽ y ɸ
	 */
	public double getY() {
		return location.getY();
	}
	/* ( Javadoc)
	 * @see Drawable#getZOrder()
	 */
	public int getZOrder() {
		return this.zOrder;
	}
	/**
	 * Υݥꥴ̤Ǥ뤫ɤޤ
	 * @return Υݥꥴ̤Ǥ뤫ɤ
	 */
	public boolean isIncomplete() {
		return isIncomplete;
	}
	public void setAlpha(double d) {
		alpha = d;
	}
	public void setBorderColor(Color color) {
		this.borderColor = color;
	}
	public void setFillColor(Color color) {
		this.fillColor = color;
	}
	/**
	 * @param font
	 */
	public void setFont(Font font) {
		this.font = font;
	}
	/**
	 * Υݥꥴ̤Ǥ뤫ɤꤷޤ
	 * @param b Υݥꥴ̤Ǥ뤫ɤ
	 */
	public void setIncomplete(boolean b) {
		isIncomplete = b;
	}
	/* ( Javadoc)
	 * @see Drawable#setLabel(java.lang.String)
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	/* ( Javadoc)
	 * @see Drawable#setLabelLocation(java.awt.geom.Point2D)
	 */
	public void setLabelLocation(Point2D location) {
		labelLocation = location;
	}
	/**
	 * ɽκɸꤷޤ
	 * @param x ɽ x ɸ
	 * @param y ɽ y ɸ
	 */
	public void setLocation(double x, double y) {
		location.setLocation(x, y);
	}
	/**
	 * ɽκɸꤷޤ
	 * @param point2D ɽκɸ
	 */
	public void setLocation(Point2D point2D) {
		location = point2D;
	}
	/**
	 * ɽɽοꤷޤ
	 * @param color ɽɽο
	 */
	public void setPointColor(Color color) {
		pointColor = color;
	}
	/**
	 * ɽɽ礭ꤷޤ
	 * @param d ɽɽ礭
	 */
	public void setPointSize(double d) {
		pointSize = d;
	}

	/* ( Javadoc)
	 * @see Drawable#setZOrder(int)
	 */
	public void setZOrder(int zOrder) {
		this.zOrder = zOrder;
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#contains(double, double, double, double)
	 */
	public boolean contains(double x, double y, double w, double h) {
		return path.contains(x,y,w,h);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#contains(double, double)
	 */
	public boolean contains(double x, double y) {
		return path.contains(x, y);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#contains(java.awt.geom.Point2D)
	 */
	public boolean contains(Point2D p) {
		return path.contains(p);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#contains(java.awt.geom.Rectangle2D)
	 */
	public boolean contains(Rectangle2D r) {
		return path.contains(r);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#getBounds()
	 */
	public Rectangle getBounds() {
		return path.getBounds();
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#getBounds2D()
	 */
	public Rectangle2D getBounds2D() {
		return path.getBounds2D();
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#getPathIterator(java.awt.geom.AffineTransform, double)
	 */
	public PathIterator getPathIterator(AffineTransform at, double flatness) {
		return path.getPathIterator(at, flatness);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#getPathIterator(java.awt.geom.AffineTransform)
	 */
	public PathIterator getPathIterator(AffineTransform at) {
		return path.getPathIterator(at);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#intersects(double, double, double, double)
	 */
	public boolean intersects(double x, double y, double w, double h) {
		return path.intersects(x, y, w, h);
	}

	/* ( Javadoc)
	 * @see java.awt.Shape#intersects(java.awt.geom.Rectangle2D)
	 */
	public boolean intersects(Rectangle2D r) {
		return path.contains(r);
	}

}
