# xpkg: Package build system for X/Qt project
#
# Copyright (C) 2003-2005 Takuya Murakami
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#
# ifstack : %if  %elsif  %else  %endif ν
#
# parse ᥽åɤ˹Ԥ򿩤碌ȡ if ˹פƤ뤫ɤ֤
#

class IfStack
    # ơ
    NotMatch = 0	# if פƤʤ
    Match = 1		# פƤ
    Matched = 2		# פʸߤϹפƤʤ)

    def initialize(target)
	# @stack  %if ֤Υå
	@stack = Array.new
	@target = target
    end

    # ץå
    def match?
	@stack.each do |s|
	    return false if (s != Match)
	end
	return true
    end

    # ƥΥå
    def checktarget(cond)
	#
	# ruby μѴ eval ɾ
	#
	cond.gsub!(/\w+/) {|w|
	    if (w == @target)
		"true"
	    else
		"false"
	    end
	}
	cond.gsub!(/,/, '||')

	if (eval(cond))
	    return Match
	end
	return NotMatch
    end

    # ԤΥѡȽ
    def parse(line)

	if (line =~ /^(\S+)\s*(.*)$/)
	    case ($1)
	    when "%if"
		@stack.push( checktarget($2) )
		return false

	    when "%elsif", "%elif"
		s = @stack.pop
		if (s == NotMatch)
		    @stack.push( checktarget($2) )
		else
		    @stack.push( Matched )
		end
		return false

	    when "%else"
		s = @stack.pop
		if (s == NotMatch)
		    @stack.push(Match)
		else
		    @stack.push(Matched)
		end
		return false

	    when "%endif"
		@stack.pop
		return false
	    end
	end

	return match?
    end
end
