<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * 画像アップロードクラス
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Userinf_Action_Main_Upload_Image extends Action
{
	// リクエストパラメータを受け取るため
	var $unique_id = null;
	var $item_id = null;
	var $public_flag = null;
	
	// バリデートによりセット
	var $items = null;
	
	// 使用コンポーネントを受け取るため
	var $session = null;
	var $usersView = null;
	var $usersAction = null;
	var $uploadsAction = null;
	
	//値をセットするため
	//var $filelist = array();
	
	/**
     * アップロードメイン表示クラス
     *
     * @access  public
     */
    function execute()
    {
    	//ガーベージフラグ更新
		$garbage_flag = _ON;
    	$filelist = $this->uploadsAction->uploads($garbage_flag, "", array(_UPLOAD_THUMBNAIL_MAX_WIDTH_IMAGE, _UPLOAD_THUMBNAIL_MAX_HEIGHT_IMAGE));
    	
    	if(isset($filelist[0])) {
    		$content = "?action=".$filelist[0]['action_name']."&upload_id=".$filelist[0]['upload_id'];
	    	// TODO:User_Action_Main_Initと一部同じ内容が書いてある
	    	// 共通処理にするほうが望ましい
	    	//$user_id = $this->session->getParameter("_user_id");
	    	$user_id = $this->unique_id;
    		if($user_id == "0") return true;
    	
	    	$users_item_links =& $this->usersView->getUserItemLinkById($user_id, $this->items['item_id']);
			if(isset($users_item_links['user_id'])) {
				//以前のアバターの画像削除
				$upload_path = $users_item_links['content'];
				$pathList = explode("&", $upload_path);
				if(isset($pathList[1])) {
					$upload_id = intval(str_replace("upload_id=","", $pathList[1]));
					$result = $this->uploadsAction->delUploadsById($upload_id);
					if ($result === false) return false;
				}
				//更新
				$where_params = array("user_id" => $user_id, "item_id" => $this->items['item_id']);
				$result = $this->usersAction->updUsersItemsLink(array("content" => $content), $where_params);
				if ($result === false) return false;
			} else {
				$params = array(
									"user_id" => $user_id,
									"item_id" => $this->items['item_id'],
									"public_flag" => intval($this->public_flag),
									"email_reception_flag" => _OFF,
									"content" => $content
								);
				//新規追加
				$result = $this->usersAction->insUserItemLink($params);
				if ($result === false) return false;
			}
			//更新日時更新
			$where_params = array("user_id" => $user_id);
			$result = $this->usersAction->updUsers(array(), $where_params, true);
			if ($result === false) return false;
			
			//ガーベージフラグ更新
			$garbage_flag = _OFF;
			$result = $this->uploadsAction->updGarbageFlag($filelist[0]['upload_id'], $garbage_flag);
			if ($result === false) return false;
    	}
    	return true;
    }
}
?>
