<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Todoメイン画面表示アクションクラス
 *
 * @package	 NetCommons
 * @author	  Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license	 http://www.netcommons.org/license.txt  NetCommons License
 * @project	 NetCommons Project, supported by National Institute of Informatics
 * @access	  public
 */
class Todo_View_Main_Init extends Action
{
	// パラメータを受け取るため
	var $block_id = null;
	var $target_state = null;

	// 使用コンポーネントを受け取るため
	var $todoView = null;
	var $request = null;
	var $filterChain = null;
	var $session = null;
	var $mobileView = null;

	// validatorから受け取るため
	var $todo = null;
	
	// 値をセットするため
	var $taskCount = null;
	var $visibleRows = null;
	var $tasks = null;
	var $showChangeSequence = null;

	var $block_num = null;
	
	/**
	 * Todoメイン画面表示アクション
	 *
	 * @access  public
	 */
	function execute()
	{
		if( $this->session->getParameter( "_mobile_flag" ) == true ) {
			$this->block_num = $this->mobileView->getCountForBlockInPageWithBlock( $this->block_id );
		}

		$this->taskCount = $this->todoView->getTaskCount();
		if ($this->taskCount === false) {
			return "error";
		}
			
		
		$this->tasks = $this->todoView->getTasks();
		if ($this->tasks === false) {
			return "error";
		}

		if (!empty($this->tasks)
				&& $this->todo["task_authority"]
				&& $this->todo["default_sort"] == TODO_NONE) {
			$this->showChangeSequence = true;
		}

		$_id = $this->session->getParameter("_id");
	 	$this->session->setParameter(array("todo", "_id", $this->block_id), $_id);
		return "screen";
	}
}
?>