<?php
// $Id: whatsnew_show_block.php,v 1.12 2007/08/09 04:19:34 ohwada Exp $

// 2007-08-01 K.OHWADA
// BUG: cannot show HTML entity like &auml; &copy;

// 2007-05-12 K.OHWADA
// module dupulication
// XC 2.1 system comment
// divid to whatsnew_config_basic_handler whatsnew_module_basic_handler
// WHATSNEW_FIELD_PLUGIN -> 'plugin'

// 2006-07-17 K.OHWADA
// BUG 3142: include plugin more than one time

// 2006-06-25 K.OHWADA
// add get_plugins()

// 2006-06-20 K.OHWADA
// assign variable into template: date_m, date_l
// add _get_config()

// 2006-01-27 K.OHWADA
// BUG 3508: Undefined index: description
// REQ 3509: put into spacing in a summary 
//   add fucntion _add_space()

// 2006-01-10 K.OHWADA
// BUG: Undefined offset

// 2005-11-16 K.OHWADA
// REQ 3194: output real user name

// 2005-11-06 K.OHWADA
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
// add _html_special_chars_url(), _conv_js()

// 2005-09-28 K.OHWADA
// change block.new.php & func.whatsnew.php to class

//=========================================================
// What's New Module
// class show block
// 2004/08/20 K.OHWADA
//=========================================================
// Hacked by hodaka <hodaka@kuri3.net>
// sort by date, group by module
// 2005/03/11
//=========================================================

// === class begin ===
if( !class_exists('whatsnew_show_block') ) 
{

//=========================================================
// class whatsnew_show_block
//=========================================================
class whatsnew_show_block
{
// constatant
	var $FLAG_STRIP_CONTROL = 1;
	var $FLAG_STRIP_CRLF    = 1;
	var $FLAG_STRIP_STYLE   = 1;
	var $FLAG_STRIP_SPACE   = 1;
	var $FLAG_ADD_SPACE     = 1;
	var $FLAG_IMAGE_FORCE   = 1;

	var $_DIR_ICON_REL = 'images/icons';
	var $DEFAULT_NULL  = '-';	// user, hits, replies
	var $TIME_PROHIBIT = 180;	// 180 sec

// class
	var $_config_handler;
	var $_module_handler;
	var $_system;
	var $_strings;
	var $_image_size;

// local variable
	var $_module_data;
	var $_config_data;

	var $_system_module_array;
	var $_system_weight_array;

	var $_module_work_array;
	var $_module_time_array;
	var $_article_all_array;
	var $_article_time_array;
	var $_article_time_flag_array;
	var $_time_latest;
	var $_icon_default;
	var $_is_japanese;

	var $_DIRNAME;
	var $_DIR_PLUGIN_REL;
	var $_URL_ICON; 

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_show_block()
{
	$this->_config_handler =& whatsnew_config_basic_handler::getInstance();
	$this->_module_handler =& whatsnew_module_basic_handler::getInstance();
	$this->_strings        =& happy_linux_strings::getInstance();
	$this->_system         =& happy_linux_system::getInstance();
	$this->_image_size     =& happy_linux_image_size::getInstance();

	$this->_is_japanese = $this->_system->is_japanese();
	$this->_strings->set_is_japanese( $this->_is_japanese );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_show_block();
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init( $dirname )
{
	$this->_DIRNAME = $dirname;

	$this->_config_data =& $this->_config_handler->load( $dirname );
	$this->_module_data =& $this->_module_handler->load( $dirname );

	$this->_DIR_PLUGIN_REL = 'modules/'.$dirname.'/plugins';
	$this->_URL_ICON       = XOOPS_URL.'/modules/'.$dirname.'/'.$this->_DIR_ICON_REL;
	$this->_icon_default   = $this->_URL_ICON.'/'.$this->_get_config('block_icon_default');

}

//=========================================================
// main function for block
//=========================================================
//---------------------------------------------------------
// sort by date
//---------------------------------------------------------
function &show_block_date()
{
	$article_arr =& $this->collect_block_date('block');

	$block =& $this->make_block_lang();

	$i = 0;
	foreach ($article_arr as $article)
	{
		$block['lines'][$i] = $this->make_block_line($i, $article);
		$i ++;
	}

// icon list
	$block['icon_list'] = $this->make_block_icon_list();

// send ping
	$this->send_ping();

	return $block;
}


//---------------------------------------------------------
// sort by date, group by module
//---------------------------------------------------------
function &show_block_module()
{
	$module_arr =& $this->collect_block_module('block');

	$block =& $this->make_block_lang();

	$i = 0;
	foreach ($module_arr as $module)
	{
		$block['modules'][$i++] = $this->make_block_module( $module );
	}

// icon list
	$block['icon_list'] = $this->make_block_icon_list();

// send ping
	$this->send_ping();

	return $block;
}

// --------------------------------------------------------
// caller bin/update_ping.php
// --------------------------------------------------------
function get_time_latest_after_collect()
{
	$this->collect_block_date('rss');
	return $this->_time_latest;
}

//=========================================================
// function for show_block_date
//=========================================================
// --------------------------------------------------------
// collect aritciles sortby time
// --------------------------------------------------------
function &collect_block_date( $flag_kind='block' )
{
	if ( $flag_kind == 'block' )
	{
		$max_show     = $this->_get_config('block_max_show');
		$min_show     = $this->_get_config('block_min_show');
	}
	elseif ( $flag_kind == 'rss' )	
	{
		$max_show     = $this->_get_config('rss_max_show');
		$min_show     = $this->_get_config('rss_min_show');
	}
	else
	{
		$false = false;
		return $false;
	}

// collect from all module
	$module_work_array =& $this->collect_all_modules( $flag_kind );

// mark time flag
	$i = 0;
	foreach ($this->_article_time_array as $num => $time)
	{
		$this->_article_time_flag_array[$num] = 1;
		$time_older = $time;

		$i ++;
		if ($i >= $max_show) break;
	}

	$icon_list = array();

// walk through in module array
	if ($min_show > 0)
	{
		foreach ($module_work_array as $mid => $module)
		{
// mark time flag, if less than min show
			$j = 0;
			foreach ($module['article_arr'] as $article) 
			{
				$num = $article['serial_num'];
				$this->_article_time_flag_array[$num] = 1;
				$j ++;

				if ($j >= $min_show)  break;
			}
		}
	}

	$i = 0;
	$article_array = array();

// sort by time
	foreach ($this->_article_time_array as $num => $time)
	{
		if ( $this->_article_time_flag_array[$num] )
		{
			$article_array[$i++] = $this->_article_all_array[$num];
		}
	}

	if ( isset($article_array[0]['time']) )
	{
		$this->_time_latest = $article_array[0]['time'];
	}
// no article
	else
	{
		$this->_time_latest = 0;
	}

	return $article_array;
}

// --------------------------------------------------------
// collect from all modules
// caller show main class
// --------------------------------------------------------
function &collect_all_modules( $flag_kind )
{
	if ( $flag_kind == 'block' )
	{
		$module_show  = 'block_show';
		$module_limit = 'block_limit';
	}
	elseif ( $flag_kind == 'rss' )
	{
		$module_show  = 'rss_show';
		$module_limit = 'rss_limit';
	}
	else
	{
		$false = false;
		return $false;
	}

// system module config
	$this->load_system_module();

	$mod_work_arr = array();
	$mod_time_arr = array();

	$serial = 0;	// all article
	$art_all_arr  = array();
	$art_time_arr = array();
	$art_time_flag_arr = array();

	foreach ( $this->_module_data as $mid => $module) 
	{

// BUG: Undefined offset
		if ( !isset($this->_system_module_array[$mid]) )
		{	continue;	} 

		$system = $this->_system_module_array[$mid];

		$mid     = $module['mid'];
		$dirname = $module['dirname'];
		$show    = $module[ $module_show ];
		$limit   = $module[ $module_limit ];
		$icon    = $module['block_icon'];
		$plugin  = $module['plugin'];

		$sys_dirname  = $system['dirname'];
		$sys_name     = $system['name'];
		$sys_perm     = $system['perm'];

// if not show or unlimited
		if ($show  != 1)  continue;
		if ($limit == 0)  continue;
		if (!$sys_perm)   continue;

// article array from one module
		$art_arr = $this->_collect_one_module($dirname, $plugin, $limit);

		if ( !is_array($art_arr) || (count($art_arr) == 0))
		{	continue;	} 

		$time = $art_arr[0]['time'];

		$mod_arr = array();
		$mod_arr['mod']['mid']      = $mid;
		$mod_arr['mod']['dirname']  = $sys_dirname;
		$mod_arr['mod']['mod_name'] = $sys_name;
		$mod_arr['mod']['mod_icon'] = $icon;
		$mod_arr['mod']['time']     = $time;

		$j = 0;	// article
		foreach ($art_arr as $article) 
		{
			$art_temp               = $article;
			$art_temp['mod_id']     = $mid;
			$art_temp['mod_name']   = $sys_name;
			$art_temp['mod_icon']   = $icon;
			$art_temp['dirname']    = $sys_dirname;
			$art_temp['serial_num'] = $serial;

			$mod_arr['article_arr'][$j] = $art_temp;

			$art_all_arr[$serial]  = $art_temp;
			$art_time_arr[$serial] = $art_temp['time'];
			$art_time_flag_arr[$serial] = 0;

			$j ++;
			$serial ++;
		}

		$mod_work_arr[$mid] = $mod_arr;
		$mod_time_arr[$mid] = $time;
	}

// sort by time
	arsort($art_time_arr, SORT_NUMERIC);

	$this->_module_work_array       = $mod_work_arr;
	$this->_module_time_array       = $mod_time_arr;
	$this->_article_all_array       = $art_all_arr;
	$this->_article_time_array      = $art_time_arr;
	$this->_article_time_flag_array = $art_time_flag_arr;

	return $mod_work_arr;
}

// --------------------------------------------------------
// collect from one modules
// --------------------------------------------------------
function &_collect_one_module($dirname, $plugin, $limit=0, $offset=0)
{
	$false = false;

// if unlimited
	if ($limit == 0)
	{	return $false;	}

// get plugin file
	$file = '';
	$func = $dirname."_new";

	if ($plugin)
	{
		$file = $plugin;
	}
	else
	{
		$plugins =& $this->get_plugins($dirname);

		if ( isset($plugins[0]['file']) )
		{
			$file = $plugins[0]['file'];
		}
	}

// if not exist plugin file
	if (!$file)
	{	return $false;	}

	if ( file_exists( XOOPS_ROOT_PATH.'/'.$file ) )
	{
// BUG: include plugin more than one time
		if ( !function_exists($func) )
		{
			include_once XOOPS_ROOT_PATH.'/'.$file;
		}
	}
	else
	{
		return $false;
	}

	if ( function_exists($func) )
	{
		$ret = $func($limit, $offset);
		return $ret;
	}

	return $false;
}

function &get_plugins( $mod_dirname )
{
	$file_module   = 'modules/'.$mod_dirname.'/include/data.inc.php';
	$file_whatsnew = $this->_DIR_PLUGIN_REL.'/'.$mod_dirname.'/data.inc.php';
	$file_version  = $this->_DIR_PLUGIN_REL.'/'.$mod_dirname.'/version.php';

	$file_full_module   = XOOPS_ROOT_PATH.'/'.$file_module;
	$file_full_whatsnew = XOOPS_ROOT_PATH.'/'.$file_whatsnew;
	$file_full_version  = XOOPS_ROOT_PATH.'/'.$file_version;

	$func = $mod_dirname.'_new_version';

	$num = 0;
	$plugins = array();

	if ( file_exists($file_full_module) )
	{
		$plugins[$num] = array(
			'num'   => $num, 
			'file'  => $file_module,
			'title' => 'in '.$mod_dirname,
		);
		$num ++;
	}

	if ( file_exists($file_full_version) )
	{
		include_once $file_full_version;

		if ( function_exists($func) )
		{
			$ver_list = $func();

			foreach ($ver_list as $ver)
			{
				$ver_version     = $ver['version'];
				$ver_file        = $ver['file'];
				$ver_description = $ver['description'];

				$file_ver      = $this->_DIR_PLUGIN_REL.'/'.$mod_dirname.'/'.$ver_file;
				$file_full_ver = XOOPS_ROOT_PATH.'/'.$file_ver;

				if ( file_exists($file_full_ver) )
				{
					if ($ver_description)
					{
						$title = $ver_description;
					}
					else
					{
						$title = $ver_version;
					}

					$plugins[$num] = array(
						'num'   => $num, 
						'file'  => $file_ver,
						'title' => $title,
					);
					$num ++;
				}
			}
		}
	}
	elseif ( file_exists($file_full_whatsnew) )
	{
		$plugins[$num] = array(
			'num'   => $num, 
			'file'  => $file_whatsnew,
			'title' => 'in whatsnew',
		);
		$num ++;
	}

	return $plugins;
}

//=========================================================
// function for show_block_module
//=========================================================
// --------------------------------------------------------
// collect aritciles sortby time, group by module
// --------------------------------------------------------
function &collect_block_module( $flag_kind='block' )
{
	$article_time_array =& $this->collect_block_date( $flag_kind );

	if ( $this->_get_config('block_module') )
	{
		$ret =& $this->_sortby_module($article_time_array);
	}
	else
	{
		$ret =& $this->_sortby_module_time($article_time_array);
	}
	return $ret;
}

// --------------------------------------------------------
// sortby module
// --------------------------------------------------------
function &_sortby_module($article_time_array)
{
	$i = 0;
	$module_art_arr = array();

// walk through in module weight array
	foreach ( $this->_system_weight_array as $mid => $weight)
	{
		$temp_arr =& $this->_store_artcile_in_module($mid);

// store in array
		if ($temp_arr)
		{
			$module_art_arr[$i++] = $temp_arr;
		}
	}

	return $module_art_arr;
}

// --------------------------------------------------------
// store artcile in module
// --------------------------------------------------------
function &_store_artcile_in_module($mid)
{
	if ( !isset($this->_module_work_array[$mid]) )
	{
		$false = false;
		return $false;
	}

	$module_temp  = $this->_module_work_array[$mid];
	$module_arr   = array();
	$art_temp_arr = array();

	$j = 0;
	foreach ($module_temp['article_arr'] as $article) 
	{
// store in temp array, if time flag is ok
		$num = $article['serial_num'];
		if ( $this->_article_time_flag_array[$num] )
		{
			$art_temp_arr[$j] = $article;
			$j ++;
		}
	}

	if ( count($art_temp_arr) == 0 )  return false;

// store in array
	$module_arr['mod']         = $module_temp['mod'];
	$module_arr['article_arr'] = $art_temp_arr;

	return $module_arr;
}

// --------------------------------------------------------
// sortby time, group by module
// --------------------------------------------------------
function &_sortby_module_time($article_time_array)
{
	$time_array =& $this->_module_time_array;

// sort by time
	arsort($time_array, SORT_NUMERIC);

	$i = 0;
	$module_art_arr = array();

// walk through in module time array
	foreach ( $time_array as $mid => $time)
	{
		$temp_arr = $this->_store_artcile_in_module($mid);

// store in array
		if ($temp_arr)
		{
			$module_art_arr[$i++] = $temp_arr;
		}
	}

	return $module_art_arr;
}

//=========================================================
// function for display
//=========================================================
// --------------------------------------------------------
// make language
// --------------------------------------------------------
function &make_block_lang()
{
	$lang = array(
		'lang_mod'     => _WHATSNEW_BLOCK_MODULE,
		'lang_cat'     => _WHATSNEW_BLOCK_CATEGORY,
		'lang_title'   => _WHATSNEW_BLOCK_TITLE,
		'lang_user'    => _WHATSNEW_BLOCK_USER,
		'lang_hits'    => _WHATSNEW_BLOCK_HITS,
		'lang_replies' => _WHATSNEW_BLOCK_REPLIES,
		'lang_date'    => _WHATSNEW_BLOCK_DATE,
		'lang_more'    => _WHATSNEW_BLOCK_MORE,
	);

	return $lang;
}

// --------------------------------------------------------
// make module
// --------------------------------------------------------
function &make_block_module( $module )
{

// module link
	$mod_dirname = '';
	$mod_link    = '';
	if ( isset($module['mod']['dirname']) && $module['mod']['dirname'] )
	{
		$mod_dirname  = $module['mod']['dirname'];
		$mod_link = XOOPS_URL."/modules/".$mod_dirname."/";
	}

// icon
	if ( isset($module['mod']['mod_icon']) && $module['mod']['mod_icon'] )
	{
		$mod_icon_link = $this->_URL_ICON."/".$module['mod']['mod_icon'];
	}
	else
	{
		$mod_icon_link = $this->_icon_default;
	}

	$mod_arr = array(
// sanitaize
		'mod_name'      => $this->_html_special_chars( $module['mod']['mod_name'] ),
		'mod_link'      => $this->_html_special_chars_url( $mod_link ),
		'mod_icon_link' => $this->_html_special_chars_url( $mod_icon_link ),
		'mid'           => intval( $module['mod']['mid'] ),
		'dirname'       => $mod_dirname,
	);

// lines
	$i = 0;
	foreach ( $module['article_arr'] as $article )
	{
		$mod_arr['lines'][$i] = 
			$this->make_block_line($i, $article);
		$i ++;
	}

	return $mod_arr;
}

// --------------------------------------------------------
// make line
// --------------------------------------------------------
function &make_block_line($num, $article)
{
	$time = intval( $article['time'] );

// module
	$mod_dirname  = '';
	$mod_link = '';
	if ( isset($article['dirname']) && $article['dirname'] )
	{
		$mod_dirname  = $article['dirname'];
		$mod_link = XOOPS_URL."/modules/".$article['dirname']."/";
	}

// category
	$cat_name = '';
	if ( isset($article['cat_name']) && $article['cat_name'] )
	{
		$cat_name = $article['cat_name'];
	}

	$cat_link = '';
	if ( isset($article['cat_link']) && $article['cat_link'] )
	{
		$cat_link = $article['cat_link'];
	}

// uid
	list($uid, $uname, $rname) = $this->_get_user_name( $article );

// make image width & height
	list($image, $width, $height) = $this->_make_block_image($article);

// icon
	if ( isset($article['mod_icon']) && $article['mod_icon'] )
	{
		$mod_icon_link = $this->_URL_ICON."/".$article['mod_icon'];
	}
	else
	{
		$mod_icon_link = $this->_icon_default;
	}

// hit count
	$hits    = $this->_make_block_int($article, 'hits');
	$replies = $this->_make_block_int($article, 'replies');

// BUG 3508: Undefined index: description
// description
	if ( isset($article['description']) && $article['description'] )
	{
		$desc = $article['description'];
	}
	else
	{
		$desc = '';
	}

	$line = array(

// sanitaize
		'title'     => $this->_make_html_title( $article ),
		'desc'      => $this->_make_html_summary( $num, $article ),
		'mod_name'  => $this->_html_special_chars( $article['mod_name'] ),
		'dirname'   => $this->_html_special_chars( $mod_dirname ),
		'cat_name'  => $this->_html_special_chars( $cat_name ),

// REQ 3194: output real user name
		'user'      => $this->_html_special_chars( $uname ),
		'user_name' => $this->_html_special_chars( $uname ),
		'real_name' => $this->_html_special_chars( $rname ),

		'link'      => $this->_html_special_chars_url( $article['link'] ),
		'mod_link'  => $this->_html_special_chars_url( $mod_link ),
		'cat_link'  => $this->_html_special_chars_url( $cat_link ),
		'image'     => $this->_html_special_chars_url( $image ),
		'mod_icon_link' => $this->_html_special_chars_url( $mod_icon_link ),

// int
		'uid'      => $uid,
		'width'    => $width,
		'height'   => $height,
		'hits'     => $hits,
		'replies'  => $replies,

// time stamp
		'time'       => $time,
		'date_s'     => formatTimestamp( $time, 's' ),
		'date_m'     => formatTimestamp( $time, 'm' ),
		'date_l'     => formatTimestamp( $time, 'l' ),
		'date_mysql' => formatTimestamp( $time, 'mysql'),

// raw data
		'content'  => $desc,
	);

	return $line;
}

// --------------------------------------------------------
// make icon list
// --------------------------------------------------------
function &make_block_icon_list()
{
	$icon_list = array();
	$i = 0;

	foreach ($this->_module_work_array as $mid => $module)
	{
		if ( $module['mod']['mod_icon'] )
		{
			$mod_link = '';
			if ( $module['mod']['dirname'] )
			{
				$mod_link = XOOPS_URL."/modules/".$module['mod']['dirname']."/";
			}

			$icon_list[$i]['mod_link']  = $mod_link;
			$icon_list[$i]['icon_link'] = $this->_URL_ICON."/".$module['mod']['mod_icon'];
			$icon_list[$i]['mod_name']  = $this->_html_special_chars( $module['mod']['mod_name'] );

			$i ++;
		}
	}

	$icon_list[$i]['mod_name']  = $this->_html_special_chars( _WHATSNEW_BLOCK_ETC );
	$icon_list[$i]['icon_link'] = $this->_icon_default;

	return $icon_list;
}

// --------------------------------------------------------
// meke html title
// --------------------------------------------------------
function _make_html_title( $article )
{
	if ( !isset($article['title']) )  return '';

 	$title = $article['title'];
	$title = strip_tags($title);
	$title = $this->_strings->shorten_text($title, $this->_get_config('block_max_title') );

// sanitize
	$title = $this->_html_special_chars( $title );

	return $title;
}

// --------------------------------------------------------
// make html summary
// --------------------------------------------------------
function _make_html_summary( $num, $article )
{
	if ( !isset($article['description']) )  return '';
	if ( empty($article['description'] ) )  return '';
	if ( $num >= $this->_get_config('block_limit_summary') )  return '';

	$max = $this->_get_config('block_max_summary');

	$sum = $article['description'];

	if ($this->FLAG_STRIP_CONTROL)
	{
		$sum = $this->_strings->strip_control($sum);
	}

	if ( $this->_get_config('block_summary_html') && (strlen($sum) < $max) )
	{
		return $sum;
	}

	if ($this->FLAG_STRIP_CRLF)
	{
		$sum = $this->_strings->replace_return_to_space($sum);
	}

	if ($this->FLAG_STRIP_STYLE)
	{
		$sum = $this->_strings->strip_style_tag($sum);
	}

// REQ 3509: put into spacing in a summary
	if ($this->FLAG_ADD_SPACE)
	{
		$sum = happy_linux_str_add_space_after_tag($sum);
	}

	$sum = strip_tags($sum);

	if ($this->FLAG_STRIP_SPACE)
	{
		$sum = $this->_strings->strip_space($sum);
	}

	$sum = $this->_strings->shorten_text($sum, $max);

// sanitaize
	$sum = $this->_html_special_chars($sum);

	return $sum;
}

// --------------------------------------------------------
// make block int
// --------------------------------------------------------
function _make_block_int($article, $key)
{
	if ( isset($article[$key]) )
	{
		return intval( $article[$key] );
	}
	return $this->DEFAULT_NULL;
}

// --------------------------------------------------------
// convert html_special_chars
// ex ) &auml; => &amp;auml; => &auml;
// --------------------------------------------------------
// BUG: cannot show HTML entity like &auml; &copy;
function _html_special_chars($str, $flag_amp=false)
{
	$str = $this->_strings->strip_control($str);
	$str = $this->_strings->strip_tab($str);
	$str = $this->_strings->replace_javascript($str);
	$str = htmlspecialchars($str, ENT_QUOTES);
	$str = happy_linux_undo_html_entity_name( $str );
	$str = happy_linux_undo_html_entity_numeric( $str );
	return $str;
}

//---------------------------------------------------------
// convert html_special_chars for url
// ex ) &amp; => & => &amp;
//---------------------------------------------------------
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
function _html_special_chars_url($str, $flag_amp=true)
{
	$str = $this->_strings->strip_control($str);
	$str = $this->_strings->strip_tab($str);
	$str = $this->_strings->replace_return_to_space($str);
	$str = $this->_strings->replace_javascript($str);
	$str = happy_linux_undo_htmlspecialchars( $str );
	$str = htmlspecialchars($str, ENT_QUOTES);
	return $str;
}

// --------------------------------------------------------
// make image
// --------------------------------------------------------
function _make_block_image($article)
{
	if ( !$this->_get_config('block_image_flag') ) return array('', '', '');
	if ( !isset($article['image']) ) return array('', '', '');

	$image  = $article['image'];	
	$width  = '';
	$height = '';

	if ( isset($article['width']) && isset($article['height']) )
	{
		list($width, $height) = 
			$this->_image_size->adjust_size($article['width'], $article['height'], $this->_get_config('block_image_width'), $this->_get_config('block_image_height') );
	}
	elseif ($this->FLAG_IMAGE_FORCE)
	{
		$width  = $this->_get_config('block_image_width');
		$height = $this->_get_config('block_image_height');
	}

	return array($image, intval($width), intval($height) );
}

//---------------------------------------------------------
// user name
// REQ 3194: output real user name
//---------------------------------------------------------
function _get_user_name( $article )
{
	$uid   = '';
	$uname = $this->DEFAULT_NULL;
	$rname = $this->DEFAULT_NULL;

	if ( !isset($article['uid']) )
	{
		return array($uid, $uname, $rname);
	}

	if ( $article['uid'] )
	{
		$user =& $this->_system->get_user_by_uid( $article['uid'] );

		if ( $user['isactive'] )
		{
			$uname = $user['uname'];
			$name  = $user['name'];

			if ($name)
			{
				$rname = $name;
			}
			else
			{
				$rname = $uname;
			}

		}
		else
		{
			$uid   = 0;
			$uname = $this->_system->get_anonymous();
			$rname = $uname;
		}
	}
	elseif ( $article['uid'] == 0 )
	{
		$uid   = 0;
		$uname = $this->_system->get_anonymous();
		$rname = $uname;
	}

	return array($uid, $uname, $rname);
}

//=========================================================
// function for system config
//=========================================================
//---------------------------------------------------------
// get system config
// caller show main class
//---------------------------------------------------------
// module & weight key as mid
function load_system_module()
{
// get user permission
	$groups =& $this->_system->get_user_groups();

	$module_objs =& $this->_system->get_module_objects();
	$is_active_legacy_module = $this->_system->is_active_legacy_module();

	$system_arr = array();
	$weight_arr = array();

	foreach ( $module_objs as $module_obj ) 
	{
		$mid      = $module_obj->getVar('mid');
		$dirname  = $module_obj->getVar('dirname');
		$name     = $module_obj->getVar('name');
		$weight   = $module_obj->getVar('weight');
		$isactive = $module_obj->getVar('isactive');

		$flag_comment = false;

// not active
		if ( !$isactive ) continue;

// check user permission
		$perm = $this->_system->check_groupperm_right( 'module_read', $mid,  $groups );

// XC2.1 legacy module exist
		if ( $is_active_legacy_module )
		{
			if ($dirname == 'legacy')
			{
				$flag_comment = true;
			}
		}
// xoops 2.0 system module exist
		else
		{
			if ($dirname == 'system')
			{
				$flag_comment = true;
			}
		}

// system comment
		if ($flag_comment)
		{
			$name    = $this->_get_config('comment_name');
			$weight  = $this->_get_config('comment_weight');
			$dirname = '';
		}

		$system_arr[$mid]['dirname'] = $dirname;
		$system_arr[$mid]['name']    = $name;
		$system_arr[$mid]['weight'] =  $weight;
		$system_arr[$mid]['perm']    = $perm;

		$weight_arr[$mid] = $weight;
	}

//sort by weight
	asort($weight_arr, SORT_NUMERIC);

	$this->_system_module_array = $system_arr;
	$this->_system_weight_array = $weight_arr;

	return $system_arr;
}

// --------------------------------------------------------
// caller builder base class
// --------------------------------------------------------
function &get_config_data()
{
	return $this->_config_data;
}

function _get_config($key)
{
	if( isset($this->_config_data[$key]) )
	{
		return $this->_config_data[$key];
	}
	return false;
}

//=========================================================
// function for ping
//=========================================================
// --------------------------------------------------------
// send ping
// --------------------------------------------------------
function send_ping($time='')
{
	if ($time == '')
	{
		$time = $this->_time_latest;
	}

	$ping_flag = $this->_get_config('block_ping');
	$ping_time = $this->_get_config('ping_time');

	if ( !$ping_flag ) return;

	if ( ($time - $this->TIME_PROHIBIT) > $ping_time )
	{	return;	}

	include_once XOOPS_ROOT_PATH.'/modules/'.$this->_DIRNAME.'/api/api_ping.php';

	$class_ping =& whatsnew_ping::getInstance( $this->_DIRNAME );
	$class_ping->send_ping_cache();

}

// --- class end ---
}

// === class end ===
}

?>