<?php
// $Id: admin_function.php,v 1.4 2006/06/26 17:45:33 ohwada Exp $

// 2006-06-25 K.OHWADA
// add get_get()

//=========================================================
// What's New Module
// admin fucntion
// 2005-10-01 K.OHWADA
//=========================================================

function print_header()
{
	global $xoopsModule;

	echo "<h3>". $xoopsModule->getVar('name') ."</h3>\n";
	echo _MI_WHATSNEW_DESC."<br /><br />\n";
}

function print_menu()
{
	global $xoopsConfig;

	$MAX_COL = 4;

	$url_groups = XOOPS_URL."/modules/system/admin.php?fct=groups&op=modify&g_id=3";
	$url_blocks = XOOPS_URL."/modules/system/admin.php?fct=blocksadmin";

	$file_docs = "/modules/whatsnew/docs/".$xoopsConfig['language']."/index.html";
	if ( file_exists( XOOPS_ROOT_PATH.$file_docs ) ) 
	{
		$url_docs = XOOPS_URL.$file_docs;
	}
	else
	{
		$url_docs = XOOPS_URL."/modules/whatsnew/docs/english/index.html";
	}

	$menu_arr = array(
		_MI_WHATSNEW_ADMENU1        => 'index.php',
		_MI_WHATSNEW_ADMENU_CONFIG2 => 'config_2.php',
		_MI_WHATSNEW_ADMENU_RSS     => 'manage_rss.php',
		_MI_WHATSNEW_ADMENU_PING    => 'send_ping.php',

		_WHATSNEW_SYSTEM_GROUPS => $url_groups,
		_WHATSNEW_SYSTEM_BLOCKS => $url_blocks,
		_WHATSNEW_VIEW_DOCS     => $url_docs,
		_WHATSNEW_GOTO_WHATNEW  => '../index.php',
	);

	print_menu_table($menu_arr, $MAX_COL);
}

function print_footer()
{
	$class_lang =& Whatsnew_Lang_Conv::getInstance();
	$happy_linux_url = $class_lang->get_happy_linux_url();

?>
<hr>
<div align='right'><a href='<?php echo $happy_linux_url; ?>' target='_blank'><font size='-1'>Powered by Happy Linux</font></a></div>
<div align='right'><font size='-1'>&copy; 2004-2005, Kenichi OHWADA</font></div>
<?php

}

function print_menu_table($menu_arr, $MAX_COL=5)
{
	echo "<table class='outer' cellpadding='4' cellspacing='1'> \n";
	echo "<tr>";

	$col_count  = 0;
	$line_count = 1;
	$menu_count = count($menu_arr);
	$class = 'odd';

	foreach ($menu_arr as $name => $url) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo "<td class='$class' align='center' valign='bottom' width='19%'>";

		if ($name && $url)
		{
			echo "<a href='".$url."'><b>" .$name."</b></a>";
		}

		echo "</td>\n";

		$col_count ++;

		if ( $col_count >= $MAX_COL ) 
		{
			echo "</tr>\n";

			if ( $MAX_COL*$line_count < $menu_count ) 
			{
				$col_count = 0;
				$line_count ++;
				echo "<tr>";

				if ($line_count % 2 == 0) 
				{
					$class = 'even';
				}
				else 
				{
					$class = 'odd';
				}
			}
		}
	}

	while ($col_count < $MAX_COL) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo '<td class="'.$class.'">&nbsp;</td>';

		$col_count ++;
	}

	echo "</tr></table>\n";
}


//---------------------------------------------------------
// get POST variable
//---------------------------------------------------------
function get_get($key, $default='')
{
	if ( isset($_GET[$key]) )
	{
		return $_GET[$key];
	}
	else

	return $default;
}

function get_get_int($key, $default=0)
{
	if ( isset($_GET[$key]) )
	{
		return intval( $_GET[$key] );
	}

	return intval($default);
}

function get_post($key, $default='')
{
	if ( isset($_POST[$key]) )
	{
		return $_POST[$key];
	}
	else

	return $default;
}

function get_post_int($key, $default=0)
{
	if ( isset($_POST[$key]) )
	{
		return intval( $_POST[$key] );
	}

	return intval($default);
}

function get_post_get($key, $default='')
{
	if (isset($_POST[$key])) 
	{
		return $_POST[$key];
	}
	elseif (isset($_GET[$key])) 
	{
		return trim($_GET[$key]);
	}

	return $default;
}

function get_post_get_int($key, $default=0)
{
	if (isset($_POST[$key])) 
	{
		return intval( $_POST[$key] );
	}
	elseif (isset($_GET[$key])) 
	{
		return intval( trim($_GET[$key]) );
	}

	return intval($default);
}

function check_token($name='whatsnew')
{
	if ( !class_exists('XoopsMultiTokenHandler') )  return true;
	if( XoopsMultiTokenHandler::quickValidate($name) ) return true;
	return false;
}

?>