<?php
// $Id: admin_config_class.php,v 1.6 2006/06/26 17:45:33 ohwada Exp $

// 2006-06-25 K.OHWADA
// add show_form_plugins() print_form_plugin() more
// change name flag_both to flag_plural_plugins

// 2006-06-20 K.OHWADA
// REQ 3873: login user can read RSS.
// add check_version()

// 2005-11-06 K.OHWADA
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']

// 2005-10-01 K.OHWADA
// change index.php to class

//=========================================================
// What's New Module
// class admin config
// 2004/08/20 K.OHWADA
//=========================================================

class admin_config extends Whatsnew_Config_Form
{
// constant
	var $LIMIT_MODULE_DEFAULT = 5;
	var $MAX_ICON_COL         = 5;

// icon
	var $PATH_ICON = "/modules/whatsnew/images/icons";
	var $DIR_ICON;
	var $URL_ICON;

// class
	var $_module_handler;
	var $_config_handler;
	var $_module_save;
	var $_show_block;

	var $icon_array;

// variable
	var $_system_module_array;
	var $_line_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config()
{
	Whatsnew_Config_Form::Whatsnew_Config_Form();

// icon
	$this->DIR_ICON = XOOPS_ROOT_PATH . $this->PATH_ICON;
	$this->URL_ICON = XOOPS_URL . $this->PATH_ICON;

// class
	$this->_module_handler =& Whatsnew_Module_Handler::getInstance();
	$this->_config_handler =& Whatsnew_Config_Handler::getInstance();
	$this->_module_save    =& Whatsnew_Module_Save::getInstance();
	$this->_show_block     =& Whatsnew_Show_Block::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config();
	}

	return $instance;
}

//=========================================================
// main function
//=========================================================
function show_form()
{
// system module config
	$this->_module_save->load_system_module();
	$system_arr  = $this->_module_save->get_system_module();
	$weight_arr  = $this->_module_save->get_system_module_weight();
	$flag_plural = $this->_module_save->get_flag_plural_plugins();

// this modulue'e guest permission
	global $xoopsModule;
	$mid  = $xoopsModule->getVar('mid');
	$perm = $system_arr[$mid]['perm'];

	$this->init_form();

	if (!$perm)
	{
		echo "<h4><font color='red'>"._WHATSNEW_NOTICE."</font></h4>\n";
		echo _WHATSNEW_NOTICE_PERM."\n";
	}

	if ( $flag_plural )
	{
		echo "<h4><font color='red'>"._WHATSNEW_NOTICE."</font></h4>\n";
		echo _WHATSNEW_NOTICE_PLURAL."\n";
		echo "<br />\n";
		$this->show_form_plugins($system_arr, $weight_arr);
	}

	$this->get_icon_array();
	$this->show_form_modules($system_arr, $weight_arr);
}

function show_form_plugins($system_arr, $weight_arr)
{
	echo $this->make_form_start('whatsnew_plugin');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',   'save');
	echo $this->make_form_hidden('mode', 'plugin');

	echo '<table class="outer" width="100%">'."\n";
	echo '<tr>';
	echo '<th align="center">'._WHATSNEW_MID.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MNAME.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MDIR.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MOD_VERSION.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_PLUGIN.'</th>'."\n";
	echo '</tr>'."\n";

// list from system module
	foreach ( $weight_arr as $mid => $weight ) 
	{
		if ($mid != 1)
		{
			$system = $system_arr[$mid];

			if (($system['in_module'] && $system['in_whatsnew']) || $system['in_version'])
			{
				$this->print_form_plugin($mid, $system);
			}
		}
	}

	echo '<tr class="foot"><td></td><td></td><td colspan="3">';
	echo $this->make_form_submit( 'submit', _WHATSNEW_SAVE );
	echo '</tr>'."\n";
	echo '</table>'."\n";
	echo $this->make_form_end();
	echo '<br />'."\n";
}

function show_form_modules($system_arr, $weight_arr)
{
	$this->print_form_top();

// list from system module
	foreach ( $weight_arr as $mid => $weight ) 
	{
		$system = $system_arr[$mid];
		$this->print_form_mod($mid, $system, $weight);
	}

	$this->print_form_middle();

	$this->print_form_conf_two('block_max_show', 'rss_max_show');
	$this->print_form_conf_two('block_min_show', 'rss_min_show');
	$this->print_form_conf_one('block_limit_summary');
	$this->print_form_conf_two('block_max_summary', 'rss_max_summary');
	$this->print_form_conf_one('block_max_title');
	$this->print_form_conf_checkbox('block_summary_html');
	$this->print_form_conf_checkbox('block_image_flag');
	$this->print_form_conf_one('block_image_width');
	$this->print_form_conf_one('block_image_height');
	$this->print_form_conf_checkbox('block_ping');
	$this->print_form_conf_icon('block_icon_default');
	$this->print_form_conf_radio('block_module');

	$this->print_form_bottom();
}

function show_icon_list()
{
	$icon_arr = $this->icon_array;

	$count   = count($icon_arr) ;
	$max_col = $count / $this->MAX_ICON_COL;

	echo "<table>\n";

	for ($i=0; $i<$max_col; $i++)
	{
		echo "<tr>";

		for ($j=0; $j<$this->MAX_ICON_COL; $j++)
		{
			$ii   = $this->MAX_ICON_COL * $i + $j;
			$icon = array_shift( $icon_arr );

			if ($icon)
			{
				$url_icon  = $this->URL_ICON."/".$icon;
				echo "<td> ";
				echo $this->make_html_img($url_icon, 0, 0, 0, $icon);
				echo " $icon </td>";
			}
			else
			{
				echo "<td></td>";
			}
		}

		echo "</tr>\n";

		if ($ii > $count)  break;
	}

	echo "</table>\n";

}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$this->_module_save->save();

	$config_save =& Whatsnew_Config_Save::getInstance();
	$config_save->save();
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function is_exist()
{
	$mod_num  = $this->_module_handler->get_num();
	if ( $mod_num == 0 )  return false;

	$conf_num = $this->_config_handler->get_num();
	if ( $conf_num == 0 )  return false;

	return true;
}

function init()
{
	$mod_num  = $this->_module_handler->get_num();
	if ( $mod_num == 0 )
	{
		$this->_module_save->init();
	}

	$conf_num = $this->_config_handler->get_num();
	if ( $conf_num == 0 )
	{
		$config_save =& Whatsnew_Config_Save::getInstance();
		$config_save->init();
	}
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if( !$this->_check_config( 'block_summary_html' ) )
	{
		return false;
	}

// REQ 3873: login user can read RSS.
	if( !$this->_check_config( 'rss_permit_user' ) )
	{
		return false;
	}

	return true;
}

function _check_config( $name )
{
	return $this->_config_handler->is_exist_by_name( $name );
}

function is_version($ver)
{
	switch ($ver)
	{
		case '2.01':
		default:
			$name = 'block_summary_html';
			break;

	}

	return $this->_config_handler->is_exist_by_name( $name );
}

function upgrade()
{
	$config_save =& Whatsnew_Config_Save::getInstance();
	$config_save->upgrade();
}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_form_top()
{
	echo $this->make_form_start('whatsnew_module');
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',   'save');
	echo $this->make_form_hidden('mode', 'module');

	echo '<table class="outer" width="100%">'."\n";
	echo '</tr>'."\n";
	echo '<th align="center">'._WHATSNEW_MID.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MNAME.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MDIR.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_WEIGHT.'</th>'."\n";
	echo '<th align="center" colspan="2">'._WHATSNEW_NEW.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_RSS.'</th>'."\n";
	echo '</tr>'."\n";
}

function print_form_mod($mid, $system, $weight)
{
	$this->print_form_even_odd();
	$this->print_form_mod_left($mid, $system, $weight);

	if ($system['in_module'] || $system['in_whatsnew'] || $system['in_version']) 
	{
		$this->print_form_mod_block_rss($mid, $system);
	}
	else
	{
		echo "<td></td><td></td><td></td>";
	}

	echo "</tr>\n";
}

function print_form_plugin($mid, $system)
{
	$dirname     = $system['dirname'];
	$name        = $system['name'];
	$version     = $system['version'];

	$name_show    = $this->_myts->htmlSpecialChars($name);
	$dirname_show = $this->_myts->htmlSpecialChars($dirname);
	$version_show = round($version / 100, 2);
	$plugin_show  = $this->make_form_plugin_select($mid, $dirname);

	$mod_ids = $this->make_form_hidden('mod_ids[]', $mid);

	$this->print_form_even_odd();
	echo '<td>'.$mid.' '.$mod_ids.'</td>';
	echo '<td>'.$name_show.'</td>';
	echo '<td>'.$dirname_show.'</td>';
	echo '<td>'.$version_show.'</td>'."\n";
	echo '<td>'.$plugin_show.'</td>';
	echo '</tr>'."\n";
}

function make_form_plugin_select($mid, $dirname)
{
	$plugins = $this->_show_block->get_plugins($dirname);

	$text  = '';
	$value = '';

	$module =& $this->_module_handler->get($mid);
	if ( is_object($module) )
	{
		$value = $module->getVar( WHATSNEW_FIELD_PLUGIN );
	}

	foreach ($plugins as $plug)
	{
		$num   = $plug['num']; 
		$file  = $plug['file']; 
		$title = $plug['title']; 

		$checked    = $this->make_checked($value, $file);
		$file_show  = $this->_myts->htmlSpecialChars($file);
		$title_show = $this->_myts->htmlSpecialChars($title);

		$text .= '<input type="radio" name="plugins['.$mid.']" value="'.$file_show.'" '.$checked.' /> ';
		$text .= $title_show."\n";
		$text .= '<a href="view_plugin.php?dirname='.$dirname.'&amp;num='.$num.'" target="_blank">[view]</a> ';
		$text .= "<br />\n";
	}

	return $text;
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_form_mod_left($mid, $system, $weight)
{
	$dirname     = $system['dirname'];
	$name        = $system['name'];
	$in_module   = $system['in_module'];
	$in_whatsnew = $system['in_whatsnew'];

	if ($mid == 1)
	{
		$name_show   = $this->make_conf_textbox_by_name('comment_name', 20);
		$weight_show = $this->make_conf_textbox_by_name('comment_weight');
	}
	else
	{
		$name_show   = $this->_myts->htmlSpecialChars($name);
		$weight_show = $this->_myts->htmlSpecialChars($weight);
	}

	$dirname_show = $this->_myts->htmlSpecialChars($dirname);
	$mod_ids = $this->make_form_hidden('mod_ids[]', $mid);

	echo "<td>$mid $mod_ids</td>";
	echo "<td>$name_show</td>";
	echo "<td>$dirname_show</td>";
	echo "<td align='center'>$weight_show</td>";
}

function print_form_mod_block_rss($mid, $system)
{
	$perm    = $system['perm'];
	$dirname = $system['dirname'];

	$module =& $this->_module_handler->get($mid);
	if ( is_object($module) )
	{
		$block_show  = $module->getVar('block_show');
		$block_limit = $module->getVar('block_limit');
		$rss_show    = $module->getVar('rss_show');
		$rss_limit   = $module->getVar('rss_limit');
		$block_icon  = $module->getVar('block_icon');
		$plugin_file = $module->getVar( WHATSNEW_FIELD_PLUGIN );
	}
	else
	{
		$block_show  = 0;
		$rss_show    = 0;
		$block_limit = $this->LIMIT_MODULE_DEFAULT;
		$rss_limit   = $this->LIMIT_MODULE_DEFAULT;
		$block_icon  = '';
		$plugin_file = '';
	}

	$block_show_show  = $this->make_mod_checkbox($mid, 'block_shows',  $block_show);
	$block_limit_show = $this->make_mod_textbox( $mid, 'block_limits', $block_limit);
	$block_icon_show  = $this->make_mod_icon($mid, $block_icon);
	$rss_show_show    = $this->make_mod_checkbox($mid, 'rss_shows',  $rss_show);
	$rss_limit_show   = $this->make_mod_textbox( $mid, 'rss_limits', $rss_limit);
	$perm_show        = $this->make_mod_perm($perm);

// plugin
	if ($plugin_file == '')
	{
		$plugins = $this->_show_block->get_plugins($dirname);

		if ( isset($plugins[0]['file']) )
		{
			$plugin_file = $plugins[0]['file'];
		}
	}

	$plugin_name   = 'plugins['.$mid.']';
	$plugin_value  = $this->_myts->htmlSpecialChars($plugin_file);
	$plugin_hidden = $this->make_form_hidden($plugin_name, $plugin_value);

	echo '<td align="right">';
	echo $block_show_show.' '.$block_limit_show.' '.$plugin_hidden;
	echo ' </td><td align="right">';
	echo $block_icon_show;
	echo ' </td>';
	echo '<td align="right">';
	echo $perm_show.' '.$rss_show_show.' '.$rss_limit_show;
	echo ' </td>';
}

function print_form_middle()
{
	echo "<tr><th></th>";
	echo "<th align='center'>"._WHATSNEW_ITEM."</th>";
	echo "<th></th><th></th>";
	echo "<th align='center' colspan='2'>"._WHATSNEW_NEW."</th>";
	echo "<th align='center'>"._WHATSNEW_RSS."</th></tr>\n";
}

function print_form_conf_two($name1, $name2)
{
	$this->print_form_even_odd();

	$name1_show = $this->make_conf_textbox_by_name($name1);
	$name2_show = $this->make_conf_textbox_by_name($name2);
	$this->print_conf_line($name1, $name1_show, $name2_show);
}

function print_form_conf_one($name)
{
	$this->print_form_even_odd();

	$name_show = $this->make_conf_textbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->make_conf_yseno_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->make_conf_title_by_name($name);
	$name_show  = $this->make_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_form_conf_icon($name)
{
	$this->print_form_even_odd();

	$title_show = $this->make_conf_title_by_name($name);
	$name_show  = $this->make_conf_icon_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td></td><td align='right'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->make_conf_title_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td></td><td colspan='5'>";
	echo $this->make_form_submit( 'submit', _WHATSNEW_SAVE );
	echo "</tr></table>\n";
	echo $this->make_form_end();
	echo "<br />\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}

//---------------------------------------------------------
// print form init
//---------------------------------------------------------
function print_form_init()
{

	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _WHATSNEW_INIT_EXEC ."</h4>\n";

// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
	echo $this->make_form_box( '', 'init', _WHATSNEW_SAVE );

	echo "</td></tr></table>\n";
	echo "<br />\n";

}

//---------------------------------------------------------
// print form upgrade
//---------------------------------------------------------
function print_form_upgrade()
{

	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _WHATSNEW_UPGRADE_EXEC ."</h4>\n";

// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
	echo $this->make_form_box( '', 'upgrade', _WHATSNEW_SAVE );

	echo "</td></tr></table>\n";
	echo "<br />\n";

}

//---------------------------------------------------------
// make config form
//---------------------------------------------------------
function make_mod_checkbox($mid, $name, $value)
{
	$name_show = $name."[".$mid."]";
	$checked = $this->make_checked($value, 1);
	return $this->make_form_checkbox($name_show, 1, $checked);
}

function make_mod_textbox($mid, $name, $value, $size=5)
{
	$name_show = $name."[".$mid."]";
	return $this->make_form_text($name_show, $value, $size);
}

function make_mod_icon($mid, $block_icon)
{
	$text = '';

// show icon
	$text .= $this->make_mod_icon_img($block_icon)."\n";

// show icon select form
	$text .= $this->make_mod_icon_select($mid, $block_icon);

	return $text;
}

function make_mod_icon_img($icon)
{
	$file_icon = $this->DIR_ICON."/".$icon;
	$url_icon  = $this->URL_ICON."/".$icon;

	if ( empty($icon) || !file_exists($file_icon) )  return '';

	$text = $this->make_html_img($url_icon, 0, 0, 0, $icon);
	return $text;
}

function make_mod_icon_select($mid, $value)
{
	$name_show = "block_icons[".$mid."]";
	return $this->make_form_select($name_show, $value, $this->icon_array, 1);
}

function make_mod_perm($perm)
{
	if ($perm)
	{
		return "<b>#</b>";
	}
	return '';
}

//---------------------------------------------------------
// make config by name
//---------------------------------------------------------
function make_conf_title_by_name($name)
{
	$id = $this->get_id_by_name($name);
	return $this->make_conf_title($id);
}

function make_conf_textbox_by_name($name, $size=5)
{
	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_textbox($id, $size);
	$text .= $this->make_conf_hidden($id);
	return $text;
}

function make_conf_yseno_checkbox_by_name($name)
{
	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_checkbox_yesno($id);
	$text .= $this->make_conf_hidden($id);
	return $text;
}

function make_conf_radio_select_by_name($name)
{
	$id    = $this->get_id_by_name($name);
	$text  = $this->make_conf_radio_select($id);
	$text .= $this->make_conf_hidden($id);
	return $text;
}

function make_conf_icon_select_by_name($name)
{
	$id    = $this->get_id_by_name($name);
	$value = $this->get_conf_value($id);
	$text  = $this->make_mod_icon_img($value);
	$text .= $this->make_conf_select_options($id, $this->icon_array );
	$text .= $this->make_conf_hidden($id);
	return $text;
}

//---------------------------------------------------------
// icon
//---------------------------------------------------------
function get_icon_array()
{
	$this->icon_array =& XoopsLists::getImgListAsArray( $this->DIR_ICON );
}


//---------------------------------------------------------
// view_plugin
//---------------------------------------------------------
function view_plugin($dirname, $num)
{
	$plugins = $this->_show_block->get_plugins($dirname);

	if ( isset($plugins[$num]['file']) )
	{
		$file = $plugins[$num]['file'];
	}
	else
	{
		echo "no plugin file: $dirname";
		return false;
	}

	$file_plugin  = XOOPS_ROOT_PATH.'/'.$file;

	if ( file_exists($file_plugin) )
	{
		highlight_file($file_plugin);
	}
	else
	{
		echo "no plugin file: $file_plugin";
		return false;
	}

	return;
}

// --- class end ---
}

?>