<?php
// $Revision: 1.1.4.1.2.3 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2011 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
if ( ! defined( 'XOOPS_ROOT_PATH' ) ) {
  exit();
}

// title
$title = _AM_XOONIPS_POLICY_MODERATOR_TITLE;
$description = _AM_XOONIPS_POLICY_MODERATOR_DESC;

// breadcrumbs
$breadcrumbs = array(
  array(
    'type' => 'top',
    'label' => _AM_XOONIPS_TITLE,
    'url' => $xoonips_admin['admin_url'].'/',
  ),
  array(
    'type' => 'link',
    'label' => _AM_XOONIPS_POLICY_TITLE,
    'url' => $xoonips_admin['myfile_url'],
  ),
  array(
    'type' => 'label',
    'label' => $title,
    'url' => '',
  ),
);

// token ticket
require_once( '../class/base/gtickets.php' );
$ticket_area = 'xoonips_admin_policy_moderator';
$token_ticket = $xoopsGTicket->getTicketHtml( __LINE__, 1800, $ticket_area );

// get configs
$config_keys = array(
  'moderator_modify_any_items' => 's',
);
$config_values = xoonips_admin_get_configs( $config_keys, 'e' );

// >> moderator modify nay items
$moderator_modify = array();
$key = 'moderator_modify_any_items';
$mm['name'] = $key;
$mm['yes'] = _AM_XOONIPS_LABEL_YES;
$mm['no'] = _AM_XOONIPS_LABEL_NO;
$mm['checked'] = $config_values[$key];
$moderator_modify[] = $mm;

// templates
require_once( '../class/base/pattemplate.class.php' );
$tmpl = new PatTemplate();
$tmpl->setBaseDir( 'templates' );
$tmpl->readTemplatesFromFile( 'policy_moderator.tmpl.html' );

// assign template variables
$tmpl->addVar( 'header', 'TITLE', $title );
$tmpl->setAttribute( 'description', 'visibility', 'visible' );
$tmpl->addVar( 'description', 'DESCRIPTION', $description );
$tmpl->setAttribute( 'breadcrumbs', 'visibility', 'visible' );
$tmpl->addRows( 'breadcrumbs_items', $breadcrumbs );
$tmpl->addVar( 'main', 'token_ticket', $token_ticket );
$tmpl->addVar( 'main', 'submit', _AM_XOONIPS_LABEL_UPDATE );

// >> moderator modify any items
$tmpl->addVar( 'main', 'moderator_title', _AM_XOONIPS_POLICY_MODERATOR_TITLE );
$tmpl->addVar( 'main', 'moderator_modify_title', _AM_XOONIPS_POLICY_MODERATOR_MODIFY_TITLE );
$tmpl->addVar( 'main', 'moderator_modify_desc', _AM_XOONIPS_POLICY_MODERATOR_MODIFY_DESC );
$tmpl->addRows( 'moderator_modify', $moderator_modify );

// display
xoops_cp_header();
$tmpl->displayParsedTemplate( 'main' );
xoops_cp_footer();

?>
