<?php
// $Revision: 1.4.2.1.2.2 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
define( 'READFILE_FAILED', 'cannot read file' );

class XoonipsText extends XoonipsSearchTextExtractor {
  function XoonipsText() {
  }
  
  var $encode = false;

  /**
   * extract text from file
   *   @return extracted utf8 encoded string
   */
  function fetch() {
    if ( $this->handle == false ) {
      return array( false, XOONIPS_SEARCH_TEXT_FAILED );
    }
    
    if ( $this->encode != false ) {
      // already detected encoding
      $line = fgets( $this->handle );
      if ( $line == false ) {
        $this->close();
        
        return array( false, false );
      }
      if ( $this->encode == 'UTF-8' ) {
        return array( $line, false );
      } else {
        return array( mb_convert_encoding( $line, 'UTF-8', $this->encode ), false );
      }
    }
    
    // detect encoding
    $len = 0;
    $ar = array();
    while ( $len < 65536 ) {
      // todo: replaoce fgets() function for too long one-line text
      $line = fgets( $this->handle );
      if ( $line == false ) {
        if ( count( $ar ) == 0 ) {
          $this->close();
          return array( false, false );
        }
        break;
      }
      $ar[] = $line;
      $len += strlen( $line );
    }
    $text = implode( '', $ar );
    $encode = strtolower( mb_detect_encoding( $text ) );
    if ( $encode == 'ascii' ) {
      return array( $text, false );
    }
    $this->encode = $encode;
    
    return array( mb_convert_encoding( $text, 'UTF-8', $this->encode ), false );
  }
};

?>
