<?php
// $Revision: 1.1.4.1.2.6 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
if ( ! defined( 'XOOPS_ROOT_PATH' ) ) {
  exit();
}

// title
$title = _AM_XOONIPS_MAINTENANCE_FILESEARCH_TITLE;
$description = _AM_XOONIPS_MAINTENANCE_FILESEARCH_DESC;

// breadcrumbs
$breadcrumbs = array(
  array(
    'type' => 'top',
    'label' => _AM_XOONIPS_TITLE,
    'url' => $xoonips_admin['admin_url'].'/',
  ),
  array(
    'type' => 'link',
    'label' => _AM_XOONIPS_MAINTENANCE_TITLE,
    'url' => $xoonips_admin['myfile_url'],
  ),
  array(
    'type' => 'label',
    'label' => $title,
    'url' => '',
  ),
);

// token ticket
require_once( '../class/base/gtickets.php' );
$ticket_area = 'xoonips_admin_maintenance_filesearch';
$token_ticket = $xoopsGTicket->getTicketHtml( __LINE__, 1800, $ticket_area );

$textutil =& xoonips_getutility( 'text' );

// load xoonips abstract layer for xnpGetFileSearchModules();
include_once '../include/lib.php';

function filesearch_adddot( $str ) {
  return '.'.$str;
}

$modules = xnpGetFileSearchModules();
$plugins = array();
$evenodd = 'odd';
foreach ( $modules as $module ) {
  $plugin['plugin'] = $textutil->html_special_chars( $module['display_name'] );
  $plugin['mimetype'] = $textutil->html_special_chars( $module['mime_type'][0] );
  $extensions = array_map( 'filesearch_adddot', $module['extensions'] );
  $plugin['suffixes'] = $textutil->html_special_chars( implode( ', ', $extensions ) );
  $plugin['version'] = $textutil->html_special_chars( $module['version'] );
  $plugin['evenodd'] = $evenodd;
  $evenodd = ( $evenodd == 'even' ) ? 'odd' : 'even';
  $plugins[] = $plugin;
}
$has_plugins = ( count( $plugins ) == 0 ) ? false : true;

// templates
require_once( '../class/base/pattemplate.class.php' );
$tmpl = new PatTemplate();
$tmpl->setBaseDir( 'templates' );
$tmpl->readTemplatesFromFile( 'maintenance_filesearch.tmpl.html' );

// assign template variables
$tmpl->addVar( 'header', 'TITLE', $title );
$tmpl->setAttribute( 'description', 'visibility', 'visible' );
$tmpl->addVar( 'description', 'DESCRIPTION', $description );
$tmpl->setAttribute( 'breadcrumbs', 'visibility', 'visible' );
$tmpl->addRows( 'breadcrumbs_items', $breadcrumbs );
$tmpl->addVar( 'main', 'token_ticket', $token_ticket );
$tmpl->addVar( 'main', 'plugins_title', _AM_XOONIPS_MAINTENANCE_FILESEARCH_PLUGINS_TITLE );
$tmpl->addVar( 'plugins_empty', 'empty', _AM_XOONIPS_MAINTENANCE_FILESEARCH_PLUGINS_EMPTY );
$tmpl->addVar( 'main', 'plugin', _AM_XOONIPS_MAINTENANCE_FILESEARCH_LABEL_PLUGIN );
$tmpl->addVar( 'main', 'mimetype', _AM_XOONIPS_MAINTENANCE_FILESEARCH_LABEL_MIMETYPE );
$tmpl->addVar( 'main', 'suffix', _AM_XOONIPS_MAINTENANCE_FILESEARCH_LABEL_SUFFIX );
$tmpl->addVar( 'main', 'version', _AM_XOONIPS_MAINTENANCE_FILESEARCH_LABEL_VERSION );
if ( $has_plugins ) {
  $tmpl->addRows( 'plugins', $plugins );
} else {
  $tmpl->setAttribute( 'plugins', 'visibility', 'hidden' );
  $tmpl->setAttribute( 'plugins_empty', 'visibility', 'visible' );
}
$tmpl->addVar( 'main', 'rescan', _AM_XOONIPS_MAINTENANCE_FILESEARCH_LABEL_RESCAN );
$tmpl->addVar( 'main', 'rescan_title', _AM_XOONIPS_MAINTENANCE_FILESEARCH_RESCAN_TITLE );
$tmpl->addVar( 'main', 'rescan_desc', _AM_XOONIPS_MAINTENANCE_FILESEARCH_RESCAN_DESC );

// display
xoops_cp_header();
$tmpl->displayParsedTemplate( 'main' );
xoops_cp_footer();

?>
