<?
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";
include_once XOOPS_ROOT_PATH.'/modules/xnparticle/include/view.php';

class XooNIpsArticle extends XooNIpsItem{

    function XooNIpsArticle(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnparticle_item_detail' );
        $this->initVar('detail_title'             , XOBJ_DTYPE_TXTBOX, null, false, $lengths['title'             ]);  // 'title' is already used by BASIC/TITLE. therefore use 'detail_title' for DETAIL/TITLE
        $this->initVar('detail_title_kana'        , XOBJ_DTYPE_TXTBOX, null, false, $lengths['title_kana'        ]);
        $this->initVar('detail_title_romaji'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['title_romaji'      ]);
        $this->initVar('detail_edition'           , XOBJ_DTYPE_TXTBOX, null, false, $lengths['edition'           ]);
        $this->initVar('detail_publish_place'     , XOBJ_DTYPE_TXTBOX, null, false, $lengths['publish_place'     ]);
        $this->initVar('detail_publisher'         , XOBJ_DTYPE_TXTBOX, null, false, $lengths['publisher'         ]);
        $this->initVar('detail_publisher_kana'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['publisher_kana'    ]);
        $this->initVar('detail_publisher_romaji'  , XOBJ_DTYPE_TXTBOX, null, false, $lengths['publisher_romaji'  ]);
        $this->initVar('detail_year_f'            , XOBJ_DTYPE_TXTBOX, null, false, $lengths['year_f'            ]);
        $this->initVar('detail_year_t'            , XOBJ_DTYPE_TXTBOX, null, false, $lengths['year_t'            ]);
        $this->initVar('detail_date_create'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['date_create'       ]);
        $this->initVar('detail_date_update'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['date_update'       ]);
        $this->initVar('detail_date_record'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['date_record'       ]);
        $this->initVar('detail_jtitle'            , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle'            ]);
        $this->initVar('detail_jtitle_translation', XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_translation']);
        $this->initVar('detail_jtitle_volume'     , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_volume'     ]);
        $this->initVar('detail_jtitle_issue'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_issue'      ]);
        $this->initVar('detail_jtitle_year'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_year'       ]);
        $this->initVar('detail_jtitle_month'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_month'      ]);
        $this->initVar('detail_jtitle_spage'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_spage'      ]);
        $this->initVar('detail_jtitle_epage'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['jtitle_epage'      ]);
        $this->initVar('detail_abstract'          , XOBJ_DTYPE_TXTBOX, null, false, $lengths['abstract'          ]);
        $this->initVar('detail_table_of_contents' , XOBJ_DTYPE_TXTBOX, null, false, $lengths['table_of_contents' ]);
        $this->initVar('detail_type_of_resource'  , XOBJ_DTYPE_TXTBOX, null, false, $lengths['type_of_resource'  ]);
        $this->initVar('detail_genre'             , XOBJ_DTYPE_TXTBOX, null, false, $lengths['genre'             ]);
        $this->initVar('detail_access_condition'  , XOBJ_DTYPE_TXTBOX, null, false, $lengths['access_condition'  ]);
        $this->initVar('article_attachment'       , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('preview'                  , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->attachment_info = array(
            'article_attachment' => array( 'multiple' => false  ),
            'preview'            => array( 'multiple' => true  ),
        );
        
        $this->initVar('detail_sub_title'            , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_author'               , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_keywords'             , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_ndc_classifications'  , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_physical_descriptions', XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_langs'                , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_id_issns'             , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_id_isbns'             , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_id_dois'              , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_id_uris'              , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_id_locals'            , XOBJ_DTYPE_ARRAY, serialize(null), false);
        $this->initVar('detail_uris'                 , XOBJ_DTYPE_ARRAY, serialize(null), false);
        
        $this->childColumnLengths = array( 
            'SUB_TITLE'             => $this->getColumnMaxLen( 'xnparticle_item_detail_child_sub_title'             ),
            'AUTHOR'                => $this->getColumnMaxLen( 'xnparticle_item_detail_child_author'                ),
            'KEYWORDS'              => $this->getColumnMaxLen( 'xnparticle_item_detail_child_keywords'              ),
            'NDC_CLASSIFICATIONS'   => $this->getColumnMaxLen( 'xnparticle_item_detail_child_ndc_classifications'   ),
            'PHYSICAL_DESCRIPTIONS' => $this->getColumnMaxLen( 'xnparticle_item_detail_child_physical_descriptions' ),
            'LANGS'                 => $this->getColumnMaxLen( 'xnparticle_item_detail_child_langs'                 ),
            'ID_ISSNS'              => $this->getColumnMaxLen( 'xnparticle_item_detail_child_id_issns'              ),
            'ID_ISBNS'              => $this->getColumnMaxLen( 'xnparticle_item_detail_child_id_isbns'              ),
            'ID_DOIS'               => $this->getColumnMaxLen( 'xnparticle_item_detail_child_id_dois'               ),
            'ID_URIS'               => $this->getColumnMaxLen( 'xnparticle_item_detail_child_id_uris'               ),
            'ID_LOCALS'             => $this->getColumnMaxLen( 'xnparticle_item_detail_child_id_locals'             ),
            'URIS'                  => $this->getColumnMaxLen( 'xnparticle_item_detail_child_uris'                  ),
        );
    }

    function cleanVars()
    {
        $retval = true;
        if ( !parent::cleanVars() )
            $retval = false;
        
        $vals = array(
            'title'             => $this->getVar('detail_title'             ,'n'),
            'title_kana'        => $this->getVar('detail_title_kana'        ,'n'),
            'title_romaji'      => $this->getVar('detail_title_romaji'      ,'n'),
            'edition'           => $this->getVar('detail_edition'           ,'n'),
            'publish_place'     => $this->getVar('detail_publish_place'     ,'n'),
            'publisher'         => $this->getVar('detail_publisher'         ,'n'),
            'publisher_kana'    => $this->getVar('detail_publisher_kana'    ,'n'),
            'publisher_romaji'  => $this->getVar('detail_publisher_romaji'  ,'n'),
            'year_f'            => $this->getVar('detail_year_f'            ,'n'),
            'year_t'            => $this->getVar('detail_year_t'            ,'n'),
            'date_create'       => $this->getVar('detail_date_create'       ,'n'),
            'date_update'       => $this->getVar('detail_date_update'       ,'n'),
            'date_record'       => $this->getVar('detail_date_record'       ,'n'),
            'jtitle'            => $this->getVar('detail_jtitle'            ,'n'),
            'jtitle_translation'=> $this->getVar('detail_jtitle_translation','n'),
            'jtitle_volume'     => $this->getVar('detail_jtitle_volume'     ,'n'),
            'jtitle_issue'      => $this->getVar('detail_jtitle_issue'      ,'n'),
            'jtitle_year'       => $this->getVar('detail_jtitle_year'       ,'n'),
            'jtitle_month'      => $this->getVar('detail_jtitle_month'      ,'n'),
            'jtitle_spage'      => $this->getVar('detail_jtitle_spage'      ,'n'),
            'jtitle_epage'      => $this->getVar('detail_jtitle_epage'      ,'n'),
            'abstract'          => $this->getVar('detail_abstract'          ,'n'),
            'table_of_contents' => $this->getVar('detail_table_of_contents' ,'n'),
            'type_of_resource'  => $this->getVar('detail_type_of_resource'  ,'n'),
            'genre'             => $this->getVar('detail_genre'             ,'n'),
            'access_condition'  => $this->getVar('detail_access_condition'  ,'n'),
        );
        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars['detail_'.$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars['detail_'.$key] = $val;
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        // check length for xnp_article_item_detail_child_* tables
        foreach ( array('sub_title', 'author') as $table_name ){
            $rows = $this->getVar('detail_'.$table_name);
            $cleanRows = array();
            foreach ( $rows as $row ){
                $ar = $this->stripSurplusString( $this->childColumnLengths[strtoupper($table_name)], $row );
                $cleanRow = array();
                foreach ( $row as $key => $val ){
                    if ( isset( $ar[$key] ) ){
                        $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $table_name $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                        $cleanRow[$key] = $ar[$key];
                        $retval = false;
                    }
                    else
                        $cleanRow[$key] = $val;
                }
                $cleanRows[] = $cleanRow;
            }
            $this->cleanVars['detail_'.$table_name] = $cleanRows;
        }
        
        foreach (
          array(
            'keywords'             ,
            'ndc_classifications'  ,
            'physical_descriptions',
            'langs'                ,
            'id_issns'             ,
            'id_isbns'             ,
            'id_dois'              ,
            'id_uris'              ,
            'id_locals'            ,
            'uris'                 ,
          ) as $name ){
            $rows = $this->getVar('detail_'.$name);
            $cleans = array();
            foreach ( $rows as $val ){
                $ar = $this->stripSurplusString( $this->childColumnLengths[strtoupper($name)], array( $name => $val ) );
                if ( count( $ar ) ){
                    $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $name is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                    $cleans[] = $ar[$name];
                    $retval = false;
                }
                else
                    $cleans[] = $val;
            }
            $this->cleanVars['detail_'.$name] = $cleans;
        }
        
        return $retval;
    }
    
    
    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    var $childColumnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        $tag = strtolower( end( $this -> tagstack ) );
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $this->setVar( 'detail_sub_title'            , serialize(array()), true );
            $this->setVar( 'detail_author'               , serialize(array()), true );
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            break;
        case 'ITEM/DETAIL/KEYWORDS'             :
        case 'ITEM/DETAIL/NDC_CLASSIFICATIONS'  :
        case 'ITEM/DETAIL/PHYSICAL_DESCRIPTIONS':
        case 'ITEM/DETAIL/LANGS'                :
        case 'ITEM/DETAIL/ID_ISSNS'             :
        case 'ITEM/DETAIL/ID_ISBNS'             :
        case 'ITEM/DETAIL/ID_DOIS'              :
        case 'ITEM/DETAIL/ID_URIS'              :
        case 'ITEM/DETAIL/ID_LOCALS'            :
        case 'ITEM/DETAIL/URIS'                 :
            $this->setVar( 'detail_'.$tag, serialize(array()) );
            break;
        case "ITEM/DETAIL/SUB_TITLE": 
        case "ITEM/DETAIL/AUTHOR": 
            $a = $this->getVar( 'detail_'.$tag );
            $a[] = array();
            $this->setVar( 'detail_'.$tag, serialize( $a ), true );
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        $data = encodeMeta2Server( end( $this -> cdata ) );
        $tag = strtolower( end( $this -> tagstack ) );
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'title'             ,
                'title_kana'        ,
                'title_romaji'      ,
                'edition'           ,
                'publish_place'     ,
                'publisher'         ,
                'publisher_kana'    ,
                'publisher_romaji'  ,
                'year_f'            ,
                'year_t'            ,
                'date_create'       ,
                'date_update'       ,
                'date_record'       ,
                'jtitle'            ,
                'jtitle_translation',
                'jtitle_volume'     ,
                'jtitle_issue'      ,
                'jtitle_year'       ,
                'jtitle_month'      ,
                'jtitle_spage'      ,
                'jtitle_epage'      ,
                'abstract'          ,
                'table_of_contents' ,
                'type_of_resource'  ,
                'genre'             ,
                'access_condition'  ,
                'keywords'             ,
                'ndc_classifications'  ,
                'physical_descriptions',
                'langs'                ,
                'id_issns'             ,
                'id_isbns'             ,
                'id_dois'              ,
                'id_uris'              ,
                'id_locals'            ,
                'uris'                 ,
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar('detail_'.$key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case 'ITEM/DETAIL/TITLE'             :
        case 'ITEM/DETAIL/TITLE_KANA'        :
        case 'ITEM/DETAIL/TITLE_ROMAJI'      :
        case 'ITEM/DETAIL/EDITION'           :
        case 'ITEM/DETAIL/PUBLISH_PLACE'     :
        case 'ITEM/DETAIL/PUBLISHER'         :
        case 'ITEM/DETAIL/PUBLISHER_KANA'    :
        case 'ITEM/DETAIL/PUBLISHER_ROMAJI'  :
        case 'ITEM/DETAIL/YEAR_F'            :
        case 'ITEM/DETAIL/YEAR_T'            :
        case 'ITEM/DETAIL/DATE_CREATE'       :
        case 'ITEM/DETAIL/DATE_UPDATE'       :
        case 'ITEM/DETAIL/DATE_RECORD'       :
        case 'ITEM/DETAIL/JTITLE'            :
        case 'ITEM/DETAIL/JTITLE_TRANSLATION':
        case 'ITEM/DETAIL/JTITLE_VOLUME'     :
        case 'ITEM/DETAIL/JTITLE_ISSUE'      :
        case 'ITEM/DETAIL/JTITLE_YEAR'       :
        case 'ITEM/DETAIL/JTITLE_MONTH'      :
        case 'ITEM/DETAIL/JTITLE_SPAGE'      :
        case 'ITEM/DETAIL/JTITLE_EPAGE'      :
        case 'ITEM/DETAIL/ABSTRACT'          :
        case 'ITEM/DETAIL/TABLE_OF_CONTENTS' :
        case 'ITEM/DETAIL/TYPE_OF_RESOURCE'  :
        case 'ITEM/DETAIL/GENRE'             :
        case 'ITEM/DETAIL/ACCESS_CONDITION'  :
            $this -> setVar( 'detail_'.$tag, $data, true );
            break;

        case "ITEM/DETAIL/SUB_TITLE": 
            $tmp = $this->getVar( 'detail_sub_title' );
            $tmp = $tmp[ count($tmp)-1 ];
            $keys = array(
                'sub_title_name'       ,
                'sub_title_kana'       ,
                'sub_title_romaji'     ,
            );
            foreach ( $keys as $key )
                if ( !isset( $tmp[$key] ) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no sub_title $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case "ITEM/DETAIL/AUTHOR": 
            $tmp = $this->getVar( 'detail_author' );
            $tmp = $tmp[ count($tmp)-1 ];
            $keys = array(
                'author_id'                     ,
                'author_name'                   ,
                'author_kana'                   ,
                'author_romaji'                 ,
                'author_affiliation'            ,
                'author_affiliation_translation',
                'author_role'                   ,
                'author_link'                   ,
            );
            foreach ( $keys as $key )
                if ( !isset( $tmp[$key] ) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no author $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case 'ITEM/DETAIL/SUB_TITLE/SUB_TITLE_NAME'  :
        case 'ITEM/DETAIL/SUB_TITLE/SUB_TITLE_KANA'  :
        case 'ITEM/DETAIL/SUB_TITLE/SUB_TITLE_ROMAJI':
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_ID'                     :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_NAME'                   :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_KANA'                   :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_ROMAJI'                 :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION'            :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_AFFILIATION_TRANSLATION':
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_ROLE'                   :
        case 'ITEM/DETAIL/AUTHOR/AUTHOR_LINK'                   :
            $a = $this->getVar( 'detail_'.strtolower($this->tagstack[2]) );
            $a[ count($a)-1 ][$tag] = $data;
            $this->setVar( 'detail_'.strtolower($this->tagstack[2]), serialize( $a ), true );
            break;
        case 'ITEM/DETAIL/KEYWORDS/KEYWORD':
        case 'ITEM/DETAIL/NDC_CLASSIFICATIONS/NDC_CLASSIFICATION':
        case 'ITEM/DETAIL/PHYSICAL_DESCRIPTIONS/PHYSICAL_DESCRIPTION':
        case 'ITEM/DETAIL/LANGS/LANG':
        case 'ITEM/DETAIL/ID_ISSNS/ID_ISSN':
        case 'ITEM/DETAIL/ID_ISBNS/ID_ISBN':
        case 'ITEM/DETAIL/ID_DOIS/ID_DOI':
        case 'ITEM/DETAIL/ID_URIS/ID_URI':
        case 'ITEM/DETAIL/ID_LOCALS/ID_LOCAL':
        case 'ITEM/DETAIL/URIS/URI':
            $a = $this->getVar( 'detail_'.strtolower($this->tagstack[2]) );
            $a[] = $data;
            $this->setVar( 'detail_'.strtolower($this->tagstack[2]), serialize( $a ), true );
            break;

        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert into xnparticle_item_detail_child_* table
     * @return false if failed, true if insert successfully or already exists and unchanged.
     */
    function insert_child(){
        global $xoopsDB;
        
        $i = 0;
        foreach ( $this->cleanVars['detail_sub_title'] as $row ){
            $keys = implode( ",", array(
                'article_id'           ,
                'sub_title_name'       ,
                'sub_title_kana'       ,
                'sub_title_romaji'     ,
                'sub_title_order '     ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $row['sub_title_name'       ] ) ? 'null' : $xoopsDB -> quoteString( $row['sub_title_name'       ] ),
                is_null( $row['sub_title_kana'       ] ) ? 'null' : $xoopsDB -> quoteString( $row['sub_title_kana'       ] ),
                is_null( $row['sub_title_romaji'     ] ) ? 'null' : $xoopsDB -> quoteString( $row['sub_title_romaji'     ] ),
                $i++,
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnparticle_item_detail_child_sub_title") . " ( $keys ) VALUES ( $vals ) ";
            $result = $xoopsDB->query($sql);
            if (!$result) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
        }
        
        $i = 0;
        foreach ( $this->cleanVars[ 'detail_author' ] as $row ){
            $keys = implode( ",", array(
                'article_id'                    ,
                'author_id'                     ,
                'author_name'                   ,
                'author_kana'                   ,
                'author_romaji'                 ,
                'author_affiliation'            ,
                'author_affiliation_translation',
                'author_role'                   ,
                'author_link'                   ,
                'author_order'                  ,

            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $row['author_id'                     ] ) ? "''" : $xoopsDB -> quoteString( $row['author_id'                     ] ),
                is_null( $row['author_name'                   ] ) ? "''" : $xoopsDB -> quoteString( $row['author_name'                   ] ),
                is_null( $row['author_kana'                   ] ) ? "''" : $xoopsDB -> quoteString( $row['author_kana'                   ] ),
                is_null( $row['author_romaji'                 ] ) ? "''" : $xoopsDB -> quoteString( $row['author_romaji'                 ] ),
                is_null( $row['author_affiliation'            ] ) ? "''" : $xoopsDB -> quoteString( $row['author_affiliation'            ] ),
                is_null( $row['author_affiliation_translation'] ) ? "''" : $xoopsDB -> quoteString( $row['author_affiliation_translation'] ),
                is_null( $row['author_role'                   ] ) ? "''" : $xoopsDB -> quoteString( $row['author_role'                   ] ),
                is_null( $row['author_link'                   ] ) ? "''" : $xoopsDB -> quoteString( $row['author_link'                   ] ),
                $i++,
            ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnparticle_item_detail_child_author") . " ( $keys ) VALUES ( $vals ) ";
            $result = $xoopsDB->query($sql);
            if (!$result) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
        }
        
        
        $names = array( 
          'keyword'             ,
          'ndc_classification'  ,
          'physical_description',
          'lang'                ,
          'id_issn'             ,
          'id_isbn'             ,
          'id_doi'              ,
          'id_uri'              ,
          'id_local'            ,
          'uri'                 ,
        );
        
        foreach ( $names as $name ){
            $i = 0;
            foreach ( $this->cleanVars[ "detail_${name}s" ] as $keyword ){
                $keys = implode( ",", array(
                    'article_id'                  ,
                    "${name}s"                    ,
                    "${name}s_order"              ,
                ) );
                $vals = implode( ",", array(
                    $this -> getVar( 'item_id' ),
                    $xoopsDB -> quoteString( $keyword ),
                    $i++,
                ) );
                $sql = "INSERT INTO " . $xoopsDB->prefix("xnparticle_item_detail_child_${name}s") . " ( $keys ) VALUES ( $vals ) ";
                $result = $xoopsDB->query($sql);
                if (!$result) {
                    $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                    return false;
                }
            }
        }
        
        return true;
    }
    
    
    /**
     * insert/update object
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;

            $keys = implode( ",", array(
                'article_id'         ,
                'title'             ,
                'title_kana'        ,
                'title_romaji'      ,
                'edition'           ,
                'publish_place'     ,
                'publisher'         ,
                'publisher_kana'    ,
                'publisher_romaji'  ,
                'year_f'            ,
                'year_t'            ,
                'date_create'       ,
                'date_update'       ,
                'date_record'       ,
                'jtitle'            ,
                'jtitle_translation',
                'jtitle_volume'     ,
                'jtitle_issue'      ,
                'jtitle_year'       ,
                'jtitle_month'      ,
                'jtitle_spage'      ,
                'jtitle_epage'      ,
                'abstract'          ,
                'table_of_contents' ,
                'type_of_resource'  ,
                'genre'             ,
                'access_condition'  ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $this -> cleanVars[ 'detail_title'              ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title'              ] ),
                is_null( $this -> cleanVars[ 'detail_title_kana'         ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title_kana'         ] ),
                is_null( $this -> cleanVars[ 'detail_title_romaji'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title_romaji'       ] ),
                is_null( $this -> cleanVars[ 'detail_edition'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_edition'            ] ),
                is_null( $this -> cleanVars[ 'detail_publish_place'      ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publish_place'      ] ),
                is_null( $this -> cleanVars[ 'detail_publisher'          ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher'          ] ),
                is_null( $this -> cleanVars[ 'detail_publisher_kana'     ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher_kana'     ] ),
                is_null( $this -> cleanVars[ 'detail_publisher_romaji'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher_romaji'   ] ),
                is_null( $this -> cleanVars[ 'detail_year_f'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_year_f'             ] ),
                is_null( $this -> cleanVars[ 'detail_year_t'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_year_t'             ] ),
                is_null( $this -> cleanVars[ 'detail_date_create'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_create'        ] ),
                is_null( $this -> cleanVars[ 'detail_date_update'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_update'        ] ),
                is_null( $this -> cleanVars[ 'detail_date_record'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_record'        ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle'             ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_translation' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_translation' ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_volume'      ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_volume'      ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_issue'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_issue'       ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_year'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_year'        ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_month'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_month'       ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_spage'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_spage'       ] ),
                is_null( $this -> cleanVars[ 'detail_jtitle_epage'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_epage'       ] ),
                is_null( $this -> cleanVars[ 'detail_abstract'           ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_abstract'           ] ),
                is_null( $this -> cleanVars[ 'detail_table_of_contents'  ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_table_of_contents'  ] ),
                is_null( $this -> cleanVars[ 'detail_type_of_resource'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_type_of_resource'   ] ),
                is_null( $this -> cleanVars[ 'detail_genre'              ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_genre'              ] ),
                is_null( $this -> cleanVars[ 'detail_access_condition'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_access_condition'   ] ),
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnparticle_item_detail") . " ( $keys ) VALUES ( $vals ) ";
            $result = $xoopsDB->query($sql);
            if (!$result) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
            
            if ( !$this->insert_child() ){
                @$this -> delete();
                return false;
            }
            
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            
            $keyval = implode( ', ', array(
                'title'              . '=' . ( is_null( $this -> cleanVars[ 'detail_title'              ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title'              ] ) ),
                'title_kana'         . '=' . ( is_null( $this -> cleanVars[ 'detail_title_kana'         ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title_kana'         ] ) ),
                'title_romaji'       . '=' . ( is_null( $this -> cleanVars[ 'detail_title_romaji'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_title_romaji'       ] ) ),
                'edition'            . '=' . ( is_null( $this -> cleanVars[ 'detail_edition'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_edition'            ] ) ),
                'publish_place'      . '=' . ( is_null( $this -> cleanVars[ 'detail_publish_place'      ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publish_place'      ] ) ),
                'publisher'          . '=' . ( is_null( $this -> cleanVars[ 'detail_publisher'          ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher'          ] ) ),
                'publisher_kana'     . '=' . ( is_null( $this -> cleanVars[ 'detail_publisher_kana'     ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher_kana'     ] ) ),
                'publisher_romaji'   . '=' . ( is_null( $this -> cleanVars[ 'detail_publisher_romaji'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_publisher_romaji'   ] ) ),
                'year_f'             . '=' . ( is_null( $this -> cleanVars[ 'detail_year_f'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_year_f'             ] ) ),
                'year_t'             . '=' . ( is_null( $this -> cleanVars[ 'detail_year_t'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_year_t'             ] ) ),
                'date_create'        . '=' . ( is_null( $this -> cleanVars[ 'detail_date_create'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_create'        ] ) ),
                'date_update'        . '=' . ( is_null( $this -> cleanVars[ 'detail_date_update'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_update'        ] ) ),
                'date_record'        . '=' . ( is_null( $this -> cleanVars[ 'detail_date_record'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_date_record'        ] ) ),
                'jtitle'             . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle'             ] ) ),
                'jtitle_translation' . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_translation' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_translation' ] ) ),
                'jtitle_volume'      . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_volume'      ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_volume'      ] ) ),
                'jtitle_issue'       . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_issue'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_issue'       ] ) ),
                'jtitle_year'        . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_year'        ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_year'        ] ) ),
                'jtitle_month'       . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_month'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_month'       ] ) ),
                'jtitle_spage'       . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_spage'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_spage'       ] ) ),
                'jtitle_epage'       . '=' . ( is_null( $this -> cleanVars[ 'detail_jtitle_epage'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_jtitle_epage'       ] ) ),
                'abstract'           . '=' . ( is_null( $this -> cleanVars[ 'detail_abstract'           ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_abstract'           ] ) ),
                'table_of_contents'  . '=' . ( is_null( $this -> cleanVars[ 'detail_table_of_contents'  ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_table_of_contents'  ] ) ),
                'type_of_resource'   . '=' . ( is_null( $this -> cleanVars[ 'detail_type_of_resource'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_type_of_resource'   ] ) ),
                'genre'              . '=' . ( is_null( $this -> cleanVars[ 'detail_genre'              ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_genre'              ] ) ),
                'access_condition'   . '=' . ( is_null( $this -> cleanVars[ 'detail_access_condition'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_access_condition'   ] ) ),
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnparticle_item_detail") . " set $keyval where article_id=$item_id";
            $result = $xoopsDB->query($sql);
            if (!$result) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
            
            $tables = array(
                'xnparticle_item_detail_child_sub_title'            ,
                'xnparticle_item_detail_child_author'               ,
                'xnparticle_item_detail_child_keywords'             ,
                'xnparticle_item_detail_child_ndc_classifications'  ,
                'xnparticle_item_detail_child_physical_descriptions',
                'xnparticle_item_detail_child_langs'                ,
                'xnparticle_item_detail_child_id_issns'             ,
                'xnparticle_item_detail_child_id_isbns'             ,
                'xnparticle_item_detail_child_id_dois'              ,
                'xnparticle_item_detail_child_id_uris'              ,
                'xnparticle_item_detail_child_id_locals'            ,
                'xnparticle_item_detail_child_uris'                 ,
            );
            foreach ( $tables as $table ){
                $sql = "DELETE FROM " . $xoopsDB->prefix($table) . " WHERE article_id=$item_id";
                $result = $xoopsDB->query($sql);
                if (!$result) {
                    $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                    @$this -> delete();
                    return false;
                }
            }
            
            if ( !$this->insert_child() ){
                @$this -> delete();
                return false;
            }
        }
        
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        
        $item_id = $this->getVar( 'item_id' );
        $tables = array( 
            'xnparticle_item_detail',
            'xnparticle_item_detail_child_sub_title'            ,
            'xnparticle_item_detail_child_author'               ,
            'xnparticle_item_detail_child_keywords'             ,
            'xnparticle_item_detail_child_ndc_classifications'  ,
            'xnparticle_item_detail_child_physical_descriptions',
            'xnparticle_item_detail_child_langs'                ,
            'xnparticle_item_detail_child_id_issns'             ,
            'xnparticle_item_detail_child_id_isbns'             ,
            'xnparticle_item_detail_child_id_dois'              ,
            'xnparticle_item_detail_child_id_uris'              ,
            'xnparticle_item_detail_child_id_locals'            ,
            'xnparticle_item_detail_child_uris'                 ,
        );
        foreach ( $tables as $table ){
            $sql = sprintf( "DELETE FROM %s WHERE article_id = %u", $xoopsDB->prefix( $table ), $item_id );
            $result = $xoopsDB->query( $sql );
            if (!$result) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
        }

        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function escape( $htmlspecialchars, $val ){
        if( extension_loaded( 'mbstring' ) ){
            $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
        }else{
            $val = strreplace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
        }
        
        if ( $htmlspecialchars )
            $val = htmlspecialchars( $val );
        return $val;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'article_id' || $key == 'link' ) continue;
            $ar[] = "detail.$key " . $this->escape( $htmlspecialchars, $this->getVar('detail_'.$key,'n') );
        }
        
        $sub_titles = $this->getVar('detail_sub_title');
        $len = count($sub_titles);
        $keys = array(
                'sub_title_name'       ,
                'sub_title_kana'       ,
                'sub_title_romaji'     ,
        );
        for ( $i = 0; $i < $len; $i++ ){
            foreach ( $keys as $key ){
                if ( isset($sub_titles[$i][$key]) )
                    $ar[] = "detail.sub_title.$i.$key " . $this->escape( $htmlspecialchars, $sub_titles[$i][$key] );
            }
        }
        
        $authors = $this->getVar('detail_author');
        $len = count($authors);
        $keys = array(
                'author_name'                   ,
                'author_kana'                   ,
                'author_romaji'                 ,
                'author_affiliation'            ,
                'author_affiliation_translation',
        );
        for ( $i = 0; $i < $len; $i++ ){
            foreach ( $keys as $key ){
                if ( isset($authors[$i][$key]) )
                    $ar[] = "detail.authors.$i.$key " . $this->escape( $htmlspecialchars, $authors[$i][$key] );
            }
        }
        
        $names = array(
            'keyword'             ,
            'ndc_classification'  ,
            'physical_description',
            'lang'                ,
            'id_issn'             ,
            'id_isbn'             ,
            'id_doi'              ,
            'id_uri'              ,
            'id_local'            ,
            'uri'                 ,
        );
        foreach ( $names as $name ){
            foreach ( $this->getVar("detail_${name}s") as $val ){
                $ar[] = "detail.${name}s.$name " . $this->escape( $htmlspecialchars, $val );
            }
        }
        
        return  implode( "\n", $ar );
    }
    
}
?>
