<?php

require_once 'root.class.php';


//******************************************************************************

class CM_TopicComment extends CM_Root
{
	var $handler = NULL;
	
	//--------------------------------------------------------------------------
	
	function CM_TopicComment()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_commu_topic_comment_id', XOBJ_DTYPE_INT);
		$this->initVar('c_commu_topic_id', XOBJ_DTYPE_INT);
		$this->initVar('c_commu_id', XOBJ_DTYPE_INT);
		$this->initVar('uid', XOBJ_DTYPE_INT);
		$this->initVar('body', XOBJ_DTYPE_TXTAREA);
		$this->initVar('r_datetime', XOBJ_DTYPE_TXTBOX);
		$this->initVar('r_date', XOBJ_DTYPE_TXTBOX);
		$this->initVar('number', XOBJ_DTYPE_INT);

		$this->handler = array(
			'image' => CM_ImageHandler::getInstance(),
			'file' => CM_FileHandler::getInstance(),
		);
	}
	
	//--------------------------------------------------------------------------
	
	function &getImageList($thumb_id=_CM_IMAGE_SIZE_M)
	{
		return $this->handler['image']->getList(2, $this->getVar('c_commu_topic_comment_id'), $thumb_id);
	}
	
	//--------------------------------------------------------------------------
	
	function &getFileList()
	{
		return $this->handler['file']->getList(2, $this->getVar('c_commu_topic_comment_id'));
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

class CM_TopicCommentHandler extends CM_RootHandler
{
	//--------------------------------------------------------------------------
	
	function CM_TopicCommentHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_TopicComment";
		$this->table_name = "c_commu_topic_comment";
		$this->primary_key = "c_commu_topic_comment_id";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_TopicCommentHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &getListByTopicId($topic_id, $limit=0, $start=0)
	{
		$criteria = new CriteriaCompo(new Criteria('c_commu_topic_id', $topic_id));
		$criteria->setSort('number');
		$criteria->setLimit($limit);
		$criteria->setStart($start);
		$obj_list =& $this->getObjects($criteria);
		$ret = array();
		foreach($obj_list as $obj){
			$ret[$obj->getVar('number')] = $obj->getVarsArray();
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function getCountByTopicId($topic_id)
	{
		$criteria = new Criteria('c_commu_topic_id', $topic_id);
		return $this->getCount($criteria);
	}
	
	//--------------------------------------------------------------------------
	
	function &getByNumber($topic_id, $number)
	{
		$ret = NULL;
		$criteria = new CriteriaCompo(new Criteria('c_commu_topic_id', $topic_id));
		$criteria->add(new Criteria('number', $number));
		$obj_list =& $this->getObjects($criteria);
		if(count($obj_list)==1){
			$ret =& $obj_list[0];
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function &getListByNumbers($topic_id, $numbers, $number_as_key=true)
	{
		$criteria = new CriteriaCompo(new Criteria('c_commu_topic_id', $topic_id));
		$criteria->add(new Criteria('number', '('.implode(',', $numbers).')', 'IN'));
		$obj_list =& $this->getObjects($criteria, true);
		$ret = array();
		foreach($obj_list as $obj){
			if($number_as_key){
				$ret[$obj->getVar('number')] = $obj->getVarsArray();
			}
			else{
				$ret[] = $obj->getVarsArray();
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
}

//******************************************************************************

?>
