<?php

require_once 'root.class.php';

//******************************************************************************

class CM_Member extends CM_Root
{
	var $handler = NULL;
	
	//--------------------------------------------------------------------------
	
	function CM_Member()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_commu_member_id', XOBJ_DTYPE_INT);
		$this->initVar('uid', XOBJ_DTYPE_INT);
		$this->initVar('c_commu_id', XOBJ_DTYPE_INT);
		$this->initVar('r_datetime', XOBJ_DTYPE_TXTBOX);
		
		$this->handler = array(
			'user' => CM_UserHandler::getInstance(),
		);
	}
	
	//--------------------------------------------------------------------------
	
	function &getInfo()
	{
		$ret = NULL;
		$user =& $this->handler['user']->get($this->getVar('uid'));
		if(!is_object($user)){
			return $ret;
		}
		$ret =& $user->getInfo();
		$ret['r_datetime'] = $this->getVar('r_datetime');
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

class CM_MemberHandler extends CM_RootHandler
{
	
	//--------------------------------------------------------------------------
	
	function CM_MemberHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_Member";
		$this->table_name = "c_commu_member";
		$this->primary_key = "c_commu_member_id";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_MemberHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &get($cid, $uid)
	{
		$ret = false;
		$criteria = new CriteriaCompo(new Criteria('cm.c_commu_id', $cid));
		$criteria->add(new Criteria('cm.uid', $uid));
		$user =& $this->getObjects($criteria);
		if(count($user)==1 && is_object($user[0])){
			$ret =& $user[0];
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function &getObjects($criteria = NULL, $id_as_key = false)
	{
		$ret = array();
		$limit = $start = 0;
		$sql = "SELECT cm.* FROM ".
				$this->prefix($this->table_name)." cm,".
				$this->db->prefix('users')." u,".
				$this->prefix('c_commu')." c";
		if (!isset($criteria) || !is_subclass_of($criteria, 'criteriaelement')) {
			$sql .= " WHERE cm.uid=u.uid AND cm.c_commu_id=c.c_commu_id";
		}
		else{
			if($criteria->renderWhere() != ''){
				$sql .= " ".$criteria->renderWhere(). " AND cm.uid=u.uid AND cm.c_commu_id=c.c_commu_id";
			}
			if ($criteria->getSort() != '') {
				$sql .= " ORDER BY ".$criteria->getSort()." ".$criteria->getOrder();
			}
			$limit = $criteria->getLimit();
			$start = $criteria->getStart();
		}
		$result = $this->db->query($sql, $limit, $start);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->db->fetchArray($result)) {
			$obj =& new $this->obj_class();
			$obj->assignVars($row);
			if (!$id_as_key) {
				$ret[] =& $obj;
			}
			else {
				$ret[$row[$this->primary_key]] =& $obj;
			}
			unset($obj);
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function getCount($criteria = NULL)
	{
		$sql = "SELECT cm.* FROM ".$this->prefix($this->table_name)." cm,".
				$this->db->prefix('users')." u,".
				$this->prefix('c_commu')." c";
		if (!isset($criteria) || !is_subclass_of($criteria, 'criteriaelement')) {
			$sql .= " WHERE cm.uid=u.uid AND cm.c_commu_id=c.c_commu_id";
		}
		elseif($criteria->renderWhere() != ''){
			$sql .= " ".$criteria->renderWhere(). " AND cm.uid=u.uid AND cm.c_commu_id=c.c_commu_id";
		}
		
		$result = $this->db->query($sql);
		if ($result) {
			return $this->db->getRowsNum($result);
		}
		return 0;
	}
	
	//--------------------------------------------------------------------------
	
	function getUserInfo($cid, $uid)
	{
		$c_member =& $this->get($cid, $uid);
		if(is_object($c_member)){
			return $c_member->getInfo();
		}
		else{
			// removed user's info
			$ret = array(
				'uid' => 0,
				'name' => "",
				'page_url' => "",
				'avatar_url' => "",
				'avatar_width' => 0,
				'avatar_height' => 0,
				'last_login' => "",
			);
			return $ret;
		}
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

?>
