<?php
class editAction extends topicAction
{

function dispatch(&$context)
{
	global $xoopsUser;
	
	if($this->isGuest()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$own_uid = $xoopsUser->getVar('uid');
	
	$tid = $this->getIntRequest('tid', APP_REQUEST_GET);
	if(!isset($tid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$num = $this->getIntRequest('n', APP_REQUEST_GET);
	if(!isset($num) || $num < 0){
		$num = 0;
	}
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$topic_handler =& CM_TopicHandler::getInstance();
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	
	// ȥԥåμ
	$topic =& $topic_handler->get($tid);
	if(!is_object($topic)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$cid = $topic->getVar('c_commu_id');
	$community =& $commu_handler->get($cid);
	if(!is_object($community)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$commu_auth = $community->getAuthority();
	if($commu_auth < _CM_AUTH_MEMBER){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// Ȥμ
	$comment =& $comment_handler->getByNumber($tid, $num);
	if(!is_object($comment)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$topic_data = $comment_data = array();
	
	$topic_uid = $topic->getVar('uid');
	$comment_uid = $comment->getVar('uid');
	
	if($comment_uid > 0
	   && ($own_uid == $topic_uid || $own_uid == $comment_uid || $commu_auth >= _CM_AUTH_SUB_ADMIN)){
		
		$topic_data = array(
			'id' => $tid,
			'name' => $topic->getVar('name', 'e'),
		);
		
		$tcid = $comment->getVar('c_commu_topic_comment_id');
		
		$comment_data = array(
			'number' => $num,
			'body' => $comment->getVar('body', 'e'),
			'images' => $comment->getImageList(_CM_IMAGE_SIZE_S),
			'files' => $comment->getFileList(),
		);
	}
	else{
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$commu_info = array('id' => $cid, 'name' => $community->getVar('name'));
	
	$context->setAttributes('community', $commu_info);
	$context->setAttributes('topic', $topic_data);
	$context->setAttributes('comment', $comment_data);
}
}
?>
