<?php
class add_confirmAction extends topicAction
{

function dispatch(&$context)
{
	if($this->isGuest()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$cid = $this->getIntRequest('cid');
	if(!isset($cid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$commu_handler =& CM_CommunityHandler::getInstance();
	$community =& $commu_handler->get($cid);
	if(!is_object($community) || !$community->checkAuthority()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$name = $this->getTextRequest('name');
	$body = $this->getTextRequest('body');
	$errors = array();
	
	if(empty($name)){
		$errors[] = _CM_TOPIC_TITLE_NG;
	}
	if(empty($body)){
		$errors[] = _CM_TOPIC_BODY_NG;
	}
	
	$topic_handler =& CM_TopicHandler::getInstance();
	$new_topic =& $topic_handler->create();
	$new_topic->setVar('name', $name);
	
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	$new_comment =& $comment_handler->create();
	$new_comment->setVar('body', $body);
	
	$commu_info = array('id' => $cid, 'name' => $community->getVar('name'));
	$context->setAttributes('commu', $commu_info);
	
	$_SESSION['topic_name'] = $name;
	$_SESSION['topic_body'] = $body;
	
	// ϥ顼
	if(count($errors) > 0){
		$default = array(
			'name' => $new_topic->getVar('name', 'f'),
			'body' => $new_comment->getVar('body', 'f'),
		);
		$context->setAttributes('default', $default);
		$context->setAttributes('errors', $errors);
		return "add";	//  topic/addView.php
	}
	
	$image_handler =& CM_ImageHandler::getInstance();
	$file_handler =& CM_FileHandler::getInstance();
	
	$topic = array(
		'name' => $new_topic->getVar('name', 'p'),
		'body' => $new_comment->getVar('body', 'p'),
		'images' => $image_handler->uploadImageTemp('images'),
		'files' => $file_handler->uploadFileTemp('files'),
	);
	$context->setAttributes('topic', $topic);
}
//------------------------------------------------------------------------------

}
?>
