<?php

require_once 'root.class.php';

//******************************************************************************

class CM_ModuleConfig extends CM_Root
{
	
	//--------------------------------------------------------------------------
	
	function CM_ModuleConfig()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('uid', XOBJ_DTYPE_INT);
		$this->initVar('config', XOBJ_DTYPE_ARRAY);
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

class CM_ModuleConfigHandler extends CM_RootHandler
{
	
	//--------------------------------------------------------------------------
	
	function CM_ModuleConfigHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_ModuleConfig";
		$this->table_name = "c_mypage_module_config";
		$this->primary_key = "uid";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_ModuleConfigHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &getList($uid, $view_mode=true)
	{
		global $xoopsUser;
		
		$ret = array();
		
		$ts =& CM_TextSanitizer::getInstance();
		$gperm_handler =& xoops_gethandler('groupperm');
		$module_handler =& xoops_gethandler('module');
		$groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
		
		// ⥸塼ɽμ
		$module_config =& $this->get($uid);
		if(is_object($module_config)){
			$config_arr = $module_config->getVar('config');
			if(!is_array($config_arr)){
				$config_arr = array();
			}
		}
		else{
			$config_arr = array();
		}
		
		$default_image = XOOPS_URL.'/images/icons/posticon2.gif';
		
		$order_max = 1;
		
		$criteria = new CriteriaCompo(new Criteria('hassearch', 1));
		$criteria->add(new Criteria('isactive', 1));
		$mids =& array_keys($module_handler->getList($criteria));
		$checked = array();
		
		// DBϿƤǥ⥸塼ɽ
		foreach($config_arr as $mid => $config){
			$checked[$mid] = true;
			if(!isset($config['order']) || !isset($config['view'])){
				continue;
			}
			if($view_mode && ($config['view']<1)){
				continue;
			}
			$module =& $module_handler->get($mid);
			if(!$module || !in_array($mid, $mids) || !$gperm_handler->checkRight('module_read', $mid, $groups)){
				continue;
			}
			
			$module_dir = $module->getVar('dirname');
			$module_url = XOOPS_URL.'/modules/'.$module_dir.'/';
			$results =& $module->search('', '', $config['view'], 0, $uid);
			$count = is_array($results)? count($results) : 0;
			
			if(($view_mode && $count>0) || !$view_mode){
				for ($i = 0; $i < $count; $i++) {
					if (isset($results[$i]['image']) && $results[$i]['image'] != '') {
						$results[$i]['image'] = $module_url. $results[$i]['image'];
					}
					else {
						$results[$i]['image'] = $default_image;
					}
					$results[$i]['link'] = $module_url. $results[$i]['link'];
					$results[$i]['title'] = $ts->makeTboxData4Show($results[$i]['title']);
					$results[$i]['time'] = $results[$i]['time'] ? date("Y-m-d H:i:s", $results[$i]['time']) : '';
				}
				$ret[$mid] = array(
					'id' => $mid,
					'order' => $config['order'],
					'view' => $config['view'],
					'name' => $module->getVar('name'),
					'url' => $module_url,
					'results' => $results,
				);
				$order_max = $config['order'];
			}
			unset($module, $results);
		}
		
		// DB̤ϿΥ⥸塼ɲɽ
		foreach($mids as $mid) {
			if(isset($checked[$mid]) || !$gperm_handler->checkRight('module_read', $mid, $groups)) {
				continue;
			}
			
			$module =& $module_handler->get($mid);
			if(!$module){
				continue;
			}
			
			$module_dir = $module->getVar('dirname');
			$module_url = XOOPS_URL.'/modules/'.$module_dir.'/';
			
			$results =& $module->search('', '', 5, 0, $uid);
			$count = is_array($results)? count($results) : 0;
			
			if(($view_mode && $count > 0) || !$view_mode){
				for ($i = 0; $i < $count; $i++) {
					if (isset($results[$i]['image']) && $results[$i]['image'] != '') {
						$results[$i]['image'] = $module_url. $results[$i]['image'];
					}
					else {
						$results[$i]['image'] = $default_image;
					}
					$results[$i]['link'] = $module_url. $results[$i]['link'];
					$results[$i]['title'] = $ts->makeTboxData4Show($results[$i]['title']);
					$results[$i]['time'] = $results[$i]['time'] ? date("Y-m-d H:i:s", $results[$i]['time']) : '';
				}
				$ret[$mid] = array(
					'id' => $mid,
					'order' => $order_max,
					'view' => 5,
					'name' => $module->getVar('name'),
					'url' => $module_url,
					'results' => $results,
				);
			}
			unset($module, $results);
		}
		return $ret;
	}
	
}

//******************************************************************************

?>
