<?php
/*
Plugin Name: Kougaburari
Version: 0.3.0
Plugin URI: http://wppluginsj.sourceforge.jp/kougaburari/
Description: Slide Show
Author: wokamoto
Author URI: http://dogmap.jp/
Text Domain: kougaburari
Domain Path: /languages/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2010 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Includes:
 jQuery 1.3.2 - New Wave Javascript
  Copyright (c) 2009 John Resig (jquery.com)
  Dual licensed under the MIT and GPL licenses.

 jQuery Cycle Plugin (with Transition Definitions)
  Copyright (c) 2007-2009 M. Alsup
  Version: 2.74 (03-FEB-2010)
  Dual licensed under the MIT and GPL licenses:
  Examples and documentation at: http://jquery.malsup.com/cycle/
*/

if (!class_exists('wokController') || !class_exists('wokScriptManager'))
	require(dirname(__FILE__).'/includes/common-controller.php');

define('KOUGABURARI_SHORTCODE', 'kougaburari');
define('KOUGABURARI_ELEMENT',   'slideshow');
define('KOUGABURARI_WIDTH',     160);
define('KOUGABURARI_HEIGHT',    120);
define('KOUGABURARI_COUNT',     10);
define('KOUGABURARI_FX',        'fade');
define('KOUGABURARI_TIMEOUT',   4000);
define('KOUGABURARI_SPEED',     1000);
define('KOUGABURARI_EXPIRED',   3000);            // Request cache expired (seconds)

class KougaburariController extends wokController {
	var $plugin_name = 'Kougaburari';
	var $plugin_ver  = '0.3.0';

	var $cycle_js    = 'js/jquery.cycle.all.min.js';
	var $cycle_ver   = '2.74';

	var $options_default = array(
		'title'   => 'Slide Show' ,
		'element' => KOUGABURARI_ELEMENT ,
		'width'   => KOUGABURARI_WIDTH ,
		'height'  => KOUGABURARI_HEIGHT ,
		'count'   => KOUGABURARI_COUNT ,
		'fx'      => KOUGABURARI_FX ,
		'timeout' => KOUGABURARI_TIMEOUT ,
		'speed'   => KOUGABURARI_SPEED ,
		'id'      => 0 ,
		);

	var $efects = array(
		'blindX',
		'blindY',
		'blindZ',
		'cover',
		'curtainX',
		'curtainY',
		'fade',
		'fadeZoom',
		'growX',
		'growY',
		'none',
		'scrollUp',
		'scrollDown',
		'scrollLeft',
		'scrollRight',
		'scrollHorz',
		'scrollVert',
		'shuffle',
		'slideX',
		'slideY',
		'toss',
		'turnUp',
		'turnDown',
		'turnLeft',
		'turnRight',
		'uncover',
		'wipe',
		'zoom',
		'all',
	);

	var $foot_js = '';

	/*
	* Constructor
	*/
	function KougaburariController() {
		$this->__construct();
	}
	function __construct() {
		$this->init(__FILE__);

		$this->options_default['title'] = __("Slide Show", $this->textdomain_name);
		$this->options = $this->initOptions($this->getOptions());
	}

	// plugin activation
	function activation(){
	}

	// plugin deactivation
	function deactivation(){
		delete_option($this->plugin_name . ' Cache');
	}

	/*
	* Init Options
	*/
	function initOptions($options = '') {
		if (!is_array($options))
			$options = array();

		foreach ($this->options_default as $key => $val) {
			if ( isset($options[$key]) ) {
				switch ($key){
				case 'width':
				case 'height':
				case 'count':
				case 'timeout':
				case 'speed':
					$options[$key] = intval($options[$key]);
					$options[$key] = ( $options[$key] > 0 ? $options[$key] : $val );
					break;
				case 'id':
					$options[$key] = intval($options[$key]);
					break;
				case 'fx':
					$options[$key] = ( $this->chkEfect($options[$key]) ? $options[$key] : $val );
					break;
				case 'title':
				case 'element':
				default:
					break;
				}
			} else {
				$options[$key] = $val;
			}
		}

		return $options;
	}

	/**
	* widget init
	*/
	function widgetInit() {
		global $wp_version;

		if ( version_compare($wp_version, "2.8", ">=") ) {
			register_widget('Kougaburari_Widget');
		} else {
			wp_register_sidebar_widget(
				$this->plugin_name ,
				__("Slide Show", $this->textdomain_name) ,
				array(&$this, 'widgetOutput') ,
				array(
					'classname' => 'widget_' . $this->plugin_name ,
					'description' => __("Slide Show", $this->textdomain_name) ,
				)
			);
			wp_register_widget_control(
				$this->plugin_name ,
				$this->plugin_name ,
				array(&$this, 'widgetRegister')
			);
		}
	}

	function getScript( $options ) {
		$json_script = $this->plugin_url . $this->plugin_file;

		$js_out  = "jQuery(function(){";
		$js_out .= "if(jQuery('#{$options['element']}-{$options['id']}').length>0){";
		$js_out .= "jQuery('#{$options['element']}-{$options['id']}')";
		$js_out .= ".cycle({fx:'{$options['fx']}',speed:{$options['speed']},timeout:{$options['timeout']},pause:1,";
		$js_out .= "before:function(){jQuery('#{$options['element']}-caption-{$options['id']}').html(jQuery('img',jQuery(this)).attr('title'));}";
		$js_out .= "});";
		$js_out .= "if(jQuery('#{$options['element']}-caption-{$options['id']}').length==0){";
		$js_out .= "jQuery('#{$options['element']}-{$options['id']}').after('<div id=\"{$options['element']}-caption-{$options['id']}\" class=\"{$options['element']}-caption\"></div>');";
		$js_out .= "}";
		$js_out .= "jQuery('#{$options['element']}-caption-{$options['id']}').html(jQuery('#{$options['element']}-{$options['id']} img')[0].title);";
		$js_out .= "}";
		$js_out .= "});\n";

		return($js_out);
	}

	function getSlideShow( $options ){
		// add JavaScript
		$options = $this->initOptions( $options );
		$img_tag = $this->getImages( $options );
		$this->foot_js .= $this->getScript( $options );

		$out  = "<div id=\"{$options['element']}-{$options['id']}\" class=\"{$options['element']}\" style=\"width:{$options['width']};height:{$options['height']};\">$img_tag</div>\n";
		$out .= "<div id=\"{$options['element']}-caption-{$options['id']}\" class=\"{$options['element']}-caption\"></div>\n";

		return $out;
	}

	/*
	* Script loader
	*/
	function addScripts() {
		if ( function_exists('kougabu_get_images') ) {
			$this->addjQuery();    // regist jQuery
			wp_enqueue_script('jquery.cycle', $this->plugin_url.$this->cycle_js, array('jquery'), $this->cycle_ver);

			// set style sheet & JavaScript
			add_action('wp_head', array(&$this, 'addHead'));
		}
	}

	/*
	* style sheet & JavaScript (Head)
	*/
	function addHead() {
		$css_out = "\n";
		$css_out .= '<style type="text/css" media="all"> /*<![CDATA[ */'."\n";
		$css_out .= ".{$this->options['element']} { overflow: hidden; cursor: pointer; }\n";
		$css_out .= ".{$this->options['element']}-box { margin: 0 auto; }\n";
		$css_out .= ".{$this->options['element']} img { margin: 0 auto; padding: 0; border: none; cursor: pointer; }\n";
		$css_out .= '/* ]]>*/ </style>'."\n";
		echo $css_out;

		// set footer JavaScript
		add_action('wp_footer',array(&$this,'addFooter'));
	}

	/*
	* JavaScript (footer)
	*/
	function addFooter() {
		if ( !empty($this->foot_js) )
			$this->writeScript($this->foot_js, 'footer');
	}

	/*
	* Wordpress 2.5 - New shortcode API
	*/
	function shortcodeHandler($atts, $content = '') {
		extract( shortcode_atts( array(
			'width'  => $this->options_default['width'] ,
			'height' => $this->options_default['height'] ,
			'count'  => $this->options_default['count'] ,
			'fx'     => $this->options_default['fx'] ,
			'timeout'=> $this->options_default['timeout'] ,
			'speed'  => $this->options_default['speed'] ,
			), $atts
		));

		return $this->getSlideShow(array(
			'id'      => $this->options['id']++ ,
			'width'   => $width ,
			'height'  => $height ,
			'count'   => $count ,
			'fx'      => $fx ,
			'timeout' => $timeout ,
			'speed'   => $speed ,
		));
	}

	/*
	* Efect check
	*/
	function chkEfect($fx) {
		return ( array_search( $fx, $this->efects, true ) !== FALSE );
	}

	/**
	* widgetRegister
	*
	*/
	function widgetRegister() {
		$newoptions = $this->getOptions();
		if (isset($_POST["kougaburari-submit"])) {
			$newoptions = $this->initOptions(array(
				'element' => $this->options['element'] ,
				'title'   => $_POST["kougaburari-title"] ,
				'width'   => (int) $_POST["kougaburari-width"] ,
				'height'  => (int) $_POST["kougaburari-height"] ,
				'count'   => (int) $_POST["kougaburari-count"] ,
				'fx'      => $_POST["kougaburari-fx"] ,
				'timeout' => (int) $_POST["kougaburari-timeout"] ,
				'speed'   => (int) $_POST["kougaburari-speed"] ,
				'id'      => $this->options['id'] ,
			));
			if ( $this->options != $newoptions ) {
				$this->options = $newoptions;
				$this->updateOptions();
			}
		}

		$this->widgetSettingOutput( array(
			'title' => array(
				'id'=>'kougaburari-title',
				'name'=>'kougaburari-title',
				'val'=>attribute_escape($this->options['title']),
			) ,
			'width' => array(
				'id'=>'kougaburari-width',
				'name'=>'kougaburari-width',
				'val'=>attribute_escape($this->options['width']),
			) ,
			'height' => array(
				'id'=>'kougaburari-height',
				'name'=>'kougaburari-height',
				'val'=>attribute_escape($this->options['height']),
			) ,
			'count' => array(
				'id'=>'kougaburari-count',
				'name'=>'kougaburari-count',
				'val'=>attribute_escape($this->options['count']),
			) ,
			'fx' => array(
				'id'=>'kougaburari-fx',
				'name'=>'kougaburari-fx',
				'val'=>$this->options['fx'],
			) ,
			'timeout' => array(
				'id'=>'kougaburari-timeout',
				'name'=>'kougaburari-timeout',
				'val'=>attribute_escape($this->options['timeout']),
			) ,
			'speed' => array(
				'id'=>'kougaburari-speed',
				'name'=>'kougaburari-speed',
				'val'=>attribute_escape($this->options['speed']),
			) ,
		));

		echo '<input type="hidden" id="kougaburari-submit" name="kougaburari-submit" value="1" />';
	}

	function widgetSettingOutput($args) {
		extract($args, EXTR_SKIP);

		echo '<p>';
		echo "<label for=\"{$title['name']}\">" . __('Title:');
		echo "<input class=\"widefat\" id=\"{$title['id']}\" name=\"{$title['name']}\" type=\"text\" value=\"{$title['val']}\" />";
		echo '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"{$width['id']}\" name=\"{$width['name']}\" type=\"text\" style=\"width: 3em;\" value=\"{$width['val']}\" />";
		echo "<label for=\"{$width['name']}\"> : " . __('Width', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"{$height['id']}\" name=\"{$height['name']}\" type=\"text\" style=\"width: 3em;\" value=\"{$height['val']}\" />";
		echo "<label for=\"{$height['name']}\"> : " . __('Height', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"{$count['id']}\" name=\"{$count['name']}\" type=\"text\" style=\"width: 3em;\" value=\"{$count['val']}\" />";
		echo "<label for=\"{$count['name']}\"> : " . __('Count', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<select id=\"{$fx['id']}\" name=\"{$fx['name']}\">";
		foreach ( $this->efects as $efect ) {
			echo "<option value=\"$efect\"".($efect == $fx['val'] ? ' selected="selected"' : '').">$efect</option>";
		}
		echo '</select>';
		echo "<label for=\"{$fx['name']}\"> : " . __('Effect', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"{$timeout['id']}\" name=\"{$timeout['name']}\" type=\"text\" style=\"width: 3em;\" value=\"{$timeout['val']}\" />";
		echo "<label for=\"{$timeout['name']}\"> : " . __('Timeout(Millisecond)', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"{$speed['id']}\" name=\"{$speed['name']}\" type=\"text\" style=\"width: 3em;\" value=\"{$speed['val']}\" />";
		echo "<label for=\"{$speed['name']}\"> : " . __('Speed(Millisecond)', $this->textdomain_name) . '</label>';
		echo '</p>' . "\n";
	}

	/**
	* outputWidget
	*
	* @param unknown_type $args
	*/
	function widgetOutput($args, $instance = '') {
		extract($args, EXTR_SKIP);

		if ( !is_array($instance) )
			$instance = $this->options;

		$title = $instance['title'];
		if($title == '')
			$title = __("Slide Show", $this->textdomain_name); 

		$instance['id'] = $this->options['id']++;

		echo $before_widget . "\n";
		echo $before_title . $title . $after_title . "\n";
		echo $this->getSlideShow( $instance );
		echo $after_widget . "\n";
	}

	/**
	* getKougabu
	*/
	function getKougabu($count, $width, $height, $id = '') {
		global $wpKougabu;

		if ( empty($id) )
			$id = md5($count . $width . $height);

		// cache
		$option_name = $this->plugin_name . ' Cache';
		$cache = (array) get_option($option_name);
		if ( isset($cache[$id]) && $cache[$id]['expired'] > time() ) {
			$kougabu_images = maybe_unserialize($cache[$id]['kougabu_images']);
			return $kougabu_images;
		}

		$kougabu_images = ( function_exists('kougabu_get_images')
			? kougabu_get_images(array(
				'max_width'=>$width,
				'max_height'=>$height,
				'count'=>$count,
				'before'=>'',
				'after'=>'',
				'echo'=>false,
				'array'=>true,
				'array_ext'=>true,
			))
			: array()
		);

		if ( count($kougabu_images) > 0 ) {
			foreach ( $kougabu_images as $key => $info ) {
				$href = $src = $width = $height = $alt = $title = null;
				$href   = esc_attr($info[0]['href']);
				$src    = esc_attr($info[0]['src']);
				$width  = (int) $info[0]['width'];
				$height = (int) $info[0]['height'];
				$alt    = esc_attr($info[0]['alt']);
				$title  = esc_html($info[0]['title']);
				$kougabu_images[$key][] = array(
					'href'   => $href ,
					'src'    => $src ,
					'width'  => (int) (!is_null($width)  ? $width  : KOUGABURARI_WIDTH  ) ,
					'height' => (int) (!is_null($height) ? $height : KOUGABURARI_HEIGHT ) ,
					'alt'    => $alt ,
					'title'  => $title,
				);
			}
		}
		$cache[$id] = array(
			'expired' => time() + KOUGABURARI_EXPIRED ,
			'kougabu_images' => maybe_serialize($kougabu_images) ,
		);
		update_option($option_name, $cache);

		return $kougabu_images;
	}

	/**
	* getImages
	*/
	function getImages( $options ){
		$options = $this->initOptions( $options );
		$id      = md5( $options['count'] .$options['width'] . $options['height'] . $options['id'] );
		$kougabu_images = $this-> getKougabu( $options['count'], $options['width'], $options['height'], $id );
		$img_tag = '';
		if ( count($kougabu_images) > 0 ) {
			foreach ( $kougabu_images as $key => $image ) {
				if ( isset($image[1]) && preg_match('/^s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]+$/i', $image[1]['src']) ) {
					$img_tag .= '<div';
					$img_tag .= " class=\"{$options['element']}-box\"";
					$img_tag .= ' style="display:none;" ';
					$img_tag .= '>';
					$img_tag .= '<a';
					$img_tag .= ' href="' . addslashes($image[1]['href']) . '"';
					$img_tag .= '>';
					$img_tag .= '<img';
					$img_tag .= ' src="' . addslashes($image[1]['src']) . '"';
					$img_tag .= ' width="' . (int) $image[1]['width'] . '"';
					$img_tag .= ' height="' . (int) $image[1]['height'] . '"';
					$img_tag .= ' alt="' . addslashes($image[1]['alt']) . '"';
					$img_tag .= ' title="' . addslashes($image[1]['title']) . '"';
					$img_tag .= '/>';
					$img_tag .= '</a>';
					$img_tag .= '</div>';
				}
			}
		}
		return $img_tag;
	}

	/**
	* getJSON
	*/
	function getJSON() {
		$id     = (int) (isset($_GET['json']) && is_numeric($_GET['json']) ? $_GET['json'] : 0 );
		$count  = (int) (isset($_GET['c']) && is_numeric($_GET['c']) ? $_GET['c'] : KOUGABURARI_COUNT );
		$width  = (int) (isset($_GET['w']) && is_numeric($_GET['w']) ? $_GET['w'] : KOUGABURARI_WIDTH );
		$height = (int) (isset($_GET['h']) && is_numeric($_GET['h']) ? $_GET['h'] : KOUGABURARI_HEIGHT );
		$callback = wp_specialchars(attribute_escape(isset($_GET['callback']) ? $_GET['callback'] : ''));
		$charset = get_bloginfo('charset');

		$id     = md5($id . $count . $width . $height . $callback);

		$kougabu_images = $this-> getKougabu($count, $width, $height, $id);
		if ( count($kougabu_images) > 0 ) {
			$out = '';
		foreach ( $kougabu_images as $key => $image ) {
			if ( isset($image[1]) ) {
				$out .= ( !empty($out) ? ",\n" : '');
				$out .= '{';
				$out .= 'id:"' . $key . '",';
				$out .= 'href:"' . addslashes($image[1]['href']) . '",';
				$out .= 'src:"' . addslashes($image[1]['src']) . '",';
				$out .= 'width:"' . $image[1]['width'] . '",';
				$out .= 'height:"' . $image[1]['height'] . '",';
				$out .= 'alt:"' . addslashes($image[1]['alt']) . '",';
				$out .= 'title:"' . addslashes($image[1]['title']) . '"';
				$out .= '}';
			}
		}

		nocache_headers();
		if ( !empty($callback) ) {
			header("Content-Type: text/javascript; charset=$charset");
			echo "$callback([\n$out\n]);";
		} else {
			header("Content-Type: application/json; charset=$charset");
			echo "[\n$out\n]";
		}
		die();

		} else {
			header("HTTP/1.0 404 Not Found");
			wp_die("404 Not Found");
		}
	}
}

global $wp_version, $kougaburari;

if (version_compare($wp_version, "2.8", ">=")) {

class Kougaburari_Widget extends WP_Widget {
	/*
	* Constructor
	*/
	function Kougaburari_Widget() {
		global $kougaburari;

		if (!isset($kougaburari))
			$kougaburari = new KougaburariController;

		$widget_ops = array(
			'classname' => 'widget_' . strtolower($kougaburari->plugin_name) ,
			'description' =>  __("Slide Show", $kougaburari->textdomain_name) ,
		);
		$this->WP_Widget(
			$kougaburari->plugin_name ,
			__("Slide Show", $kougaburari->textdomain_name) ,
			$widget_ops
		);
	}

	function widget($args, $instance) {
		global $kougaburari;

		$kougaburari->widgetOutput($args, $instance);
	}

	function update($new_instance, $old_instance) {
		global $kougaburari;

		$instance = $old_instance;
		$new_instance = wp_parse_args(
			(array) $new_instance ,
			$kougaburari->options_default
		);
		$instance = $kougaburari->initOptions($new_instance);

		return $instance;
	}

	function form($instance) {
		global $kougaburari;

		$instance = wp_parse_args(
			(array) $instance ,
			$kougaburari->options_default
		);

		$kougaburari->widgetSettingOutput( array(
			'title' => array(
				'id'=>$this->get_field_id('title'),
				'name'=>$this->get_field_name('title'),
				'val'=>attribute_escape($instance['title']),
			) ,
			'width' => array(
				'id'=>$this->get_field_id('width'),
				'name'=>$this->get_field_name('width'),
				'val'=>attribute_escape($instance['width']),
			) ,
			'height' => array(
				'id'=>$this->get_field_id('height'),
				'name'=>$this->get_field_name('height'),
				'val'=>attribute_escape($instance['height']),
			) ,
			'count' => array(
				'id'=>$this->get_field_id('count'),
				'name'=>$this->get_field_name('count'),
				'val'=>attribute_escape($instance['count']),
			) ,
			'fx' => array(
				'id'=>$this->get_field_id('fx'),
				'name'=>$this->get_field_name('fx'),
				'val'=>attribute_escape($instance['fx']),
			) ,
			'timeout' => array(
				'id'=>$this->get_field_id('timeout'),
				'name'=>$this->get_field_name('timeout'),
				'val'=>attribute_escape($instance['timeout']),
			) ,
			'speed' => array(
				'id'=>$this->get_field_id('speed'),
				'name'=>$this->get_field_name('speed'),
				'val'=>attribute_escape($instance['speed']),
			) ,
		));

	}
}

}

function kougaburari($width = KOUGABURARI_WIDTH, $height = KOUGABURARI_HEIGHT, $count = KOUGABURARI_COUNT, $fx = KOUGABURARI_FX, $timeout = KOUGABURARI_TIMEOUT, $speed = KOUGABURARI_SPEED, $echo = true) {
	global $kougaburari;

	$slide_show = $kougaburari->getSlideShow(array(
		'width'   => (int) $width ,
		'height'  => (int) $height ,
		'count'   => (int) $count ,
		'fx'      => $fx ,
		'timeout' => (int) $timeout ,
		'speed'   => (int) $speed ,
		'id'      => $kougaburari->options['id']++ ,
	));

	if ($echo)
		echo $slide_show;
	else
		return $slide_show;
}

// Go! Go! Go!
$kougaburari = new KougaburariController;

if ( function_exists('register_activation_hook') )
	register_activation_hook(__FILE__, array(&$kougaburari, 'activation'));
if ( function_exists('register_deactivation_hook') )
	register_deactivation_hook(__FILE__, array(&$kougaburari, 'deactivation'));

// widget init ( register sidebar widget )
add_action( version_compare($wp_version, "2.8", ">=") ? 'widgets_init' : 'init',  array(&$kougaburari, 'widgetInit') );

// script loader
add_action('wp_print_scripts', array(&$kougaburari,'addScripts'));

// shortcode handler
add_shortcode(KOUGABURARI_SHORTCODE, array(&$kougaburari,'shortcodeHandler'));
?>
