// イベント設定
function observeEvent(element, name, observer) {
	if (element.addEventListener) {
		element.addEventListener(name, observer, false);
	} else if (element.attachEvent) {
		element.attachEvent("on" + name, observer);
	}
}
// 地図読み込み
function mapload() {
// 地図作成
	mapMake();
// 地図緯度経度表示
	mapDspPos();
// カテゴリー復元
	insertyahoomap_default_category_load("",insertyahoomap_default_category);
}
// 地図作成
function mapMake() {
	ymap = new YahooMapsCtrl("map",insertyahoomap_map_pos,insertyahoomap_map_layer);
	ymap.setVisibleCentermarkButton(true);
	ymap.addEvent(YEventType.MAP_CLICK,mapClick);
	ymap.addEvent(YEventType.MAP_MOVING,mapDspPos);
	ymap.addEvent(YEventType.MAP_MOVED,mapDspPos);
}
// 選択枠処理
function mapSelectBox(style) {
	if (insertyahoomap_select_map_width < jQuery("#i_map_width").val()) {
		jQuery("#i_map_width").val(insertyahoomap_select_map_width);
	}
	if (insertyahoomap_select_map_height < jQuery("#i_map_height").val()) {
		jQuery("#i_map_height").val(insertyahoomap_select_map_height);
	}
	insertyahoomapselectdiv_left = jQuery("#insertyahoomapdiv").attr("offsetLeft") + jQuery("#map").attr("offsetLeft")
		+ Math.floor((insertyahoomap_select_map_width - jQuery("#i_map_width").val()) / 2);
	insertyahoomapselectdiv_top = jQuery("#insertyahoomapdiv").attr("offsetTop") + jQuery("#map").attr("offsetTop")
		+ Math.floor((insertyahoomap_select_map_height - jQuery("#i_map_height").val()) / 2);
	jQuery("#insertyahoomapselectdiv").css("left", insertyahoomapselectdiv_left);
	jQuery("#insertyahoomapselectdiv").css("top", insertyahoomapselectdiv_top);
	jQuery("#insertyahoomapselectdiv").css("width", jQuery("#i_map_width").val() + "px");
	jQuery("#insertyahoomapselectdiv").css("height", jQuery("#i_map_height").val() + "px");
	if (style) {
		jQuery("#insertyahoomapselectdiv").css("border-style", style);
		if (style == "none") {
			jQuery("#insertyahoomapselectdiv").css("display", "none");
		} else {
			jQuery("#insertyahoomapselectdiv").css("display", "block");
		}
	}
}
// 地図緯度経度表示
function mapDspPos() {
	jQuery("#i_map_dsp_lat").val(ymap.getCenter().lat);
	jQuery("#i_map_dsp_lon").val(ymap.getCenter().lon);
}
// 地図表示緯度経度取得
function mapGetPos(id,pos) {
	if (id == 'i_map_pos') {
		jQuery("#i_map_pos_lat").val(pos.lat);
		jQuery("#i_map_pos_lon").val(pos.lon);
	}
	if (id == 'i_map_home') {
		jQuery("#i_map_home_lat").val(pos.lat);
		jQuery("#i_map_home_lon").val(pos.lon);
	}
	if (id.match(/^insertyahoomapiconpos/)) {
		if (!document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconenable")).checked) {
			jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlat")).val(pos.lat);
			jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlon")).val(pos.lon);
		}
	}
}
// 地図クリック
function mapClick(pos) {
	if (document.activeElement.id == 'i_map_pos_lat'
	||  document.activeElement.id == 'i_map_pos_lon') {
		mapGetPos('i_map_pos',pos);
	}
	if (document.activeElement.id == 'i_map_home_lat'
	||  document.activeElement.id == 'i_map_home_lon') {
		mapGetPos('i_map_home',pos);
	}
	if (document.activeElement.id.match(/^insertyahoomapiconposlat/)) {
		mapGetPos(document.activeElement.id.replace("insertyahoomapiconposlat","insertyahoomapiconpos"),pos);
	}
	if (document.activeElement.id.match(/^insertyahoomapiconposlon/)) {
		mapGetPos(document.activeElement.id.replace("insertyahoomapiconposlon","insertyahoomapiconpos"),pos);
	}
}
// 地図表示位置変更
function mapSetPos(id) {
	if (id == 'i_map_pos') {
		if (jQuery("#i_map_pos_lat").val()
		&&  jQuery("#i_map_pos_lon").val()) {
			ymap.moveTo(new YLLPoint(jQuery("#i_map_pos_lat").val(),jQuery("#i_map_pos_lon").val()));
		}
	}
	if (id == 'i_map_home') {
		if (jQuery("#i_map_home_lat").val()
		&&  jQuery("#i_map_home_lon").val()) {
			ymap.moveTo(new YLLPoint(jQuery("#i_map_home_lat").val(),jQuery("#i_map_home_lon").val()));
		}
	}
	if (id.match(/^insertyahoomapiconpos/)) {
		if (jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlat")).val()
		&&  jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlon")).val()) {
			ymap.moveTo(new YLLPoint(jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlat")).val(),jQuery("#" + id.replace("insertyahoomapiconpos","insertyahoomapiconposlon")).val()));
		}
	}
}
// 地図縮尺変更
function mapChangeSliderbar() {
	if (jQuery("#i_map_sliderbar").val() == "スライダーバー") {
		jQuery("#i_map_sliderbar").val("縮尺切り替えボタン");
		ymap.setVisibleSliderbar(false);
	} else {
		jQuery("#i_map_sliderbar").val("スライダーバー");
		ymap.setVisibleSliderbar(true);
	}
}
// 地図中心点表示ボタン変更
function mapChangeCentermarkButton() {
	if (jQuery("#i_map_centermarkbutton").val() == "表示ボタン有り") {
		jQuery("#i_map_centermarkbutton").val("表示ボタン無し");
		ymap.setVisibleCentermarkButton(false);
	} else {
		jQuery("#i_map_centermarkbutton").val("表示ボタン有り");
		ymap.setVisibleCentermarkButton(true);
	}
}
// 地図挿入
function insertyahoomap_insert(inserttarget) {
	var insertyahoomapparam  = '';
// 地図横幅
	if (jQuery("#i_map_width").val()) {
		if (isnumber(jQuery("#i_map_width").val())) {
			insertyahoomapparam += ' width="' + jQuery("#i_map_width").val() + 'px' + '"';
		} else {
			alert('地図横幅が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' width="400px"';
	}
// 地図高幅
	if (jQuery("#i_map_height").val()) {
		if (isnumber(jQuery("#i_map_height").val())) {
			insertyahoomapparam += ' height="' + jQuery("#i_map_height").val() + 'px' + '"';
		} else {
			alert('地図縦幅が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' height="300px"';
	}
// ホーム緯度
	if (jQuery("#i_map_home_lat").val()) {
		if (isnumeric(jQuery("#i_map_home_lat").val())) {
			insertyahoomapparam += ' home_lat="' + jQuery("#i_map_home_lat").val() + '"';
		} else {
			alert('初期緯度が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' home_lat="35.67832667"';
	}
// ホーム経度
	if (jQuery("#i_map_home_lon").val()) {
		if (isnumeric(jQuery("#i_map_home_lon").val())) {
			insertyahoomapparam += ' home_lon="' + jQuery("#i_map_home_lon").val() + '"';
		} else {
			alert('初期経度が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' home_lon="139.77044378"';
	}
// 初期表示位置
	if (jQuery("#i_map_pos_lat").val()
	&&  jQuery("#i_map_pos_lon").val()) {
// 初期表示位置緯度
		if (isnumeric(jQuery("#i_map_pos_lat").val())) {
			insertyahoomapparam += ' pos_lat="' + jQuery("#i_map_pos_lat").val() + '"';
		} else {
			alert('表示緯度が正しくありません。');
			return;
		}
// 初期表示位置経度
		if (isnumeric(jQuery("#i_map_pos_lon").val())) {
			insertyahoomapparam += ' pos_lon="' + jQuery("#i_map_pos_lon").val() + '"';
		} else {
			alert('表示経度が正しくありません。');
			return;
		}
	}
// 中心点
	insertyahoomapparam += ' centermark="' + ymap.getVisibleCentermark() + '"';
// 尺度
	insertyahoomapparam += ' currentlayer="' + ymap.getCurrentLayer() + '"';
// 地図種類
	insertyahoomapparam += ' currentmode="' + ymap.getCurrentMode() + '"';
// スライダーバー
	if (jQuery("#i_map_sliderbar").val() == "スライダーバー") {
		insertyahoomapparam += ' sliderbar="true"';
	} else {
		insertyahoomapparam += ' sliderbar="false"';
	}
// 中心点表示ボタン
	if (jQuery("#i_map_centermarkbutton").val() == "表示ボタン有り") {
		insertyahoomapparam += ' centermarkbutton="true"';
	} else {
		insertyahoomapparam += ' centermarkbutton="false"';
	}
// カテゴリー
	var eleCategorys = jQuery("input[id^='insertyahoomapcategoryid']").get();
	for (var i = 0; i < eleCategorys.length; i++) {
		if (document.getElementById(eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked) {
// カテゴリＩＤ
			insertyahoomapparam += ' ' + eleCategorys[i].id + '="' + escape(eleCategorys[i].value) + '"';
// カテゴリ画像
			var idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryimg");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(jQuery("#" + idvalue).val()) + '"';
// 画像スタイル幅
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamwidth");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
// 画像スタイル高さ
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamheight");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
// 画像スタイル基準横
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdx");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
// 画像スタイル基準縦
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdy");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
		}
	}
// アイコン
	var eleIcons = jQuery("input[id^='insertyahoomapiconid']").get();
	for (var i = 0; i < eleIcons.length; i++) {
		if (document.getElementById(eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked) {
// アイコンＩＤ
			insertyahoomapparam += ' ' + eleIcons[i].id + '="' + escape(eleIcons[i].value) + '"';
// 緯度
			var idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconposlat");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
// 経度
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconposlon");
			insertyahoomapparam += ' ' + idvalue + '="' + jQuery("#" + idvalue).val() + '"';
// カテゴリＩＤ
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapicontype");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(jQuery("#" + idvalue).val()) + '"';
// 吹き出し
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconpopup");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(jQuery("#" + idvalue).val()) + '"';
// ラベル
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconlabel");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(jQuery("#" + idvalue).val()) + '"';
		}
	}
	var insertyahoomap  = '[insertyahoomap';
	var win = window.dialogArguments || opener || parent || top;
	if (inserttarget == 'custom') {
		var id = Math.floor(Math.random()*10000000000);
		var meta_key = 'insertyahoomap' + id;
		win.send_meta_value(meta_key, insertyahoomapparam);
		insertyahoomap += ' id="' + id + '"';
	} else {
		insertyahoomap += insertyahoomapparam;
	}
	insertyahoomap += ']';
	win.send_to_editor(insertyahoomap);
}
// カテゴリー追加
function insertyahoomap_category_insert(calltype) {
	var i = 1;
	while (document.getElementById("insertyahoomapcategory" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomapcategory");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomapcategory" + i;
	if (calltype != 'options') {
		var eleCell = eleRow.insertCell(-1);
		eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapcategoryenable' + i + '"/>';
		jQuery(function () {
			jQuery("#insertyahoomapcategoryenable" + i).click(function(event){
				insertyahoomap_category_enable_change(event.target);
			});
		});
	}
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryid' + i + '" value="category' + i + '"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryimg' + i + '" value=""/>';
	jQuery(function () {
		jQuery("#insertyahoomapcategoryimg" + i).change(function(event){
			var link = new Array();
			link['imageurl'] = jQuery("#insertyahoomapcategoryimg" + i).val();
			link['event'] = event;
			link['inputelement'] = event.target;
			insertyahoomap_category_img_change(link);
		});
	});
	eleCell = eleRow.insertCell(-1);
	eleCell.id = "insertyahoomapcategoryimgsample" + i;
	eleCell.innerHTML = '　';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamwidth' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamheight' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamdx' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamdy' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_category_delete(' + i + ');void(0);" id="insertyahoomapcategorydeletebutton' + i + '">削除</a>';
	if ('function' === typeof window.parent.emoji_window_show) {
		eleCell.innerHTML += '<a href="javascript:void(0);" id="insertyahoomapcategoryemojibutton' + i + '" title="絵文字参照" style="vertical-align:middle;"><img alt="絵文字参照" id="insertyahoomapcategoryemojibutton' + i + '" src="' + insertyahoomap_EMOJIURL + 'images/smile.gif"/></a>';
		jQuery(function () {
			jQuery("#insertyahoomapcategoryemojibutton" + i).click(function(event){
				var link = new Array();
				link['calltype'] = "insertyahoomap";
				link['event'] = event;
				link['divelement'] = jQuery("#insertyahoomapemojidiv").get();
				link['inputelement'] = document.getElementById(event.target.id.replace("insertyahoomapcategoryemojibutton","insertyahoomapcategoryimg"));
				link['onselect'] = insertyahoomap_category_img_change;
				window.parent.emoji_window_show(link);
			});
		});
	}
	return i;
}
// カテゴリー画像変更
function insertyahoomap_category_img_change(link) {
	var i = link['inputelement'].id.replace("insertyahoomapcategoryimg","");
	var sample_element = document.getElementById("insertyahoomapcategoryimgsample" + i);
	sample_element.innerHTML = '<img src="' + link['imageurl'] + '" width="14px" height="14px" alt="無" id="insertyahoomapcategoryimgsampleimg' + i + '" onLoad="javascript:imageExist(this);void(0);"/>';
}
// カテゴリー適用変更
function insertyahoomap_category_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomapcategoryenable","");
	ymap.removeCategory(document.getElementById("insertyahoomapcategoryid" + i).value);
	jQuery("#insertyahoomapcategoryid" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategoryimg" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategoryparamwidth" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategoryparamheight" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategoryparamdx" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategoryparamdy" + i).attr("readonly", false);
	jQuery("#insertyahoomapcategorydeletebutton" + i).css("visibility", "visible");
	jQuery("#insertyahoomapcategoryemojibutton" + i).css("visibility", "visible");
	var id = document.getElementById("insertyahoomapcategoryid" + i).value;
	jQuery("select[id^='insertyahoomapicontype']").children('[@value="' + id + '"]').remove();
	if (change_element.checked) {
		if (id.length == 0) {
			alert('カテゴリIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		jQuery("input[id^='insertyahoomapcategoryid']").each(function (index, domEle) {
			if (domEle.id != ("insertyahoomapcategoryid" + i)
			&&  document.getElementById(domEle.id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked
			&&  domEle.value == id) {
				alert('カテゴリIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		});
		if (!change_element.checked) {
			return;
		}
		var img = document.getElementById("insertyahoomapcategoryimg" + i).value;
		if (!document.getElementById("insertyahoomapcategoryimgsampleimg" + i)
		||  document.getElementById("insertyahoomapcategoryimgsampleimg" + i).alt == "無") {
			alert('画像が存在しません。');
			change_element.checked = false;
			return;
		}
		var imgobj = new Image();
		imgobj.src = img;
		var paramwidth = document.getElementById("insertyahoomapcategoryparamwidth" + i).value;
		if (paramwidth.length == 0) {
			paramwidth = imgobj.width;
			document.getElementById("insertyahoomapcategoryparamwidth" + i).value = imgobj.width;
		}
		if (!isnumber(paramwidth)) {
			alert('画像スタイル幅が正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramheight = document.getElementById("insertyahoomapcategoryparamheight" + i).value;
		if (paramheight.length == 0) {
			paramheight = imgobj.height;
			document.getElementById("insertyahoomapcategoryparamheight" + i).value = imgobj.height;
		}
		if (!isnumber(paramheight)) {
			alert('画像スタイル高さが正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramdx = document.getElementById("insertyahoomapcategoryparamdx" + i).value;
		if (paramdx.length == 0) {
			paramdx = "0";
			document.getElementById("insertyahoomapcategoryparamdx" + i).value = "0";
		}
		if (!isnumberinnegative(paramdx)) {
			alert('基準横が正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramdy = document.getElementById("insertyahoomapcategoryparamdy" + i).value;
		if (paramdy.length == 0) {
			paramdy = "0";
			document.getElementById("insertyahoomapcategoryparamdy" + i).value = "0";
		}
		if (!isnumberinnegative(paramdy)) {
			alert('基準縦が正しくありません。');
			change_element.checked = false;
			return;
		}
		var param = '{"width":' + paramwidth + ',"height":' + paramheight + ',"dx":' + paramdx + ',"dy":' + paramdy + '}';
		ymap.addCategory(id,img,param);
		jQuery("#insertyahoomapcategoryid" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategoryimg" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategoryparamwidth" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategoryparamheight" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategoryparamdx" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategoryparamdy" + i).attr("readonly", true);
		jQuery("#insertyahoomapcategorydeletebutton" + i).css("visibility", "hidden");
		jQuery("#insertyahoomapcategoryemojibutton" + i).css("visibility", "hidden");
		jQuery("select[id^='insertyahoomapicontype']").append(jQuery("<option>").html(id).attr({value:id}));
	}
}
// アイコン画像存在設定
function imageExist(ele){
	ele.alt = "有";
}
// カテゴリー削除
function insertyahoomap_category_delete(i) {
	var eleTable = document.getElementById("insertyahoomapcategory");
	var eleRow = document.getElementById("insertyahoomapcategory" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
// アイコン追加
function insertyahoomap_icon_insert() {
	var i = 1;
	while (document.getElementById("insertyahoomapicon" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomapicon");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomapicon" + i;
	var eleCell = eleRow.insertCell(-1);
	eleCell.rowSpan = '2';
	eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapiconenable' + i + '"/>';
	jQuery(function () {
		jQuery("#insertyahoomapiconenable" + i).click(function(event){
			insertyahoomap_icon_enable_change(event.target);
		});
	});
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconid' + i + '" value="icon' + i + '"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlat' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlon' + i + '" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<select class="select" id="insertyahoomapicontype' + i + '"><option value="L1">L1<option value="L2">L2<option value="L3">L3<option value="L4">L4<option value="L5">L5<option value="S1">S1<option value="S2">S2<option value="S3">S3<option value="S4">S4<option value="S5">S5</select>';
	jQuery("input[id^='insertyahoomapcategoryenable']").each(function (index, domEle) {
		if (domEle.checked) {
			var id = document.getElementById("insertyahoomapcategoryid" + domEle.id.replace("insertyahoomapcategoryenable","")).value;
			jQuery("#insertyahoomapicontype" + i).append(jQuery("<option>").html(id).attr({value:id}));
		}
	});
	eleCell = eleRow.insertCell(-1);
	eleCell.rowSpan = '2';
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_icon_delete(' + i + ');void(0);" id="insertyahoomapicondeletebutton' + i + '">削除</a><a class="button" href="javascript:mapGetPos(\'insertyahoomapiconpos' + i + '\',ymap.getCenter());void(0);" id="insertyahoomapiconposbutton' + i + '">取得</a><a class="button" href="javascript:mapSetPos(\'insertyahoomapiconpos' + i + '\');void(0);">表示</a>';
	eleRow = eleTable.insertRow(-1);
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconpopup' + i + '" style="ime-mode:active;" value=""/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconlabel' + i + '" style="ime-mode:active;" value=""/>';
}
// アイコン適用変更
function insertyahoomap_icon_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomapiconenable","");
	ymap.removeIcon(document.getElementById("insertyahoomapiconid" + i).value);
	jQuery("#insertyahoomapiconid" + i).attr("readonly", false);
	jQuery("#insertyahoomapiconposlat" + i).attr("readonly", false);
	jQuery("#insertyahoomapiconposlon" + i).attr("readonly", false);
	jQuery("#insertyahoomapicontype" + i).attr("disabled", false);
	jQuery("#insertyahoomapiconpopup" + i).attr("readonly", false);
	jQuery("#insertyahoomapiconlabel" + i).attr("readonly", false);
	jQuery("#insertyahoomapicondeletebutton" + i).css("visibility", "visible");
	jQuery("#insertyahoomapiconposbutton" + i).css("visibility", "visible");
	var type = document.getElementById("insertyahoomapicontype" + i).value;
	var categoryid = jQuery("input[id^='insertyahoomapcategoryid']" + "input[value='" + type + "']").attr("id");
	if (categoryid) {
		jQuery("#" + categoryid.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).attr("disabled", false);
	}
	if (change_element.checked) {
		var id = document.getElementById("insertyahoomapiconid" + i).value;
		if (id.length == 0) {
			alert('アイコンIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		jQuery("input[id^='insertyahoomapiconid']").each(function (index, domEle) {
			if (domEle.id != ("insertyahoomapiconid" + i)
			&&  document.getElementById(domEle.id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked
			&&  domEle.value == id) {
				alert('アイコンIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		});
		if (!change_element.checked) {
			return;
		}
		var poslat = document.getElementById("insertyahoomapiconposlat" + i).value;
		if (poslat.length == 0) {
			alert('緯度が設定されていません。');
			change_element.checked = false;
			return;
		}
		if (!isnumeric(poslat)) {
			alert('緯度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var poslon = document.getElementById("insertyahoomapiconposlon" + i).value;
		if (poslon.length == 0) {
			alert('経度が設定されていません。');
			change_element.checked = false;
			return;
		}
		if (!isnumeric(poslon)) {
			alert('経度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var pos = poslat + ',' + poslon;
		var popup = document.getElementById("insertyahoomapiconpopup" + i).value;
		var label = document.getElementById("insertyahoomapiconlabel" + i).value;
		ymap.addIcon(id,pos,popup,type,label);
		jQuery("#insertyahoomapiconid" + i).attr("readonly", true);
		jQuery("#insertyahoomapiconposlat" + i).attr("readonly", true);
		jQuery("#insertyahoomapiconposlon" + i).attr("readonly", true);
		jQuery("#insertyahoomapicontype" + i).attr("disabled", true);
		jQuery("#insertyahoomapiconpopup" + i).attr("readonly", true);
		jQuery("#insertyahoomapiconlabel" + i).attr("readonly", true);
		jQuery("#insertyahoomapicondeletebutton" + i).css("visibility", "hidden");
		jQuery("#insertyahoomapiconposbutton" + i).css("visibility", "hidden");
		if (categoryid) {
			jQuery("#" + categoryid.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).attr("disabled", true);
		}
	}
}
// アイコン削除
function insertyahoomap_icon_delete(i) {
	var eleTable = document.getElementById("insertyahoomapicon");
	var eleRow = document.getElementById("insertyahoomapicon" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex + 1);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
// 数字チェック
function isnumber(val) {
	return String(val).match(/\d+/) == String(val);
}
// 数字チェック（少数以下含む）
function isnumeric(val) {
	return String(val).match(/^\d+(?:|\.\d+)$/) == String(val);
}
// 数字チェック（負数含む）
function isnumberinnegative(val) {
	return String(val).match(/^[-]?\d+/) == String(val);
}
// デフォルトカテゴリ設定開始
function insertyahoomap_default_category_init() {
	jQuery("#insertyahoomapdefaultcategorydiv").css("display", "block");
	jQuery("#insertyahoomapdefaultcategorydiv").css("position", "absolute");
	jQuery("#insertyahoomapdefaultcategorydiv").css("left", jQuery("#insertyahoomap_default_category_button").offset().left);
	jQuery("#insertyahoomapdefaultcategorydiv").css("top", jQuery("#insertyahoomap_default_category_button").offset().top);
	jQuery("#insertyahoomapdefaultcategorydiv").css("background", "#fff");
	jQuery("#insertyahoomapdefaultcategorydiv").css("padding", "5px");
	jQuery("#insertyahoomapdefaultcategorydiv").css("border", "1px solid #dfdfdf");
	jQuery("#insertyahoomapdefaultcategorydiv").css("width", "600px");
// カテゴリー初期化
	var eleCategorys = jQuery("input[id^='insertyahoomapcategoryid']").get();
	for (var i = 0; i < eleCategorys.length; i++) {
		insertyahoomap_category_delete(eleCategorys[i].id.replace("insertyahoomapcategoryid",""));
	}
// カテゴリー復元
	insertyahoomap_default_category_load("options",jQuery("#insertyahoomap_default_category").val());
}
// デフォルトカテゴリ復元
function insertyahoomap_default_category_load(calltype,categorydatas) {
	var categorydata = categorydatas.split(",");
	if (categorydata.length > 1
	||  categorydata[0]) {
		var j = 0;
		var id = 0;
		for (var i = 0; i < categorydata.length; i++) {
			if (j == 0) {
				id = insertyahoomap_category_insert(calltype);
			}
			j++;
			switch (j) {
				case 1:
					jQuery("#insertyahoomapcategoryid" + id).val(unescape(categorydata[i]));
					break;
				case 2:
					jQuery("#insertyahoomapcategoryimg" + id).val(unescape(categorydata[i]));
					var link = new Array();
					link['imageurl'] = unescape(categorydata[i]);
					link['inputelement'] = document.getElementById("insertyahoomapcategoryimg" + id);
					insertyahoomap_category_img_change(link);
					break;
				case 3:
					jQuery("#insertyahoomapcategoryparamwidth" + id).val(unescape(categorydata[i]));
					break;
				case 4:
					jQuery("#insertyahoomapcategoryparamheight" + id).val(unescape(categorydata[i]));
					break;
				case 5:
					jQuery("#insertyahoomapcategoryparamdx" + id).val(unescape(categorydata[i]));
					break;
				case 6:
					jQuery("#insertyahoomapcategoryparamdy" + id).val(unescape(categorydata[i]));
					j = 0;
					break;
			}
		}
	}
}
// デフォルトカテゴリ決定
function insertyahoomap_default_category_enter() {
	var categorydata = '';
// カテゴリー
	var eleCategorys = jQuery("input[id^='insertyahoomapcategoryid']").get();
	for (var i = 0; i < eleCategorys.length; i++) {
		if (categorydata) {
			categorydata += ',';
		}
// カテゴリＩＤ
		categorydata += escape(eleCategorys[i].value);
// カテゴリ画像
		var idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryimg");
		categorydata += ',' + escape(jQuery("#" + idvalue).val());
// 画像スタイル幅
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamwidth");
		categorydata += ',' + escape(jQuery("#" + idvalue).val());
// 画像スタイル高さ
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamheight");
		categorydata += ',' + escape(jQuery("#" + idvalue).val());
// 画像スタイル基準横
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdx");
		categorydata += ',' + escape(jQuery("#" + idvalue).val());
// 画像スタイル基準縦
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdy");
		categorydata += ',' + escape(jQuery("#" + idvalue).val());
	}
	jQuery("#insertyahoomap_default_category").val(categorydata);
	insertyahoomap_default_category_close();
}
// デフォルトカテゴリ取消
function insertyahoomap_default_category_cancel() {
	insertyahoomap_default_category_close();
}
// デフォルトカテゴリ設定終了
function insertyahoomap_default_category_close() {
	jQuery("#insertyahoomapdefaultcategorydiv").css("display", "none");
}
