<?php
/* ==================================================
 *   Redirect to external sites
   ================================================== */

if (defined('ABSPATH')) {
	$path = ABSPATH;
} else {
	$path = dirname(dirname(dirname(dirname(__FILE__)))) . '/';
}
if (file_exists($path . 'wp-load.php')) {
	require_once $path . 'wp-load.php';
} elseif (file_exists($path . 'wp-config.php')) {
	require_once $path . 'wp-config.php';
} else {
	die('Could not open the redirect page because custom WP_PLUGIN_DIR is set.');
}

if (! isset($Ktai_Style) || ! $Ktai_Style->is_ktai()) {
	wp_redirect(get_bloginfo('url'));
} else {
	$Redir = new Ktai_Style_Redir;
}
exit();

/* ==================================================
 *   Ktai_Style_Redir class
   ================================================== */

class Ktai_Style_Redir {
	private $url = NULL;

// ==================================================
public function __construct() {
	if (isset($_GET['url']) && ! empty($_GET['url'])) {
		$this->url = clean_url($_GET['url']);
		$mobile_url = $this->discover_mobile($this->url);
		if ($mobile_url) {
			wp_redirect($mobile_url);
			exit;
		}
		$this->output();
	} else {
		wp_redirect(get_bloginfo('url'));
	}
}

/* ==================================================
 * @param	none
 * @return	string   $mobile_url
 * based on discover_pingback_server_uri() at comment.php of WP 2.5.1
 */
private function discover_mobile($url) {
	global $wp_version;

	$byte_count = 0;
	$timeout_bytes = 32768;
	$headers = '';
	extract(parse_url($url), EXTR_SKIP);
	if ( !isset($host) ) // Not an URL. This should never happen.
		return false;

	$path  = ( !isset($path) ) ? '/'          : $path;
	$path .= ( isset($query) ) ? '?' . $query : '';
	$port  = ( isset($port)  ) ? $port        : 80;

	// Try to connect to the server at $host
	$fp = @fsockopen($host, $port, $errno, $errstr, 2.0);
	if ( !$fp ) // Couldn't open a connection to $host
		return false;

	// Send the GET request
	$request = "GET $path HTTP/1.1\r\nHost: $host\r\nUser-Agent: WordPress/$wp_version \r\n\r\n";
	// ob_end_flush();
	fputs($fp, $request);

	// Check the content type
	while (! feof($fp)) {
		$line = fgets($fp, 512);
		if (trim($line) == '')
			break;
		$headers .= trim($line)."\n";
		if ( strpos(strtolower($headers), 'content-type: ') ) {
			preg_match('#content-type: (.+)#is', $headers, $matches);
			$content_type = trim($matches[1]);
		}
	}

	if ( preg_match('#(image|audio|video|model)/#is', $content_type) ) // Not an (x)html, sgml, or xml page, no use going further
		return false;

	$is_chunked = preg_match('/^Transfer-Encoding: chunked$/im', $headers);
	$contents = '';
	$offset = 0;
	while (! feof($fp)) {
		$line = $this->fgets($fp, $line);
		if (is_null($line)) {
			return false;
		} elseif (empty($line)) {
			continue;
		}
		$contents .= trim($line);
		if (preg_match_all('!<link([^>]*?)media=([\'"])handheld\\2([^>]*)/?>!', $contents, $links, PREG_SET_ORDER | PREG_OFFSET_CAPTURE, $offset)) {
			foreach ($links as $l) {
				$attr = $l[1][0] . $l[3][0];
				if (! preg_match('/rel=([\'"])alternate\\1/i', $attr) || ! preg_match('/href=([\'"])(.*?)\\1/', $attr, $href)) {
					continue;
				}
				if (! preg_match('!^(https?:/)?/!', $href[2])) { // relarive URL
					$href[2] = $url . $href[2];
				}
				$mobile_url = sanitize_url($href[2]);
				if ($mobile_url) {
					return $mobile_url;
				}
			}
			$offset = $links[count($links) -1][1] + strlen($links[count($links) -1][0]);
		}
		$byte_count += strlen($line);
		if ( $byte_count > $timeout_bytes ) {
			// It's no use going further, there probably isn't any pingback
			// server to find in this file. (Prevents loading large files.)
			return false;
		}
	}
	// We didn't find anything.
	return false;
}

/* ==================================================
 * @param	resource $fp
 * @param	boolean  $is_chunked
 * @return	string   $line
 */
private function fgets($fp, $is_chunked) {
	$line = fgets($fp, 4096);
	if (! trim($line)) {
		return '';
	} elseif ($is_chunked && preg_match('/^[0-9a-fA-F]+$/', trim($line))) {
		$length = hexdec($line);
		if ($length <= 0) {
			return NULL;
		}
		for ($chunk = '' ; strlen($chunk) < $length ; $chunk .= $bytes) {
			if (feof($fp)) {
				break;
			}
			$bytes = fread($fp, $length - strlen($chunk));
			if (empty($bytes)) {
				break;
			}
		}
		$line = $chunk;
	}
	return $line;
}

// ==================================================
private function output() {
	global $Ktai_Style;
	$charset = $Ktai_Style->ktai->get('charset');
	$title = __('Confirm connecting to external sites', 'ktai_style');
	$full_url = $this->url;
	if (preg_match('|^/|', $this->url)) {
		$full_url = preg_replace('|^(https?://[^/]*)/.*$|', '$1', get_bloginfo('url')) . $this->url;
	}
	$html = '<p>' . __('You are about to visit a website for PC:', 'ktai_style') . "<br />\n"
	      . '<a href="' . attribute_escape($this->url) . '">' . attribute_escape($full_url) . "</a>";
	if ($Ktai_Style->is_ktai() == 'KDDI' && $Ktai_Style->get('type') == 'WAP2.0') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by PC Site Viewer.</a>)', 'ktai_style'), ' href="device:pcsiteviewer?url=' . attribute_escape($full_url) . '"');
	} elseif ($Ktai_Style->is_ktai() == 'DoCoMo' && $Ktai_Style->get('type') == 'FOMA') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by Full Browser.</a>)', 'ktai_style'), 'href="' . attribute_escape($this->url) . '" ifb="' . attribute_escape($full_url) . '"');
	}
	$html .= "</p>\n<p>" . __('If you are sure, follow above link. If not, go to the previous page with browser\'s back button.', 'ktai_style') . '</p>';
	$html .='<form action=""><div>' . __('To copy the URL, use below text field:', 'ktai_style') . '<br /><input type="text" name="url" size="80" maxlength="255" value="' . attribute_escape($full_url) . '" /></div></form>';
	nocache_headers();
	$Ktai_Style->ks_die(apply_filters('redir/ktai_style.php', $html, $full_url), $title, false);
}

// ===== End of class ====================
}
?>