// wp-autopager.js
//  Released under the GPL license
//   http://www.gnu.org/copyleft/gpl.html

//  this script based on
//   GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
//   thanks to ma.la.

// Array.prototype.contains()
// Whether the value that exists in the array is included is examined.
// Core code from - Reread (http://text.readalittle.net/article.php?id=135)
if(!Array.prototype.contains){
  Array.prototype.contains = function(value){
    for(var i in this){if(this.hasOwnProperty(i) && this[i]===value){return true;}}
    return false;
  }
}

function autopager(query, next_page, max_page){
  var Enable = true;
  var remain = 500;
  var content_id = 'content';
  var post_class = 'post';
  var navi_class = 'navigation';

  var loading_src = '/wp-content/plugins/wp-autopager/ajax-loader.gif';
  var loading_txt = 'Now Loading...';
  var loading_html = '<img src="' + loading_src + '" alt="' + loading_txt + '" style="float:left;margin:0 1em;" /><p style="float:left;">' + loading_txt + '</p>';

  var last_page = (next_page > max_page);
  var loading = false;
  var insertPoint;

  var getPageScrollY = function(){
    var yScroll = 0;
    if (window.pageYOffset) {
      yScroll = window.pageYOffset;
    } else if (document.documentElement && document.documentElement.scrollTop){
      // Explorer 6 Strict
      yScroll = document.documentElement.scrollTop;
    } else if (document.body) {
      // all other Explorers
      yScroll = document.body.scrollTop;
    }
    return yScroll;
  }

  var getPageHeight = function(){
    var yScroll = 0;
    if (window.innerHeight && window.scrollMaxY) {
      yScroll = window.innerHeight + window.scrollMaxY;
    } else if (document.body.scrollHeight > document.body.offsetHeight){
      // all but Explorer Mac
      yScroll = document.body.scrollHeight;
    } else {
      // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
      yScroll = document.body.offsetHeight;
    }

    var windowHeight = 0;
    if (window.innerHeight) {
      // all except Explorer
      windowHeight = window.innerHeight;
    } else if (document.documentElement && document.documentElement.clientHeight) {
      // Explorer 6 Strict Mode
      windowHeight = document.documentElement.clientHeight;
    } else if (document.body) {
      // other Explorers
      windowHeight = document.body.clientHeight;
    }	

    // for small pages with total height less then height of the viewport
    return ((yScroll < windowHeight) ? windowHeight : yScroll) - windowHeight;
  }

  // start watch scroll
  var watch_scroll = function(){
    if(loading || last_page || !Enable){return;}
    if(getPageHeight() - getPageScrollY() < remain){do_request();}
    var self = arguments.callee;
    setTimeout(self, 100);
  };

  // find navigation
  var find_navi = function() {
    var navi;
    var not_found = true;
    var content = document.getElementById(content_id);
    var div = content.getElementsByTagName('div');
    for(var i=0; i<div.length; i++){
      if(div[i].className.split(' ').contains(navi_class)){
        navi = div[i];
        not_found = false;
        break;
      }
    }
    if (not_found) {
      navi = document.createElement('div');
      navi.setAttribute('class', navi_class);
      content.appendChild(navi);
    }
    return navi;
  }

  // get next page and insert
  var do_request = function(){
    if(last_page || loading || !Enable){return;}
    loading = true;

    // Display Now Loading...
    insertPoint.innerHTML = loading_html;

    // Get Next Page
    var xmlhttp;
    try{
      try{
        xmlhttp = new ActiveXObject('Microsoft.XMLHTTP');
      }catch(e){
        xmlhttp = new XMLHttpRequest();
      }

      // XMLHttpRequest state change
      xmlhttp.onreadystatechange = function(){
        if(xmlhttp.readyState == 4) {
          if(xmlhttp.status == 200) {
            var newPage_html = xmlhttp.responseText.replace(/[\r\n]/g,'').replace(/.*<body.*?>(.*?)<\/body>.*$/, '$1').replace(/<script.*?>.*<\/script>/g, '');
            var newPage = document.createElement('div');
            newPage.innerHTML = newPage_html;
            var div = newPage.getElementsByTagName('div');
            var len = div.length;
            var navi_html = '';
            for(var i=0; i<len; i++){
              if(div[i].className.split(' ').contains(post_class)){
                insertPoint.parentNode.insertBefore(div[i], insertPoint);
                i--; len = div.length;
              }
              if(div[i].className.split(' ').contains(navi_class)){
                navi_html = div[i].innerHTML;
                break;
              }
            }
            insertPoint.innerHTML = navi_html;
            newPage.innerHTML = '';
            next_page ++;
          } else {
            last_page = true;
            Enable = false;
            insertPoint.innerHTML = '';
          }
          if (max_page != 0 && next_page > max_page) {
            last_page = true;
            Enable = false;
            insertPoint.innerHTML = '';
          }
          loading = false;
          if (Enable) {watch_scroll();}
        }
      };

      // XMLHttpRequest
      var url = query+next_page;
      if(url.indexOf('/page/')!=-1) {url = url + '/';}
      url = url.replace('&amp;','&');
      xmlhttp.open('GET', url, true);
      xmlhttp.send(null);

    }catch (e){

    }
  };

  // init
  var init_autopager = function(){
    if(last_page){Enable = false;}

    // find insertpoint
    insertPoint = find_navi();

    // Enable / UnEnable
    if(document.body.attachEvent){
      document.body.attachEvent('ondblclick', function(){Enable = Enable?false:true; if(Enable){watch_scroll();}});
    }else{
      document.body.addEventListener('dblclick', function(){Enable = Enable?false:true; if(Enable){watch_scroll();}}, true);
    }

    // start watch scroll
    watch_scroll();
  };

  // init 
  init_autopager();
};
