<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Services class
     version 0.82
   ================================================== */

class Ktai_Services {
	private $type;

/* ==================================================
 * @param	none
 * @return	object
 */
public function factory($wince = FALSE) {
	$type = NULL;
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('#^DoCoMo/#', $ua)) {
		$type = new Ktai_Service_imode;
	} elseif (preg_match('#^J-PHONE/#', $ua)) {
		$type = new Ktai_Service_Softbank_PDC;
	} elseif (preg_match('#^(Vodafone/|MOT-[CV]|SoftBank/)#', $ua)) {
		$type = new Ktai_Service_Softbank_3G;
	} elseif (preg_match('#(DDIPOCKET|WILLCOM);#', $ua)) {
		$type = new Ktai_Service_imode; // WILLCOM uses the same charset as DoCoMo
	} elseif (preg_match('#^(KDDI-|UP\.Browser)#',$ua)) {
		$type = new Ktai_Service_EZweb;
	} elseif (preg_match('#(Nokia\\d+|^Opera Mini)/#', $ua)) {
		$type = new Ktai_Service_Other;
	} elseif (defined('KS_DEBUG') && preg_match('#Camino#', $ua)) {
		$type = new Ktai_Service_Other;
	} elseif ($wince) {
		if (preg_match('#Windows CE; SHARP/WS\\d+SH; .*Opera#', $ua)) {
			$type = new Ktai_Service_imode; // WILLCOM
		} elseif (preg_match('#Windows CE; SHARP/S\\d+SH; .*Opera#', $ua)) {
			$type = new Ktai_Service_Other; // E-Mobile
		}
	}
	return $type;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	$buffer = preg_replace('!<(p|div)( (id|class|align)=([\'"])[-_ a-zA-Z0-9]+\4)*>\\s*</\\1>\\s*!', '', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Other class
   ================================================== */

class Ktai_Service_Other extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return parent::shrink($buffer);
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function replace_smiley($buffer) {
	$buffer = preg_replace('#(<img src=".*?"( alt=".*?")?) class="wp-smiley" ?/?>#', '\\1 />', $buffer);
	return $buffer;
}


/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('#<img localsrc="(.*?)"( alt="(.*?)")? ?/?>#', '\3', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return parent::shrink($buffer);
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '<img localsrc="257">',
		'icon_biggrin.gif'   => '<img localsrc="454">',
		'icon_sad.gif'       => '<img localsrc="441">',
		'icon_surprised.gif' => '<img localsrc="350">',
		'icon_eek.gif'       => '<img localsrc="451">',
		'icon_confused.gif'  => '<img localsrc="444">',
		'icon_cool.gif'      => '<img localsrc="382">',
		'icon_mad.gif'       => '<img localsrc="258">',
		'icon_razz.gif'      => '<img localsrc="264">',
		'icon_neutral.gif'   => '<img localsrc="440">',
		'icon_wink.gif'      => '<img localsrc="348">',
		'icon_lol.gif'       => '<img localsrc="789">',
		'icon_redface.gif'   => '<img localsrc="349">', // 446 is better?
		'icon_cry.gif'       => '<img localsrc="259">',
		'icon_evil.gif'      => '<img localsrc="277">',
		'icon_twisted.gif'   => '<img localsrc="277">',
		'icon_rolleyes.gif'  => '<img localsrc="442">',
		'icon_exclaim.gif'   => '<img localsrc="2">',
		'icon_question.gif'  => '<img localsrc="3">',
		'icon_idea.gif'      => '<img localsrc="77">',
		'icon_arrow.gif'     => '<img localsrc="63">',
		'icon_mrgreen.gif'   => '<img localsrc="814">',
	);
	$pat = preg_replace('/^(.*)$/', '#<img src=".*?/\\1"( alt=".*?")? class="wp-smiley" ?/?>#', array_keys($smiles));
	$buffer = preg_replace($pat, $smiles, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('#<img localsrc="(.*?)"( alt=".*?")? ?/?>#', '<img localsrc="\\1">', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
//	$buffer = preg_replace('#<img src="(.*?)\.png"#', '<img src="\\1.gif"', $buffer);
	return parent::shrink($buffer);
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '&#63893;',
		'icon_biggrin.gif'   => '&#xE72A;',
		'icon_sad.gif'       => '&#63896;',
		'icon_surprised.gif' => '&#63914;', // impact
		'icon_eek.gif'       => '&#xE757;', 
		'icon_confused.gif'  => '&#xE72B;',
		'icon_cool.gif'      => '&#xE752;',
		'icon_mad.gif'       => '&#63894;',
		'icon_razz.gif'      => '&#xE728;',
		'icon_neutral.gif'   => '&#xE725;',
		'icon_wink.gif'      => '&#xE729;',
		'icon_lol.gif'       => '&#xE728;',
		'icon_redface.gif'   => '&#xE726;',
		'icon_cry.gif'       => '&#xE72D;',
		'icon_evil.gif'      => '&#xE724;',
		'icon_twisted.gif'   => '&#xE724;',
		'icon_rolleyes.gif'  => '&#xE720;',
		'icon_exclaim.gif'   => '&#63911;',
		'icon_question.gif'  => '&#63912;',
		'icon_idea.gif'      => '&#63904;',
		'icon_arrow.gif'     => '&#63835;',
		'icon_mrgreen.gif'   => '&#xE753;',
	);
	$pat = preg_replace('/^(.*)$/', '#<img src=".*?/\\1"( alt=".*?")? class="wp-smiley" ?/?>#', array_keys($smiles));
	$buffer = preg_replace($pat, $smiles, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 * Reference: http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#xE737;', // warning (!)
		'2'   => '&#63911;', // exclamation (!)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '',       // double left triangle
		'8'   => '',       // double right triangle
		'16'  => '&#63651;', // thunder
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'44'  => '&#63647;', // sun
		'45'  => '&#63668;', // baseball
		'46'  => '&#63838;', // clock
		'50'  => '&#63829;', // face (female)
		'51'  => '&#63889;', // heart
		'56'  => '&#63722;', // note
		'61'  => '~',       // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'68'  => '&#63893;', // smile
		'77'  => '&#63904;', // lamp
		'80'  => '&#63829;', // face (male)
		'81'  => '&#xE731;', // copyright mark
		'82'  => '&#xE736;', // registered mark
		'83'  => '&#63715;', // briefcase
		'85'  => '&#63720;', // telephone (fixed)
		'86'  => '&#63722;', // memo
		'94'  => '&#63714;', // camera
		'95'  => '&#63649;', // rain
		'96'  => '&#63671;', // american football??
		'97'  => '&#63716;', // book
		'98'  => '&#xE72F;', // keep out sign
		'99'  => '&#63694;', // traffic signal
		'100' => '&#63716;', // book
		'101' => '&#63716;', // book
		'102' => '&#63716;', // book
		'103' => '&#63722;', // document
		'104' => '&#63702;', // scissors
		'105' => '&#63722;', // daily calender
		'106' => '&#63711;', // ticket
		'107' => '&#63648;', // cloud
		'108' => '&#63863;', // mail envelope
		'109' => '&#63866;', // money
		'112' => '&#63684;', // home
		'116' => '&#63730;', // glass / eye
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'125' => '&#63679;', // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => '&#xE730;', // clip
		'144' => '&#63718;', // present box
		'146' => '&#63696;', // knife and fork
		'149' => '&#63826;', // pen
		'151' => '&#63863;', // envelope
		'152' => '&#xE718;', // spanner
		'155' => '&#63720;', // telephone (handset)
		'156' => '&#63685;', // factory
		'161' => '&#63721;', // mobile phone
		'168' => '&#63683;', // air plane
		'169' => '&#63682;', // boat (ship)
		'172' => '&#63676;', // electric train
		'176' => '&#63712;', // smoking
		'177' => '&#63713;', // no smoking
		'178' => '&#63740;', // wheel car
		'179' => '[t}[N]', // beginner driver mark
		'180' => '&#63879;', // one
		'181' => '&#63880;', // two
		'182' => '&#63881;', // three
		'183' => '&#63882;', // four
		'184' => '&#63883;', // five
		'185' => '&#63884;', // six
		'186' => '&#63885;', // seven
		'187' => '&#63886;', // eight
		'188' => '&#63887;', // nine
		'190' => '&#63652;', // storm
		'191' => '&#63650;', // snowball
		'192' => '&#63655;', // Aries (Ram)
		'193' => '&#63656;', // Taurus (Bull)
		'194' => '&#63657;', // Gemini (Twins)
		'195' => '&#63658;', // Cancer (Crab)
		'196' => '&#63659;', // Leo (Lion)
		'197' => '&#63660;', // Virgo (Virgin)
		'198' => '&#63661;', // Libra (Scales)
		'199' => '&#63662;', // Scorpius (Scorpion)
		'200' => '&#63663;', // Sagittarius (Archer)
		'201' => '&#63664;', // Capricornus (Goat)
		'202' => '&#63665;', // Aquarius (Water Bearer)
		'203' => '&#63666;', // Pisces (Fishes)
		'204' => '[֎g]', // Ophiuchus (Serpent Bearer)
		'205' => '&#63689;', // Automatic Teller Machine
		'206' => '&#63691;', // convenience store
		'207' => '&#63695;', // toilet
		'208' => '&#63693;', // parking
		'209' => '&#63681;', // bus stop
		'212' => '&#63688;', // bank
		'213' => '&#63692;', // gas station
		'215' => '&#xE71D;', // bicycle
		'216' => '&#63681;', // bus
		'217' => '&#63678;', // shinkansen (bullet train)
		'218' => '&#xE733;', // marathon
		'219' => '&#63671;', // football (soccer)
		'220' => '&#63670;', // tennis
		'221' => '&#xE712;', // snow board
		'222' => '&#63674;', // checker flag
		'223' => '&#63706;', // amusement park
		'224' => '&#63900;', // spa
		'226' => '&#63824;', // movie (clapper board)
		'227' => '&#63831;', // night scene
		'233' => '&#xE715;', // doller bag
		'234' => '&#63816;', // christmas tree
		'235' => '&#xE748;', // cherry blossom
		'257' => '&#63893;', // laugh face
		'258' => '&#63894;', // angry face
		'259' => '&#63896;', // sad face
		'260' => '&#63897;', // tired face
		'265' => '&#63891;', // heart break
		'278' => '&#63652;', // flower circle
		'279' => '&#xE734;', // secret
		'299' => '&#63867;', // free
		'303' => '&#63903;', // updated
		'305' => '&#63653;', // fog
		'306' => '&#63669;', // golf
		'307' => '&#63673;', // basket ball
		'325' => '&#63888;', // zero
		'327' => '&#63897;', // very tired face
		'334' => '&#63874;', // new
		'337' => '&#xE716;', // personal computer
		'339' => '&#xE748;', // rose
		'340' => '&#xE713;', // church
		'341' => '&#63677;', // subway
		'375' => '&#63686;', // post office
		'376' => '&#63687;', // hospital
		'377' => '&#xE73E;', // school
		'378' => '&#63690;', // hotel
		'379' => '&#63682;', // ship
		'380' => '&#xE738;', // NG / prohibited for U-18
		'381' => '[|i.]',    // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => '&#63868;', // ID mark
		'386' => '&#xE73B;', // full mark
		'387' => '&#xE739;', // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => '&#63721;', // manner mode
		'394' => '&#63721;', // power off
		'421' => '&#63672;', // ski
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '#<img localsrc="\\1"( alt=".*?")? ?/?>#', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank class
   ================================================== */

class Ktai_Service_Softbank extends Ktai_Services {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '$Gv',
		'icon_biggrin.gif'   => '$P5',
		'icon_sad.gif'       => '$P!',
		'icon_surprised.gif' => '$P$',
		'icon_eek.gif'       => '$P0',
		'icon_confused.gif'  => '$P\'',
		'icon_cool.gif'      => '$F4',
		'icon_mad.gif'       => '$P6',
		'icon_razz.gif'      => '$P)',
		'icon_neutral.gif'   => '$P"',
		'icon_wink.gif'      => '$P%',
		'icon_lol.gif'       => '$P)',
		'icon_redface.gif'   => '$P-',
		'icon_cry.gif'       => '$P1',
		'icon_evil.gif'      => '$P6',
		'icon_twisted.gif'   => '$P6',
		'icon_rolleyes.gif'  => '$P7',
		'icon_exclaim.gif'   => '$GA',
		'icon_question.gif'  => '$G@',
		'icon_idea.gif'      => '$E/',
		'icon_arrow.gif'     => '$FT',
		'icon_mrgreen.gif'   => '$Gv',
	);
	$pat = preg_replace('/^(.*)$/', '#<img src=".*?/\\1"( alt=".*?")? class="wp-smiley" ?/?>#', array_keys($smiles));
	$buffer = preg_replace($pat, $smiles, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 * Reference: http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '$Fr', // warning (!)
		'2'   => '$OW', // exclamation (!)
		'5'   => '$F[', // left triangle
		'6'   => '$FZ', // right triangle
		'7'   => '$F]', // double left triangle
		'8'   => '$F\', // double right triangle
		'16'  => '$E]', // thunder
		'29'  => '$FR', // up arrow
		'30'  => '$FS', // down arrow
		'32'  => '',  // down triangle
		'33'  => '',  // up triangle
		'34'  => '',  // double down triangle
		'35'  => '',  // double up triangle
		'44'  => '$Gj', // sun
		'45'  => '$G6', // baseball
		'46'  => '$GF', // clock
		'50'  => '$G"', // face (female)
		'51'  => '$GB', // heart
		'56'  => '$O!', // note
		'61'  => '$OS', // cross
		'63'  => '$FT', // right arrow
		'64'  => '$FU', // left arrow
		'68'  => '$Gv', // smile
		'77'  => '$E/', // lamp
		'80'  => '$G!', // face (male)
		'81'  => '$Fn', // copyright mark
		'82'  => '$Fo', // registered mark
		'83'  => '$E>', // briefcase
		'85'  => '$G)', // telephone (fixed)
		'86'  => '$O!', // memo
		'94'  => '$G(', // camera
		'95'  => '$Gk', // rain
		'96'  => '$PK', // american football
		'97'  => '$Eh', // book
		'98'  => '$EW', // keep out sign
		'99'  => '$En', // traffic signal
		'100' => '$Eh', // book
		'101' => '$Eh', // book
		'102' => '$Eh', // book
		'103' => '$O!', // document
		'104' => '$O3', // scissors
		'105' => '$O!', // daily calender
		'106' => '$EE', // ticket
		'107' => '$Gi', // cloud
		'108' => '$E#', // mail envelope
		'109' => '$EO', // money
		'112' => '$GV', // home
		'116' => '$F1', // glass / eye
		'119' => '$E4', // magnifier (search)
		'120' => '$G_', // key
		'125' => '$Ez', // sedan (car)
		'140' => '$FP', // leftside finger
		'141' => '$FQ', // rightside finger
		'143' => '[clip]', // clip
		'144' => '$E2', // present box
		'146' => '$Gc', // knife and fork
		'149' => '$O!', // pen
		'151' => '$E#', // envelope
		'152' => '$E6', // spanner / hammer
		'155' => '$G)', // telephone (handset)
		'156' => '$GX', // factory
		'161' => '$G*', // mobile phone
		'168' => '$G=', // air plane
		'169' => '$F"', // boat (ship)
		'172' => '$G>', // electric train
		'176' => '$O.', // smoking
		'177' => '$F(', // no smoking
		'178' => '$F*', // wheel car
		'179' => '$F)', // beginner driver mark
		'180' => '$F<', // one
		'181' => '$F=', // two
		'182' => '$F>', // three
		'183' => '$F?', // four
		'184' => '$F@', // five
		'185' => '$FA', // six
		'186' => '$FB', // seven
		'187' => '$FC', // eight
		'188' => '$FD', // nine
		'190' => '$Pc', // storm
		'191' => '$Gh', // snowball
		'192' => '$F_', // Aries (Ram)
		'193' => '$F`', // Taurus (Bull)
		'194' => '$Fa', // Gemini (Twins)
		'195' => '$Fb', // Cancer (Crab)
		'196' => '$Fc', // Leo (Lion)
		'197' => '$Fd', // Virgo (Virgin)
		'198' => '$Fe', // Libra (Scales)
		'199' => '$Ff', // Scorpius (Scorpion)
		'200' => '$Fg', // Sagittarius (Archer)
		'201' => '$Fh', // Capricornus (Goat)
		'202' => '$Fi', // Aquarius (Water Bearer)
		'203' => '$Fj', // Pisces (Fishes)
		'204' => '$Fk', // Ophiuchus (Serpent Bearer)
		'205' => '$Et', // Automatic Teller Machine
		'206' => '$Ev', // convenience store
		'207' => '$Eq', // toilet
		'208' => '$Eo', // parking
		'209' => '$Ep', // bus stop
		'212' => '$Em', // bank
		'213' => '$GZ', // gas station
		'215' => '$EV', // bicycle
		'216' => '$Ey', // bus
		'217' => '$G?', // shinkansen (bullet train)
		'218' => '$E5', // marathon
		'219' => '$G8', // football (soccer)
		'220' => '$G5', // tennis
		'221' => '$G3', // snow board
		'222' => '$ER', // checker flag
		'223' => '$ED', // amusement park
		'224' => '$EC', // spa
		'226' => '$OD', // movie (clapper board)
		'227' => '$Pk', // night scene
		'233' => '$EO', // doller bag
		'234' => '$GS', // christmas tree
		'235' => '$GP', // cherry blossom
		'257' => '$Gv', // laugh face
		'258' => '$Gy', // angry face
		'259' => '$Gw', // sad face
		'260' => '$Gx', // tired face
		'265' => '$GC', // heart break
		'278' => '$F$', // flower circle
		'279' => '$O5', // secret
		'299' => '$F6', // free
		'303' => '$F3', // updated
		'305' => '[]',  // fog
		'306' => '$G4', // golf
		'307' => '$PJ', // basket ball
		'325' => '$FE', // zero
		'327' => '$Gx', // very tired face
		'334' => '$F2', // new
		'337' => '$G,', // personal computer
		'339' => '$GR', // rose
		'340' => '$GW', // church
		'341' => '$PT', // subway
		'375' => '$Es', // post office
		'376' => '$Eu', // hospital
		'377' => '$Ew', // school
		'378' => '$Ex', // hotel
		'379' => '$F"', // ship
		'380' => '$F\'', // prohibited for U-18
		'381' => '$F+', // anntena mark
		'382' => '$F4', // cool
		'383' => '$FG', // discount mark
		'384' => '$FH', // service mark
		'385' => '$FI', // ID mark
		'386' => '$FJ', // full mark
		'387' => '$FK', // vacant mark
		'388' => '$FL', // reserved mark
		'389' => '$FM', // in-business mark
		'390' => '$FN', // upside finger
		'391' => '$FO', // downside finger
		'393' => '$Fp', // manner mode
		'394' => '$Fq', // power off
		'421' => '$G3', // ski
		'\\d+' => '',   // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '#<img localsrc="\\1"( alt=".*?")? ?/?>#', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_3G class
   ================================================== */

class Ktai_Service_Softbank_3G extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	return parent::shrink($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_PDC class
   ================================================== */

class Ktai_Service_Softbank_PDC extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string $buffer
 * @return	string $buffer
 */
public function shrink($buffer) {
	$buffer = preg_replace('#^<\\?xml .*>\\s*<!DOCTYPE .*>\\s*#', '', $buffer);
	$buffer = preg_replace('#<h([1-6])(.*?)</h\\1>#', '<p\\2</p>', $buffer);
	$buffer = preg_replace('|<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>|', '<\\1>', $buffer);
	$buffer = preg_replace('#</li>\\s*#', '', $buffer);
	return parent::shrink($buffer);
}

// ===== End of class ====================
}

?>
