<?php
/*
Plugin Name: QuickPost
Plugin URI: http://web.twelvehorses.com/projects/quickpost/
Description: QuickPost for Wordpress. Based on BlogThis! and the Tumblr Bookmarklet
Author: Josh Kenzer
Version: 0.4
Author URI: http://www.RadicalBehavior.com
License: GPL
*/

### Create Text Domain For Translations
load_plugin_textdomain('quickpost', 'wp-content/plugins/quickpost/language');

function QuickPost_install(){
	add_option("defaultcategorytext", "");
	add_option("defaultcategoryphoto", "");
	add_option("defaultcategoryquote", "");
	add_option("defaultcategoryvideo", "");
	add_option("qp_editor_enabled", "t");
}
class QuickPost_Admin {
		function add_config_page() {
			global $wpdb, $table_prefix;
			if ( function_exists('add_submenu_page') ) {
				add_submenu_page('plugins.php', 'QuickPost', 'QuickPost', 1, basename(__FILE__), array('QuickPost_Admin','config_page'));
			}
		}
		function config_page()
		{
			global $_REQUEST,$wpdb;
			if($_REQUEST['update']) {
				update_option("defaultcategorytext",$_REQUEST['defaultcategorytext']);
				update_option("defaultcategoryphoto",$_REQUEST['defaultcategoryphoto']);
				update_option("defaultcategoryquote",$_REQUEST['defaultcategoryquote']);
				update_option("defaultcategoryvideo",$_REQUEST['defaultcategoryvideo']);
				update_option("qp_editor_enabled",$_REQUEST['qp_editor_enabled']);
			}

					?>
					<style>
					.centered { text-align:center; margin-top:30px; }
					.but {
						background-color:#dddddd;
						border:2px groove black;
						padding:2px 5px;color:black;font-family:sans-serif; text-decoration:none;
						font-size:10pt;margin:0px auto;
					}
					.qp-td {
						border:1px solid #cfcfcf;
						padding:5px;
					}
					</style>
					<form action="plugins.php?page=quickpost-admin.php&action=udcat" method="post">
					<br><br>


					<table border=0 cellspacing=3 cellpadding=2 width="80%" align=center>
					<tr>
					<td colspan=2><h2><?php _e('QuickPost Settings','quickpost'); ?></h2></td>
					</tr>
					<tr>
					<td colspan=2><?php _e('Enable WYSIWYG Editor in QuickPost','quickpost'); ?> <input name="qp_editor_enabled" value='t' type="checkbox" <?if(get_option("qp_editor_enabled") == 't') echo "checked";?>></h2></td>
					</tr>
					<tr valign=top>
						<td class="qp-td"  width="400" >
						<h3 class="dbx-handle"><?php _e('Select the default category for each of your QuickPost types.','quickpost'); ?></h3>
						<table border=0 cellspacing=3 cellpadding=2 align=center>
						  <tr>
						    <th style="whitespace:nowrap;text-align:left"><?php _e('Categories'); ?></th>
						    <th><?php _e('Text/Link','quickpost'); ?></th>
						    <th><?php _e('Photos','quickpost'); ?></th>
						    <th><?php _e('Quotes','quickpost'); ?></th>
						    <th><?php _e('Video','quickpost'); ?></th>
						  </tr>
						<?php
								$cats=$wpdb->get_results("SELECT cat_ID,cat_name FROM $wpdb->categories WHERE category_parent = 0 ORDER BY cat_name");
								foreach($cats as $cat) {
								  echo "<tr>\n";
									if($cat->cat_ID==get_option("defaultcategorytext")) $t="checked"; else $t="";
									if($cat->cat_ID==get_option("defaultcategoryphoto")) $p="checked"; else $p="";
									if($cat->cat_ID==get_option("defaultcategoryquote")) $q="checked"; else $q="";
									if($cat->cat_ID==get_option("defaultcategoryvideo")) $v="checked"; else $v="";?>
									<td nowrap><?php echo $cat->cat_name;?></td>
									<td align="center"><input type="radio" name="defaultcategorytext" <? echo $t ?> value="<?php echo $cat->cat_ID;?>"></td>
                  <td align="center"><input type="radio" name="defaultcategoryphoto" <? echo $p ?> value="<?php echo $cat->cat_ID;?>"></td>
                  <td align="center"><input type="radio" name="defaultcategoryquote" <? echo $q ?> value="<?php echo $cat->cat_ID;?>"></td>
                  <td align="center"><input type="radio" name="defaultcategoryvideo" <? echo $v ?> value="<?php echo $cat->cat_ID;?>"></td>
                </tr>
									<?php
								}?>
							</table>
							<br>
						<input type="submit" value="<?php _e('Update'); ?>" name="update">
						</td>
						<td class="qp-td" >
						<h3 class="dbx-handle"><?php _e('QuickPost Bookmarklet','quickpost'); ?></h3>
						<div class="dbx-content">
						<p><?php _e('Firefox Users: Drag and drop the "QuickPost" bookmarklet below to your links toolbar.','quickpost'); ?></p>
						<p><?php _e('Dear Internet Explorer Users: Yours is a harder path to walk.. Right click the bookmarklet below and select "Add to favourites". Your IE will probably tell you that this is an "Unsafe bookmark to add". Ignore your smart arse browser and click OK. The setup will thus be completed.','quickpost'); ?></p>
						<p class="centered"><a class="but" href="javascript:var imgstr='';for(i=0;i<document.images.length;i++){imgstr = imgstr + document.images[i].src + ',';};var d=document,w=window,e=w.getSelection,k=d.getSelection,x=d.selection,s=(e?e():(k)?k():(x?x.createRange().text:0)),f='<?php echo get_settings('siteurl');?>/wp-content/plugins/quickpost/quickpost.php',l=d.location,e=encodeURIComponent,p='?imagez='+imgstr +'&v=0.1&u='+e(l.href) +'&t='+e(d.title) +'&s='+e(s),u=f+p;try{if(!/^(.*\.)?tumblr[^.]*$/.test(l.host))throw(0);tstbklt();}catch(z){a =function(){if(!w.open(u,'t','toolbar=0,resizable=0,scrollbars=1,status=1,width=700,height=500'))l.href=u;};if(/Firefox/.test(navigator.userAgent))setTimeout(a,0);else a();}void(0)"><?php _e('QuickPost-it','quickpost'); ?></a></p>
                         
						</td>
					</tr></table>


					</form>


					<?php

		}
}


add_action('init', 'QuickPost_install');
add_action('admin_menu', array('QuickPost_Admin','add_config_page'));
