/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Map;

import woolpack.fn.Fn;

class SimilarPropertyNameMap<V> extends DelegationMap<String, V> {
	private Fn<String, Iterable<String>, RuntimeException> fn;

	SimilarPropertyNameMap(
			final Map<String, V> child,
			final Fn<String, Iterable<String>, RuntimeException> fn) {
		super(child);
		this.fn = fn;
	}

	@Override
	public boolean containsKey(final Object arg0) {
		for (final String key : fn.exec(arg0.toString())) {
			if (super.containsKey(key)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public V get(final Object arg0) {
		for (final String key : fn.exec(arg0.toString())) {
			final V value = super.get(key);
			if (value != null) {
				return value;
			}
		}
		return null;
	}
}
