/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;

public class PropertyUtilsTest extends TestCase {
	public void test0() {
		assertEquals("hogePiyo", PropertyUtils.toJavaName("hoge_piyo"));
		assertEquals("hogePiyo", PropertyUtils.toJavaName("hOgE_pIyO"));
		assertEquals("", PropertyUtils.toJavaName(""));
		assertNull("", PropertyUtils.toJavaName(null));
		assertEquals("HOGE_PIYO", PropertyUtils.toSQLName("hogePiyo"));
		assertEquals("HOGE_PIYO", PropertyUtils.toSQLName("HogePiyo"));
		assertEquals("", PropertyUtils.toSQLName(""));
		assertNull("", PropertyUtils.toSQLName(null));
	}
	
	private List<?> toList(final String s) {
		return Utils.toList(PropertyUtils.getGuessingIterable(s));
	}
	
	public void testIterable0() {
		assertEquals(Arrays.asList(
				"HOGE_PIYO",
				"hoge_piyo",
				"Hoge_Piyo",
				"hogePiyo",
				"HogePiyo",
				"hogepiyo",
				"HOGEPIYO"), toList("HOGE_PIYO"));
		assertEquals(Arrays.asList(
				"hoge_piyo",
				"HOGE_PIYO",
				"Hoge_Piyo",
				"hogePiyo",
				"HogePiyo",
				"hogepiyo",
				"HOGEPIYO"), toList("hoge_piyo"));
		assertEquals(Arrays.asList(
				"Hoge_Piyo",
				"hoge_piyo",
				"HOGE_PIYO",
				"hogePiyo",
				"HogePiyo",
				"hogepiyo",
				"HOGEPIYO"), toList("Hoge_Piyo"));
		assertEquals(Arrays.asList(
				"hogePiyo",
				"hogepiyo",
				"HOGEPIYO",
				"HOGE_PIYO",
				"hoge_piyo",
				"Hoge_Piyo",
				"HogePiyo"), toList("hogePiyo"));
		assertEquals(Arrays.asList(
				"HogePiyo",
				"hogepiyo",
				"HOGEPIYO",
				"HOGE_PIYO",
				"hoge_piyo",
				"Hoge_Piyo",
				"hogePiyo"), toList("HogePiyo"));
		
		assertEquals(Arrays.asList(
				"HogePiyo_Naru",
				"hogepiyo_naru",
				"HOGEPIYO_NARU",
				"HOGE_PIYO_NARU",
				"hoge_piyo_naru",
				"Hoge_Piyo_Naru",
				"hogepiyoNaru",
				"HogepiyoNaru",
				"hogepiyonaru",
				"HOGEPIYONARU"), toList("HogePiyo_Naru"));
	}
}
