/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

/**
 * 委譲するだけの{@link Fn}です。
 * このクラスは以下の目的で使用します。
 * <ol>
 * <li>継承クラスでアクセサ宣言を省略する。
 * <li>初期化とは別のタイミングで委譲先を再設定する。
 * </ol>
 * <br/>適用しているデザインパターン：初期化と委譲先決定とコンテキスト役決定のタイミングを分離するCurrying(3層)。
 * @author nakamura
 *
 * @param <C>
 * @param <R>
 * @param <E>
 */
public class Delegator<C, R, E extends Exception> implements Fn<C, R, E> {
	private Fn<? super C, ? extends R, ? extends E> fn;
	
	public Delegator(final Fn<? super C, ? extends R, ? extends E> fn) {
		this.fn = fn;
	}

	public R exec(final C c) throws E {
		return fn.exec(c);
	}

	public Fn<? super C, ? extends R, ? extends E> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, ? extends R, ? extends E> fn) {
		this.fn = fn;
	}
}
