/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

/**
 * 入力された真偽値から状態を随時集計するオブジェクトです。
 * <br/>適用しているデザインパターン：変数を格納する構造体。
 * @author nakamura
 *
 */
abstract public class BooleanState {
	private boolean current;
	private boolean stopped;
	
	/**
	 * 
	 * @param current 初期状態。
	 */
	protected BooleanState(final boolean current) {
		this.current = current;
		this.stopped = false;
	}
	
	/**
	 * 新しい真偽値を受け取ってこのオブジェクトの状態を更新します。
	 * @param flag 新しい真偽値。
	 */
	abstract public void in(boolean flag);
	
	/**
	 * {@link #in(boolean)}から呼び出されることを想定しています。
	 * @param stopped 新しい停止状態。
	 */
	protected void setStopped(final boolean stopped) {
		this.stopped = stopped;
	}
	
	/**
	 * 
	 * @return 現在の停止状態。
	 */
	public boolean isStopped() {
		return stopped;
	}
	
	/**
	 * {@link #in(boolean)}から呼び出されることを想定しています。
	 * @param current 新しい状態。
	 */
	protected void setCurrent(final boolean current) {
		this.current = current;
	}
	
	/**
	 * 
	 * @return 現在の状態。
	 */
	public boolean isCurrent(){
		return current;
	}
}
