/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.bool.BooleanState;
import woolpack.fn.Fn;
import woolpack.validator.AddressedMessage;
import woolpack.validator.NameBranch;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtils {
    public static final Fn<Iterable<AddressedMessage>, List<String>, RuntimeException> TO_MESSAGE = new Fn<Iterable<AddressedMessage>, List<String>, RuntimeException>(){

        @Override
        public List<String> exec(Iterable<AddressedMessage> c) throws RuntimeException {
            ArrayList<String> list = new ArrayList<String>();
            for (AddressedMessage message : c) {
                list.add(message.getMessage());
            }
            return list;
        }
    };
    public static final Fn<ValidatorContext, Object, RuntimeException> VALUE = new Fn<ValidatorContext, Object, RuntimeException>(){

        @Override
        public Object exec(ValidatorContext c) {
            return c.getValue();
        }
    };
    public static final Fn<ValidatorContext, Map<String, List<Object>>, RuntimeException> MAP = new Fn<ValidatorContext, Map<String, List<Object>>, RuntimeException>(){

        @Override
        public Map<String, List<Object>> exec(ValidatorContext c) {
            return c.getInputMap();
        }
    };
    public static final Fn<ValidatorContext, List<Object>, RuntimeException> VALUES = new Fn<ValidatorContext, List<Object>, RuntimeException>(){

        @Override
        public List<Object> exec(ValidatorContext c) {
            return c.getInputMap().get(c.getKey());
        }
    };

    private ValidatorUtils() {
    }

    public static final Fn<Iterable<AddressedMessage>, List<String>, RuntimeException> toOrderedMessage(final Iterable<String> iterable) {
        return new Fn<Iterable<AddressedMessage>, List<String>, RuntimeException>(){

            @Override
            public List<String> exec(Iterable<AddressedMessage> c) throws RuntimeException {
                ArrayList<String> list = new ArrayList<String>();
                for (String param : iterable) {
                    Iterator<AddressedMessage> it = c.iterator();
                    while (it.hasNext()) {
                        AddressedMessage message = it.next();
                        if (!param.equals(message.getKey())) continue;
                        list.add(message.getMessage());
                        it.remove();
                    }
                }
                for (AddressedMessage message : c) {
                    list.add(message.getMessage());
                }
                return list;
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfExists(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch<E>((Fn)operator, (Map)map){

            @Override
            protected Collection<String> keySet(ValidatorContext context) {
                return context.getInputMap().keySet();
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfNotEmpty(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch<E>((Fn)operator, (Map)map){

            @Override
            protected Collection<String> keySet(ValidatorContext context) {
                ArrayList<String> list = new ArrayList<String>();
                block0: for (Map.Entry<String, List<Object>> entry : context.getInputMap().entrySet()) {
                    for (Object object : entry.getValue()) {
                        if (object == null || "".equals(object)) continue;
                        list.add(entry.getKey());
                        continue block0;
                    }
                }
                return list;
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByName(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> convertValue(final Fn<Object, ?, ? extends E> fn) {
        return new Fn<ValidatorContext, Boolean, E>(){

            @Override
            public Boolean exec(ValidatorContext c) throws Exception {
                c.setValue(fn.exec(c.getValue()));
                return true;
            }
        };
    }

    public static Fn<ValidatorContext, Boolean, RuntimeException> message(final String message) {
        return new Fn<ValidatorContext, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(ValidatorContext context) {
                context.add(message);
                return false;
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localIndex(final int index, final Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new Fn<ValidatorContext, Boolean, E>(){

            @Override
            public Boolean exec(ValidatorContext context) throws Exception {
                int baseIndex = context.getIndex();
                try {
                    context.setIndex(index);
                    Boolean bl = (Boolean)fn.exec(context);
                    return bl;
                }
                finally {
                    context.setIndex(baseIndex);
                }
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localKey(final String key, final Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new Fn<ValidatorContext, Boolean, E>(){

            @Override
            public Boolean exec(ValidatorContext context) throws Exception {
                String baseKey = context.getKey();
                try {
                    context.setKey(key);
                    Boolean bl = (Boolean)fn.exec(context);
                    return bl;
                }
                finally {
                    context.setKey(baseKey);
                }
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> loopValue(final Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, final Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new Fn<ValidatorContext, Boolean, E>(){

            @Override
            public Boolean exec(ValidatorContext context) throws Exception {
                List<Object> list = context.getInputMap().get(context.getKey());
                final int length = list == null ? 1 : list.size();
                Iterable iterable = new Iterable<Fn<ValidatorContext, Boolean, ? extends E>>(){

                    @Override
                    public Iterator<Fn<ValidatorContext, Boolean, ? extends E>> iterator() {
                        return new Iterator<Fn<ValidatorContext, Boolean, ? extends E>>(this, length, fn){
                            private int i;
                            final /* synthetic */ 1 this$2;
                            private final /* synthetic */ int val$length;
                            private final /* synthetic */ Fn val$fn;
                            {
                                this.this$2 = var1_1;
                                this.val$length = n;
                                this.val$fn = fn;
                                this.i = 0;
                            }

                            public boolean hasNext() {
                                return this.i < this.val$length;
                            }

                            public Fn<ValidatorContext, Boolean, ? extends E> next() {
                                return new Fn<ValidatorContext, Boolean, E>(this, this.val$fn){
                                    final /* synthetic */ 1 this$3;
                                    private final /* synthetic */ Fn val$fn;
                                    {
                                        this.this$3 = var1_1;
                                        this.val$fn = fn;
                                    }

                                    public Boolean exec(ValidatorContext context) throws Exception {
                                        int baseIndex = context.getIndex();
                                        try {
                                            1 v0 = this.this$3;
                                            int n = 1.access$1(v0);
                                            1.access$2(v0, n + 1);
                                            context.setIndex(n);
                                            Boolean bl = (Boolean)this.val$fn.exec(context);
                                            return bl;
                                        }
                                        finally {
                                            context.setIndex(baseIndex);
                                        }
                                    }
                                };
                            }

                            public void remove() {
                                throw new UnsupportedOperationException();
                            }

                            static /* synthetic */ int access$1(1 var0) {
                                return var0.i;
                            }

                            static /* synthetic */ void access$2(1 var0, int n) {
                                var0.i = n;
                            }
                        };
                    }
                };
                BooleanState state = (BooleanState)operator.exec(null);
                for (Fn fn2 : iterable) {
                    state.in((Boolean)fn2.exec(context));
                    if (state.isStopped()) break;
                }
                return state.isCurrent();
            }
        };
    }
}

