/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import woolpack.fn.Delegator;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToCollectionViewConverter
extends Delegator<ConvertContext, Void, RuntimeException> {
    public ToCollectionViewConverter(Fn<? super ConvertContext, Void, ? extends RuntimeException> fn) {
        super(fn);
    }

    private Object copy(Object before, Collection<Object> after) {
        for (Object element : (Iterable)before) {
            after.add(element);
        }
        return after;
    }

    @Override
    public Void exec(ConvertContext c) {
        Class toType = c.getToType();
        Object before = c.getValue();
        if (List.class.isAssignableFrom(toType)) {
            if (before.getClass().isArray()) {
                c.setValue(Utils.arrayToList(before));
                return null;
            }
        } else {
            if (Set.class.isAssignableFrom(toType)) {
                if (before.getClass().isArray()) {
                    c.setValue(new LinkedHashSet<Object>(Utils.arrayToList(before)));
                } else if (before instanceof Iterable) {
                    c.setValue(this.copy(before, new LinkedHashSet<Object>()));
                } else {
                    c.setValue(Collections.singleton(before));
                }
                return null;
            }
            if (!Collection.class.isAssignableFrom(toType) && !Iterable.class.isAssignableFrom(toType)) {
                super.exec(c);
                return null;
            }
        }
        if (before.getClass().isArray()) {
            c.setValue(new ArrayList<Object>(Utils.arrayToList(before)));
        } else if (before instanceof Iterable) {
            c.setValue(this.copy(before, new ArrayList<Object>()));
        } else {
            c.setValue(Collections.singletonList(before));
        }
        return null;
    }
}

