/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryUtils {
    public static final Fn<Object, Map<String, Object>, RuntimeException> LINKED_MAP_FACTORY = new Fn<Object, Map<String, Object>, RuntimeException>(){

        @Override
        public Map<String, Object> exec(Object c) {
            return new LinkedHashMap<String, Object>();
        }
    };

    private FactoryUtils() {
    }

    public static <C, K, E extends Exception> Fn<C, Object, E> cache(final Fn<? super C, ? extends Map<? super K, Object>, ? extends E> mapGetter, final Fn<? super C, K, ? extends E> keyGetter, final Fn<? super C, ?, ? extends E> maker) {
        return new Fn<C, Object, E>(){

            @Override
            public Object exec(C c) throws Exception {
                Object key;
                Map map = (Map)mapGetter.exec(c);
                Object value = map.get(key = keyGetter.exec(c));
                if (value == null) {
                    value = maker.exec(c);
                    map.put(key, value);
                    return value;
                }
                return value;
            }
        };
    }

    public static <C, K, E extends Exception> Fn<C, Object, E> concurrentCache(final Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, final Fn<? super C, K, ? extends E> keyGetter, final Fn<? super C, ?, ? extends E> maker) {
        return new Fn<C, Object, E>(){

            @Override
            public Object exec(C c) throws Exception {
                Object value;
                ConcurrentMap map = (ConcurrentMap)mapGetter.exec(c);
                Object key = keyGetter.exec(c);
                while ((value = map.get(key)) == null) {
                    value = maker.exec(c);
                    map.putIfAbsent(key, value);
                }
                return value;
            }
        };
    }

    public static <C, K, E extends Exception> Fn<C, Void, E> cache(final Fn<? super C, ? extends Map<? super K, Object>, ? extends E> mapGetter, final Fn<? super C, ? extends K, ? extends E> keyGetter, final Fn<? super C, ?, ? extends E> maker, final EL el) {
        return new Fn<C, Void, E>(){

            @Override
            public Void exec(C c) throws Exception {
                Object key;
                Map map = (Map)mapGetter.exec(c);
                Object value = map.get(key = keyGetter.exec(c));
                if (value == null) {
                    maker.exec(c);
                    map.put(key, el.getValue(c));
                } else {
                    el.setValue(c, value);
                }
                return null;
            }
        };
    }

    public static <C, K, E extends Exception> Fn<C, Void, E> concurrentCache(final Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, final Fn<? super C, ? extends K, ? extends E> keyGetter, final Fn<? super C, ?, ? extends E> maker, final EL el) {
        return new Fn<C, Void, E>(){

            @Override
            public Void exec(C c) throws Exception {
                Object value;
                ConcurrentMap map = (ConcurrentMap)mapGetter.exec(c);
                Object key = keyGetter.exec(c);
                while ((value = map.get(key)) == null) {
                    maker.exec(c);
                    map.putIfAbsent(key, el.getValue(c));
                }
                el.setValue(c, value);
                return null;
            }
        };
    }

    public static Fn<Object, Object, RuntimeException> doEL(final GettingEL gettingEL) {
        return new Fn<Object, Object, RuntimeException>(){

            @Override
            public Object exec(Object c) {
                return gettingEL.getValue(c);
            }
        };
    }

    public static <C> Fn<C, Reader, IOException> inputStreamReaderFactory(final Fn<? super C, ? extends InputStream, ? extends IOException> inputStreamFactory, final String charset) {
        return new Fn<C, Reader, IOException>(){

            @Override
            public Reader exec(C c) throws IOException {
                InputStream stream = (InputStream)inputStreamFactory.exec(c);
                if (stream == null) {
                    return null;
                }
                try {
                    if (charset == null || charset.length() == 0) {
                        return new BufferedReader(new InputStreamReader(stream));
                    }
                    return new BufferedReader(new InputStreamReader(stream, charset));
                }
                catch (IOException e) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
        };
    }

    public static <R> Fn<Object, R, Exception> newInstance(final Class<R> clazz) {
        return new Fn<Object, R, Exception>(){

            @Override
            public R exec(Object c) throws Exception {
                return clazz.newInstance();
            }
        };
    }

    public static Fn<Object, InputStream, UnsupportedEncodingException> stringInputStreamFactory(final String charset, final String content) {
        return new Fn<Object, InputStream, UnsupportedEncodingException>(){

            @Override
            public InputStream exec(Object c) throws UnsupportedEncodingException {
                byte[] array = charset == null || charset.length() == 0 ? content.getBytes() : content.getBytes(charset);
                return new ByteArrayInputStream(array);
            }
        };
    }

    public static Fn<Object, StringReader, RuntimeException> stringReaderFactory(final String content) {
        return new Fn<Object, StringReader, RuntimeException>(){

            @Override
            public StringReader exec(Object c) {
                return new StringReader(content);
            }
        };
    }
}

