#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

CSocketHelper::CSocketHelper()
{
}

CSocketHelper::~CSocketHelper()
{
}

void CSocketHelper::ByteArrayToString(CString &dst, const CByteArray &src)
{
	dst.SetString(reinterpret_cast<LPTSTR>(const_cast<LPBYTE>(src.GetData())), src.GetSize() / sizeof(TCHAR));
}

void CSocketHelper::StringToByteArray(CByteArray &dst, const CString &src)
{
	CString cs = src;
	LPBYTE  lpData;

	lpData = reinterpret_cast<LPBYTE>(static_cast<LPTSTR>(cs.GetBuffer()));
	dst.SetSize(cs.GetLength() * sizeof(TCHAR));
	CopyMemory(dst.GetData(), lpData, dst.GetSize());
	cs.ReleaseBuffer();
	dst.FreeExtra();
}

void CSocketHelper::Serialize(CByteArray &dst, const LPVOID src, DWORD dwSize)
{
	dst.SetSize(dwSize);
	CopyMemory(dst.GetData(), src, dwSize);
}

//////////////////////////////////////////////////////////////////////////