#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CBcastSocket, CBcastSocket)

CBcastSocket::CBcastSocket() :
	m_fBcast(FALSE)
{
	ZeroMemory(&m_BcastAddr, sizeof(m_BcastAddr));
}

CBcastSocket::~CBcastSocket()
{
}

BOOL CBcastSocket::SetBroadcast(DWORD dwLocalAddress, DWORD dwMaskAddress, WORD wPort)
{
	return SetBroadcast(((dwLocalAddress & dwMaskAddress) | (~dwMaskAddress)), wPort);
}

BOOL CBcastSocket::SetBroadcast(DWORD dwBcastAddress, WORD wPort)
{
	SOCKADDR_IN siAddr;
	BOOL flag = TRUE;

	if (!SetSockOpt(SO_BROADCAST, (LPSTR)&flag, sizeof(flag)))
	{
		return FALSE;
	}

	siAddr.sin_family	   = AF_INET;
	siAddr.sin_port		   = htons(wPort);
	siAddr.sin_addr.s_addr = dwBcastAddress;

	CopyMemory(&m_BcastAddr, &siAddr, sizeof(m_BcastAddr));
	m_fBcast = TRUE;

	return TRUE;
}

BOOL CBcastSocket::ResetBroadcast()
{
	BOOL flag = FALSE;

	if (!SetSockOpt(SO_BROADCAST, (LPSTR)&flag, sizeof(flag)))
	{
		return FALSE;
	}

	ZeroMemory(&m_BcastAddr, sizeof(m_BcastAddr));
	m_fBcast = FALSE;

	return TRUE;
}

BOOL CBcastSocket::Broadcast(const CByteArray &data)
{
	if (!m_fBcast)
	{
		TRACE("***** ERROR: Broadcast(Socket isn't Broadcast socket) *****\n");
		return FALSE;
	}

	if (!SendTo(data, &m_BcastAddr, sizeof(m_BcastAddr)))
	{
		TRACE1("***** ERROR: Broadcast(%d) *****\n", GetLastError());
		return FALSE;
	}

	return TRUE;
}


//////////////////////////////////////////////////////////////////////////