#
# $Id: checklink_test.rb,v 1.1 2004/01/10 07:37:29 hn Exp $
# Copyright (c) Narushima Hironori.
#

require 'test/unit'

class CheckLinktest < Test::Unit::TestCase

	def setup
		@interpreter = "c:/cygwin/usr/local/bin/ruby"
		Dir.chdir( File.dirname(__FILE__) )
	end

	def test_checklink_withnet
		dir = File.dirname(__FILE__) + '/../../test_resources/webcontents_withnet'
		lines = `#{@interpreter} checklink.rb --files #{dir}`
		
		assert %r!^\thttp://! === lines
		assert %r!^\tftp://! === lines
		assert %r!^\tbx.html! === lines
		
		lines = `#{@interpreter} checklink.rb --exts html,xhtml --files #{dir}`
		assert %r!b.xhtml$! === lines
		
		lines = `#{@interpreter} checklink.rb --check_schemes ftp --files #{dir}`
		assert !(%r!^\thttp://! === lines)

		lines = `#{@interpreter} checklink.rb --ingore_link_regexp ^ftp://,foo$ --files #{dir}`
		assert !(%r!^\thttp://! === lines)
		assert !(%r!^\tftp://! === lines)
		assert %r!^\tbx.html! === lines
	end

	def test_checklink
		dir = File.dirname(__FILE__) + '/../../test_resources/webcontents'
		lines = `#{@interpreter} checklink.rb --files #{dir}`
		assert /^\tax.html,3,file not found:/ === lines
	end

end