#!/usr/local/bin/ruby

#
# $Id: checklink.rb,v 1.1 2004/01/10 07:37:29 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

=begin


command line options

  --check_schemes http,ftp ...

  --ingore_link_regexp foo.cgi

  --exts html,htm ...

  --files a.html,b.html ...


=end

dir = File::dirname(File::expand_path(__FILE__))
if $CYGWIN = (/cygwin$/ === RUBY_PLATFORM)
	require File.join( dir, 'cygpath.rb')
	dir = Cygwin::cygpath(dir)
end
libdir = File.expand_path(File.join(dir, '..' , 'lib'))
$: << libdir

require 'linkchecker/runner'

def mygetopts(argv)
	hash = {
		'check_schemes' => nil,
		'ingore_link_regexp' => nil,
		'files' => nil,
		'exts' => nil,
		'http_error_codes' => nil
	}
	while v = argv.shift
		if /^--(.+)/ === v and hash.key? $1
			 hash[$1] = argv.shift
		end
	end
	
	hash
end

runner = LinkChecker::Runner.new
opts = mygetopts(ARGV)

if schemes = opts['check_schemes']
	checkers = runner.checkers.clone
	runner.checkers.clear
	
	schemes.each { |s|
		if checker = checkers[s]
			runner.checkers[s] = checker
		else
			raise "not supported checking scheme: #{s}"
		end
	}
end

if exts = opts['exts']
	runner.check_file_extensions.clear
	exts.split(/,/).each { |ext|
		runner.check_file_extensions  << ext
	}
end

if regexps = opts['ingore_link_regexp']
	runner.ignore_link_regexp.clear
	regexps.split(/,/).each { |regexp_str|
		runner.ignore_link_regexp << Regexp.new(regexp_str)
	}
end

if code_str = opts['http_error_codes']
	codes = runner.checkers['http'].error_codes
	codes.clear
	code_str.split(/,/).each { |v|
		codes << v
	}
end

files = opts['files']

runner.run( files ? files.split(/,/) : '.')
