#
# $Id: webproject.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'singleton'
require 'webpub/eclipse_workspace'
require 'webpub/dirtools'

=begin

= publisher.rb

publisher.rb defines base classes.

=end

module WebPub

PROJECT_DESCRIPTION_FILENAME = ".webproject"

class WebProject

	def initialize(project_location)
		raise ArgumentError, 'specify location is not directory:' + project_location unless File.directory? project_location
		
		@project_location = project_location
		@config_file =  File.join(project_location, PROJECT_DESCRIPTION_FILENAME)
		
		raise ArgumentError.new('not found a project configription file:' + @config_file) unless File.file? @config_file
		
		@entries = {}
		IO.foreach(@config_file) { |line|
			@entries[$1.strip] = $2.strip if /^([^#].+?)=(.+)$/ === line
		}
		
		@htsources_dir = %r!^/! === (p = @entries['htsources_folder']) ?
			to_proj_path(p) :
			File.join(@project_location, p)
		
		@scripts_dir = %r!^/! === (p = @entries['scripts_folder']) ?
			to_proj_path(p) :
			File.join(@project_location, @entries['scripts_folder'])
		
		@publish_dir = %r!^/! === (p = @entries['publish_folder']) ?
			to_proj_path(p) :
			File.join( @project_location, p)
	end
	
	def to_proj_path(p)
		workspace = EclipseWorkspace.instance
		
		segments = p.split('/').select { |v| !v.empty? }
		proj = workspace.find_project(segments.shift)
		
		segments.unshift(proj).join('/')
	end

	attr_reader :project_location, :config_file, :htsources_dir, :scripts_dir, :publish_dir, :entries
	
end

class WebProjectManager

	include Singleton

	def initialize
		@projects_cache = {}
	end
	
	def find_web_project(res)
		DirTools.dir_iter(res) { |dir|
			if File.exist?( File.join(dir, PROJECT_DESCRIPTION_FILENAME) )
				unless proj = @projects_cache[dir]
					@projects_cache[dir] = proj = WebProject.new(dir)
				end
				return proj
			end
		}
		nil
	end
	
end


end