#
# $Id: publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'webpub/publisher'

class PublisherTest < Test::Unit::TestCase

	def setup
		@fac = WebPub::PublishDescriptionFactory.new
	end

	def test_choose_prop_from_dir
		dir = 'test_resources/webproject001/ht_sources/folder/subfolder/subsubfolder'

		prop = @fac.create(dir + '/1-1-1-1.html')
		assert_equal( 'amrita', prop.by)
		assert_equal( File.expand_path( dir + '/1-1-1-1.html'), prop.publish_from)
		assert %r!public_html/folder/subfolder/subsubfolder/1-1-1-1\.html$! === prop.publish_to
		assert_equal( 'base.rb', prop.arguments['script'] )
		assert_equal( 'Base', prop.arguments['class'] )
		assert prop.web_project
		
		prop = @fac.create(dir + '/1-1-1-2.html')
			assert %r!subsubfolder/1-1-1-2\.html$! === prop.publish_to
		assert_equal( 'base.rb', prop.arguments['script'] )
		assert_equal( 'Base', prop.arguments['class'] )
		
		prop = @fac.create(dir + '/a-1.html')
		assert %r!subsubfolder/a-1\.html$! === prop.publish_to
		assert_equal( 'base_a.rb', prop.arguments['script'] )
		assert_equal( 'base_a', prop.arguments['method'] )
		
		prop = @fac.create(dir + '/b-1.html')
		assert %r!public_html/foo_folder/b-1.html$! === prop.publish_to
		assert_equal( 'base_b.rb', prop.arguments['script'] )
		assert_equal( 'base_b', prop.arguments['method'] )
		assert_equal( 'BaseB', prop.arguments['class'] )
		
		prop = @fac.create(dir + '/c-1.html')
		assert %r!public_html/bar.html$! === prop.publish_to
		assert_equal( 'base_c.rb', prop.arguments['script'] )
		assert_nil( prop.arguments['method'] )
		assert_equal( 'BaseC', prop.arguments['class'] )
		
		
		dir = 'test_resources/webproject001/ht_sources'
		prop = @fac.create(dir + '/folder2/2-1.html')
		assert %r!public_html/folder2/2-1.html$! === prop.publish_to
		assert_equal( 'base2.rb', prop.arguments['script'] )
		
		prop = @fac.create(dir + '/folder3/3-1.html')
		assert %r!public_html/folder3/3-1.html$! === prop.publish_to
		assert_equal('copy', prop.by)

		prop = @fac.create(dir + '/folder5/erb1.html')
		assert %r!public_html/folder5/erb1.html$! === prop.publish_to
		assert_equal('erb', prop.by)
	end
	
	def test_publish_description
		fac = WebPub::PublishDescriptionFactory.new

		# <?publish by="amrita" file="home.rb" class="Home"?>
		desc = fac.create('test_resources/webproject001/ht_sources/home.html')
		assert_equal( 'amrita', desc.by )
		assert %r!test_resources/webproject001/public_html/home.html$! === desc.publish_to
		assert /^/ === desc.publish_to
		assert_equal( {'script' => 'home.rb', 'class' => 'Home'}, desc.arguments )

		# <?publish by="amrita" script="home2.rb" method="home" ?>
		desc = fac.create('test_resources/webproject001/ht_sources/home2.html')
		assert_equal( 'amrita', desc.by )
		assert %r!test_resources/webproject001/public_html/home2.html$! === desc.publish_to
		assert_equal( {'script' => 'home2.rb', 'method' => 'home'}, desc.arguments )
		
		# <?publish by="amrita" script="home3.rb" class="Home" method="home" publish_to="foo/home.html"?>
		desc = fac.create('test_resources/webproject001/ht_sources/home3.html')
		assert_equal( 'amrita', desc.by )
		assert %r!test_resources/webproject001/public_html/foo/home.html$! === desc.publish_to
		assert_equal( {'script' => 'home3.rb', 'class' => 'Home', 'method'=>'home'}, desc.arguments )
	end

end
