#
# $Id: publish_manager.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/rftools'
require 'webpub/publisher'

=begin

= PublishManager class

PublishManager for command line tools.

pubkey_a,/foo/bar/publish_script.rb,PublishClassA
pubkey_b,/foo/bar/publish_script.rb,PublishClassB

=end

module WebPub

class PublishManager

	COMPLETE_CODE = '!!complete!!'
	BEGIN_ERROR_CODE = '!!begin-error!!'
	END_ERROR_CODE = '!!end-error!!'

	def initialize(prop_file)
		@publishers = {}
		IO.foreach(prop_file) { |l|
			vals = l.split(/,/)
			raise ArgumentError, "invalid property file: #{prop_file}" unless vals.size == 3
			
			by, script, klass = *vals.map{ |v| v.strip }
			@publishers[by] = {'script' => script, 'class' => klass, 'instance' => nil }
		}
		@factory = PublishDescriptionFactory.new
	end

	def publish(files, by_orders = nil)
		requests = {}
		
		files.each { |f|
			if desc = @factory.create(f)
				by = desc.by
				if !by_orders or by_orders.include?(by)
					# create directories
					to = desc.publish_to
					to = File.dirname(to) unless /\/$/ === to
					Dir.mkdirs to
					
					# add to requests
					requests[by] = [] unless requests[by]
					requests[by] << desc
				end
			end
		}
		
		requests.each { |by, descriptions|
			unless pubinfo = @publishers[by]
				raise "not found publish tool by:" + by
			end
			
			unless publisher = pubinfo['instance']
				require pubinfo['script']
				publisher = pubinfo['instance'] = eval(pubinfo['class']).new
			end
			
			descriptions.each { |desc|
				begin
					publisher.publish( desc)
				rescue Exception
					error_lines = BEGIN_ERROR_CODE + "#{desc.publish_from} #{desc.publish_to} #{desc.by}\n" +
						$!.message + "\n" +
						$!.backtrace.join("\n") + "\n" +
						END_ERROR_CODE + "\n"
					
					$stdout << error_lines
					next
				end
				$stdout << COMPLETE_CODE + "#{desc.publish_from} #{desc.publish_to} #{desc.by}\n"
			}
		}
	end
	
end

end