#
# $Id: install_checker_manager.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/install_checker'

module WebPub

class InstallCheckerManager

	def self.new_as_args(args)
		mgr = InstallCheckerManager.new
		
		0.step(args.length-1, 3) { |i|
			name = args[i]
			require args[i+1]
			mgr.checkers[name] = eval(args[i+2]).new
		}
		mgr
	end

	def initialize
		@checkers = {}
	end
	
	attr_reader :checkers

	def do_check
		@checkers.map { |name, checker|
			res = checker.check
			if res and !res.is_a?(Array)
				res = [res.to_s, InstallChecker::ERROR]
			end
			res = ['succeed', InstallChecker::NONE] unless res
			
			res.unshift(name)
		}
	end

	def expand_result(distfile)
		open(distfile, 'w') { |fh|
			do_check.each { |res|
				fh << res.join(',') + "\n"
			}
		}
	end

end

end