require 'rexml/document'
require 'rexml/streamlistener'
require 'time'

module Articler

class ArticleChooser

	def initialize(file)
		@file = file
		@cache = nil
	end

	def choose(use_cache = true)
		return @cache if use_cache and @cache
		
		@cache = []
		doc = REXML::Document.new( File.new(@file) )
		doc.root.each_element { |e|
			next unless e.name == 'item'
			@cache << create_item( e)
		}
		@cache.sort! { |a, b| b[:date] <=> a[:date] }
		@cache
	end

	def create_item( e)
		attr = e.attributes
		
		date = attr['date']
		title = attr['title']
		url = attr['url']
		desc = e.elements['description'].children.map { |e| e.to_s }.join \
			.gsub(/\n/, "\\n").gsub(/\s*\\n\s*/, "\\n").gsub(/\\n/, "\n").strip
		
		{	:title => title,
			:date => Time.parse(date),
			:url => url,
			:description => desc
		}
	end

end

end