#
# $Id: navigatable_page.rb,v 1.1 2004/01/17 12:02:34 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'amrita/node_expand'
require 'amrita/template'
require 'amritatmpl/abstract_page'
require 'sitemapper/navigation'

class NavigatablePage < AbstractPage

	def initialize( desc, toc_file = 'toc.xml')
		super()
		@description = desc
		@toc_file = toc_file
		@navigation_factory = nil
		
		# Initialize link types
		@link_types = %w[up next prev]

		@hierarchy_types =
			%w[start chapter section subsection subsubsection subsubsubsection]

		(@link_types + @hierarchy_types).each { |k|
			self[k + '_title'] = nil
			self[k + '_url'] = nil
		
			# Sets method that name is link types key.
			# Return ture if setted self[:key_title] and self[:key_url]; else returns nil.
			method = <<-EOM
				def #{k}
					self[:#{k}_title] ?
						{:#{k}_title => self[:#{k}_title], :#{k}_url => self[:#{k}_url] } :
						nil
				end
			EOM
			eval method
		}
		
		# appends data
		wp = desc.web_project
		tocfile = File.join( wp.project_location, @toc_file)
		
		if File.exist? tocfile
			@navigation_factory = SiteMapper::NavigatorFactory.new(tocfile)
			
			relpath = desc.publish_to.gsub(/^#{wp.publish_dir}/, '')
			if navi = @navigation_factory.create_from_path(relpath)
				navi.each { |k, v|
					self[k] = v
				}
			end
		end
		
	end


end
