require 'amritatmpl/navigatable_page'
require 'articler/article_chooser'

class Base < NavigatablePage

	def initialize(desc)
		super(desc)
		@begining = Time.gm(2003, 8, 30)
		
		@link_types.each { |k|
			self[k + '_title'] = nil unless self[k + '_url']
		}
	end

	def last_update
		strftime(Time.now)
	end
	
	def strftime(time)
		time = Time.parse(time) if time.instance_of? String
		time.strftime('%Y/%m/%d')
	end

	def years
		now = Time.now
		@begining.year == now.year ?  now.year.to_s : "#{@begining.year}-#{now.year}"
	end

	def para( msg)
		Amrita::SanitizedString[ '<p>' + msg.split(%r!\n\n+!).join('</p><p>') + '</p>']
	end

	def all_articles
		webpub_news = Articler::ArticleChooser.new('datas/updates.xml')
		webpub_news.choose.sort{ |a, b| b[:date] <=> a[:date] }
	end

end