/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.toc;

import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.PlatformObject;

public class Topic
extends PlatformObject {
    public static final String HREF = "href";
    public static final String LABEL = "label";
    ArrayList topics = new ArrayList();
    Topic parent = null;
    HashMap attributes = new HashMap();

    protected Topic(String href, String label, Topic parent) {
        this.setParent(parent);
        this.setAttribute(HREF, href);
        this.setAttribute(LABEL, label);
    }

    protected void setParent(Topic parent) {
        if (this instanceof Toc) {
            return;
        }
        if (parent == null) {
            throw new IllegalArgumentException("Null argument");
        }
        this.parent = parent;
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        Object v = this.attributes.get(key);
        if (v == value || (v != null ? v.equals(value) : value.equals(v))) {
            return;
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.getToc().stockEvent(new TocEvent(2, this, this.parent, this.parent != null ? this.parent.indexOf(this) : -1));
    }

    public String[] getAttributeKeys() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getHref() {
        return this.getAttribute(HREF);
    }

    public String getLabel() {
        return this.getAttribute(LABEL);
    }

    public void setHref(String string) {
        this.setAttribute(HREF, string);
    }

    public void setLabel(String string) {
        this.setAttribute(LABEL, string);
    }

    public void addTopic(Topic topic) {
        this.addTopic(this.topics.size(), topic);
    }

    public void addTopic(int index, Topic topic) {
        this.topics.add(index, topic);
        topic.setParent(this);
        this.getToc().stockEvent(new TocEvent(0, topic, this, index));
    }

    public void removeTopic(Topic topic) {
        int index = this.topics.indexOf((Object)topic);
        if (index != -1) {
            this.topics.remove(index);
            this.getToc().stockEvent(new TocEvent(1, topic, this, index));
        }
    }

    public Topic[] getSubtopics() {
        return this.topics.toArray(new Topic[this.topics.size()]);
    }

    public int getSubtopicCount() {
        return this.topics.size();
    }

    public boolean hasSubtopics() {
        return !this.topics.isEmpty();
    }

    public Topic getParent() {
        return this.parent;
    }

    public int indexOf(Topic t) {
        return this.topics.indexOf((Object)t);
    }

    public Topic getNextTopic(boolean overLevel) {
        Topic[] topics = overLevel ? this.getToc().getAllTopics() : (this.parent != null ? this.parent.getSubtopics() : null);
        int i = 0;
        while (topics != null && i < topics.length - 1) {
            if (topics[i].equals((Object)this)) {
                return topics[i + 1];
            }
            ++i;
        }
        return null;
    }

    public Topic getPrevTopic(boolean overLevel) {
        Topic[] topics = overLevel ? this.getToc().getAllTopics() : (this.parent != null ? this.parent.getSubtopics() : null);
        int i = 1;
        while (topics != null && i < topics.length) {
            if (topics[i].equals((Object)this)) {
                return topics[i - 1];
            }
            ++i;
        }
        return null;
    }

    public boolean moveUp() {
        int index = this.parent.indexOf(this);
        if (index > 0) {
            this.parent.removeTopic(this);
            this.parent.addTopic(index - 1, this);
            return true;
        }
        return false;
    }

    public boolean moveDown() {
        try {
            int index = this.parent.indexOf(this);
            if (index < this.parent.getSubtopicCount() - 1) {
                this.parent.removeTopic(this);
                this.parent.addTopic(index + 1, this);
                return true;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean levelUp() {
        Topic p = this.parent;
        p.indexOf(this);
        Topic newParent = this.getPrevTopic(false);
        if (newParent != null) {
            this.parent.removeTopic(this);
            newParent.addTopic(newParent.getSubtopicCount(), this);
            return true;
        }
        return false;
    }

    public boolean levelDown() {
        Topic p = this.parent;
        p.indexOf(this);
        Topic parentOfParent = p.getParent();
        if (parentOfParent != null) {
            int index = parentOfParent.indexOf(p);
            p.removeTopic(this);
            parentOfParent.addTopic(index + 1, this);
            return true;
        }
        return false;
    }

    public Toc getToc() {
        Topic t = this;
        while (t != null) {
            if (t instanceof Toc) {
                return (Toc)t;
            }
            t = t.getParent();
        }
        return null;
    }

    public Topic createTopic(String href, String label) {
        Topic topic = new Topic(href, label, this);
        this.addTopic(topic);
        return topic;
    }

    public boolean equals(Object obj) {
        if (obj == null || !((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        Topic other = (Topic)((Object)obj);
        String[] keys = this.getAttributeKeys();
        int i = 0;
        while (i < keys.length) {
            String k = keys[i];
            if (!this.getAttribute(k).equals(other.getAttribute(k))) {
                return false;
            }
            ++i;
        }
        Topic[] topics = this.getSubtopics();
        Topic[] otherTopics = other.getSubtopics();
        return Arrays.equals((Object[])topics, (Object[])otherTopics);
    }

    public Object clone() {
        Topic newTopic = new Topic(this.getHref(), this.getLabel(), this.parent);
        String[] keys = this.getAttributeKeys();
        int i = 0;
        while (i < keys.length) {
            String k = keys[i];
            newTopic.setAttribute(k, this.getAttribute(k));
            ++i;
        }
        Topic[] ts = this.getSubtopics();
        int i2 = 0;
        while (i2 < ts.length) {
            newTopic.addTopic((Topic)((Object)ts[i2].clone()));
            ++i2;
        }
        return newTopic;
    }
}

